/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.service;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.StaticUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.BatchOperation;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.slf4j.Logger;
import org.xdi.ldap.model.SearchScope;
import org.xdi.ldap.model.SimpleBranch;
import org.xdi.oxauth.model.config.StaticConfiguration;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.uma.UmaPermissionList;
import org.xdi.oxauth.model.uma.persistence.UmaPermission;
import org.xdi.oxauth.uma.service.UmaScopeService;
import org.xdi.util.INumGenerator;

@Stateless
@Named
public class UmaPermissionService {
    private static final String ORGUNIT_OF_RESOURCE_PERMISSION = "uma_permission";
    private static final int DEFAULT_TICKET_LIFETIME = 3600;
    @Inject
    private Logger log;
    @Inject
    private LdapEntryManager ldapEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private UmaScopeService scopeService;
    @Inject
    private AppConfiguration appConfiguration;

    public static String getDn(String clientDn, String ticket) {
        return String.format("oxTicket=%s,%s", ticket, UmaPermissionService.getBranchDn(clientDn));
    }

    public static String getBranchDn(String clientDn) {
        return String.format("ou=%s,%s", ORGUNIT_OF_RESOURCE_PERMISSION, clientDn);
    }

    private List<UmaPermission> createPermissions(UmaPermissionList permissions, Date expirationDate) {
        String configurationCode = INumGenerator.generate((int)8) + "." + System.currentTimeMillis();
        String ticket = this.generateNewTicket();
        ArrayList<UmaPermission> result = new ArrayList<UmaPermission>();
        for (org.xdi.oxauth.model.uma.UmaPermission permission : permissions) {
            UmaPermission p = new UmaPermission(permission.getResourceId(), this.scopeService.getScopeDNsByIdsAndAddToLdapIfNeeded(permission.getScopes()), ticket, configurationCode, expirationDate);
            if (permission.getParams() != null && !permission.getParams().isEmpty()) {
                p.getAttributes().putAll(permission.getParams());
            }
            result.add(p);
        }
        return result;
    }

    public String generateNewTicket() {
        return UUID.randomUUID().toString();
    }

    public String addPermission(UmaPermissionList permissionList, String clientDn) throws Exception {
        try {
            List<UmaPermission> created = this.createPermissions(permissionList, this.ticketExpirationDate());
            for (UmaPermission permission : created) {
                this.addPermission(permission, clientDn);
            }
            return created.get(0).getTicket();
        }
        catch (Exception e) {
            this.log.trace(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public Date ticketExpirationDate() {
        int lifeTime = this.appConfiguration.getUmaTicketLifetime();
        if (lifeTime <= 0) {
            lifeTime = 3600;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, lifeTime);
        return calendar.getTime();
    }

    public void addPermission(UmaPermission permission, String clientDn) {
        try {
            this.addBranchIfNeeded(clientDn);
            permission.setDn(UmaPermissionService.getDn(clientDn, permission.getTicket()));
            this.ldapEntryManager.persist((Object)permission);
        }
        catch (Exception e) {
            this.log.trace(e.getMessage(), (Throwable)e);
        }
    }

    public void merge(UmaPermission permission) {
        this.ldapEntryManager.merge((Object)permission);
    }

    public void mergeSilently(UmaPermission permission) {
        try {
            this.ldapEntryManager.merge((Object)permission);
        }
        catch (Exception e) {
            this.log.error("Failed to persist permission: " + permission, (Throwable)e);
        }
    }

    public List<UmaPermission> getPermissionsByTicket(String ticket) {
        try {
            String baseDn = this.staticConfiguration.getBaseDn().getClients();
            Filter filter = Filter.create((String)String.format("&(oxTicket=%s)", ticket));
            return this.ldapEntryManager.findEntries(baseDn, UmaPermission.class, filter);
        }
        catch (Exception e) {
            this.log.trace(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getPermissionTicketByConfigurationCode(String configurationCode, String clientDn) {
        UmaPermission permission = this.getPermissionByConfigurationCode(configurationCode, clientDn);
        if (permission != null) {
            return permission.getTicket();
        }
        return null;
    }

    public UmaPermission getPermissionByConfigurationCode(String p_configurationCode, String clientDn) {
        try {
            Filter filter = Filter.create((String)String.format("&(oxConfigurationCode=%s)", p_configurationCode));
            List entries = this.ldapEntryManager.findEntries(clientDn, UmaPermission.class, filter);
            if (entries != null && !entries.isEmpty()) {
                return (UmaPermission)entries.get(0);
            }
        }
        catch (Exception e) {
            this.log.trace(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void deletePermission(String ticket) {
        try {
            List<UmaPermission> permissions = this.getPermissionsByTicket(ticket);
            for (UmaPermission p : permissions) {
                this.ldapEntryManager.remove((Object)p);
            }
        }
        catch (Exception e) {
            this.log.trace(e.getMessage(), (Throwable)e);
        }
    }

    public void cleanup(final Date now) {
        BatchOperation<UmaPermission> batchService = new BatchOperation<UmaPermission>(this.ldapEntryManager){

            protected List<UmaPermission> getChunkOrNull(int chunkSize) {
                return UmaPermissionService.this.ldapEntryManager.findEntries(UmaPermissionService.this.staticConfiguration.getBaseDn().getClients(), UmaPermission.class, this.getFilter(), SearchScope.SUB, null, (BatchOperation)this, 0, chunkSize, chunkSize);
            }

            protected void performAction(List<UmaPermission> entries) {
                for (UmaPermission p : entries) {
                    try {
                        UmaPermissionService.this.ldapEntryManager.remove((Object)p);
                    }
                    catch (Exception e) {
                        UmaPermissionService.this.log.error("Failed to remove entry", (Throwable)e);
                    }
                }
            }

            private Filter getFilter() {
                try {
                    return Filter.create((String)String.format("(oxAuthExpiration<=%s)", StaticUtils.encodeGeneralizedTime((Date)now)));
                }
                catch (LDAPException e) {
                    UmaPermissionService.this.log.trace(e.getMessage(), (Throwable)e);
                    return Filter.createPresenceFilter((String)"oxAuthExpiration");
                }
            }
        };
        batchService.iterateAllByChunks(25);
    }

    public void addBranch(String clientDn) {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName(ORGUNIT_OF_RESOURCE_PERMISSION);
        branch.setDn(UmaPermissionService.getBranchDn(clientDn));
        this.ldapEntryManager.persist((Object)branch);
    }

    public void addBranchIfNeeded(String clientDn) {
        if (!this.containsBranch(clientDn)) {
            this.addBranch(clientDn);
        }
    }

    public boolean containsBranch(String clientDn) {
        return this.ldapEntryManager.contains(SimpleBranch.class, UmaPermissionService.getBranchDn(clientDn));
    }

    public String changeTicket(List<UmaPermission> permissions, Map<String, String> attributes) {
        String newTicket = this.generateNewTicket();
        for (UmaPermission permission : permissions) {
            this.ldapEntryManager.remove((Object)permission);
            String dn = String.format("oxTicket=%s,%s", newTicket, StringUtils.substringAfter((String)permission.getDn(), (String)","));
            permission.setTicket(newTicket);
            permission.setDn(dn);
            permission.setAttributes(attributes);
            this.ldapEntryManager.persist((Object)permission);
        }
        return newTicket;
    }
}

