/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.xdi.model.custom.script.conf.CustomScriptConfiguration;
import org.xdi.model.uma.ClaimDefinition;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.uma.UmaNeedInfoResponse;
import org.xdi.oxauth.model.uma.persistence.UmaPermission;
import org.xdi.oxauth.model.uma.persistence.UmaScopeDescription;
import org.xdi.oxauth.service.AttributeService;
import org.xdi.oxauth.service.UserService;
import org.xdi.oxauth.service.external.ExternalUmaRptPolicyService;
import org.xdi.oxauth.uma.authorization.Claims;
import org.xdi.oxauth.uma.authorization.UmaAuthorizationContext;
import org.xdi.oxauth.uma.authorization.UmaAuthorizationContextBuilder;
import org.xdi.oxauth.uma.authorization.UmaPCT;
import org.xdi.oxauth.uma.authorization.UmaScriptByScope;
import org.xdi.oxauth.uma.service.UmaPermissionService;
import org.xdi.oxauth.uma.service.UmaResourceService;
import org.xdi.oxauth.uma.service.UmaSessionService;
import org.xdi.oxauth.util.ServerUtil;

@Stateless
@Named
public class UmaNeedsInfoService {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private UmaPermissionService permissionService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private UmaResourceService resourceService;
    @Inject
    private ExternalUmaRptPolicyService policyService;
    @Inject
    private UmaSessionService sessionService;
    @Inject
    private UserService userService;

    public Map<UmaScriptByScope, UmaAuthorizationContext> checkNeedsInfo(Claims claims, Map<UmaScopeDescription, Boolean> requestedScopes, List<UmaPermission> permissions, UmaPCT pct, HttpServletRequest httpRequest, Client client) {
        HashMap<UmaScriptByScope, UmaAuthorizationContext> scriptMap = new HashMap<UmaScriptByScope, UmaAuthorizationContext>();
        HashMap<String, String> ticketAttributes = new HashMap<String, String>();
        ArrayList<ClaimDefinition> missedClaims = new ArrayList<ClaimDefinition>();
        UmaAuthorizationContextBuilder contextBuilder = new UmaAuthorizationContextBuilder(this.appConfiguration, this.attributeService, this.resourceService, permissions, requestedScopes, claims, httpRequest, this.sessionService, this.userService, this.permissionService, client);
        for (UmaScopeDescription scope : requestedScopes.keySet()) {
            List authorizationPolicies = scope.getAuthorizationPolicies();
            if (authorizationPolicies != null && !authorizationPolicies.isEmpty()) {
                for (String scriptDN : authorizationPolicies) {
                    CustomScriptConfiguration script = this.policyService.getScriptByDn(scriptDN);
                    if (script != null) {
                        String claimsGatheringScriptName;
                        UmaAuthorizationContext context = contextBuilder.build(script);
                        scriptMap.put(new UmaScriptByScope(scope, script), context);
                        List<ClaimDefinition> requiredClaims = this.policyService.getRequiredClaims(script, context);
                        if (requiredClaims != null && !requiredClaims.isEmpty()) {
                            for (ClaimDefinition definition : requiredClaims) {
                                if (claims.has(definition.getName())) continue;
                                missedClaims.add(definition);
                            }
                        }
                        if (StringUtils.isNotBlank((String)(claimsGatheringScriptName = this.policyService.getClaimsGatheringScriptName(script, context)))) {
                            ticketAttributes.put("gathering_id", this.constructGatheringScriptNameValue((String)ticketAttributes.get("gathering_id"), claimsGatheringScriptName));
                            continue;
                        }
                        if ("no_script".equalsIgnoreCase(claimsGatheringScriptName)) continue;
                        this.log.error("External 'getClaimsGatheringScriptName' script method return null or blank value, script: " + script.getName());
                        continue;
                    }
                    this.log.error("Unable to load UMA script dn: '{}'", (Object)scriptDN);
                }
                continue;
            }
            this.log.trace("No policies defined for scope: " + scope.getId() + ", scopeDn: " + scope.getDn());
        }
        if (!missedClaims.isEmpty()) {
            ticketAttributes.put("pct", pct.getCode());
            String newTicket = this.permissionService.changeTicket(permissions, ticketAttributes);
            UmaNeedInfoResponse needInfoResponse = new UmaNeedInfoResponse();
            needInfoResponse.setTicket(newTicket);
            needInfoResponse.setError("need_info");
            needInfoResponse.setRedirectUser(this.buildClaimsGatheringRedirectUri(scriptMap.values(), client, newTicket));
            needInfoResponse.setRequiredClaims(missedClaims);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ServerUtil.asJsonSilently(needInfoResponse)).build());
        }
        return scriptMap;
    }

    private String constructGatheringScriptNameValue(String existingValue, String claimsGatheringScriptName) {
        if (StringUtils.isBlank((String)existingValue)) {
            return claimsGatheringScriptName;
        }
        return existingValue + " " + claimsGatheringScriptName;
    }

    private String buildClaimsGatheringRedirectUri(Collection<UmaAuthorizationContext> contexts, Client client, String newTicket) {
        String queryParameters = "";
        for (UmaAuthorizationContext context : contexts) {
            queryParameters = queryParameters + context.getRedirectUserParameters().buildQueryString() + "&";
        }
        queryParameters = StringUtils.removeEnd((String)queryParameters, (String)"&");
        String result = this.appConfiguration.getBaseEndpoint() + "/uma/gather_claims";
        if (StringUtils.isNotBlank((String)queryParameters)) {
            result = result + "?" + queryParameters;
        }
        result = result + "&client_id=" + client.getClientId() + "&ticket=" + newTicket;
        return result;
    }

    public static Set<String> getScriptDNs(List<UmaScopeDescription> scopes) {
        HashSet<String> result = new HashSet<String>();
        for (UmaScopeDescription scope : scopes) {
            List authorizationPolicies = scope.getAuthorizationPolicies();
            if (authorizationPolicies == null) continue;
            result.addAll(authorizationPolicies);
        }
        return result;
    }
}

