/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.authorization;

import java.net.URI;
import java.net.URLEncoder;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.uma.UmaErrorResponse;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;

public class UmaWebException
extends WebApplicationException {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmaWebException.class);

    public UmaWebException(Response.Status status, ErrorResponseFactory factory, UmaErrorResponseType error) {
        super(Response.status((Response.Status)status).entity((Object)factory.getUmaJsonErrorResponse((IErrorType)error)).build());
    }

    public UmaWebException(String redirectUri, ErrorResponseFactory factory, UmaErrorResponseType error, String state) {
        super(UmaWebException.createRedirectErrorResponse(redirectUri, factory, error, state));
    }

    public static Response createRedirectErrorResponse(String redirectUri, ErrorResponseFactory factory, UmaErrorResponseType errorType, String state) {
        return Response.status((Response.Status)Response.Status.FOUND).location(UmaWebException.createErrorUri(redirectUri, factory, errorType, state)).build();
    }

    public static URI createErrorUri(String redirectUri, ErrorResponseFactory factory, UmaErrorResponseType errorType, String state) {
        try {
            UmaErrorResponse error = factory.getUmaErrorResponse((IErrorType)errorType);
            redirectUri = redirectUri.contains("?") ? redirectUri + "&" : redirectUri + "?";
            redirectUri = redirectUri + "error=" + error.getError();
            redirectUri = redirectUri + "&error_description=" + URLEncoder.encode(error.getErrorDescription(), "UTF-8");
            if (StringUtils.isNotBlank((String)error.getErrorUri())) {
                redirectUri = redirectUri + "&error_uri=" + URLEncoder.encode(error.getErrorUri(), "UTF-8");
            }
            if (StringUtils.isNotBlank((String)state)) {
                redirectUri = redirectUri + "&state=" + state;
            }
            return new URI(redirectUri);
        }
        catch (Exception e) {
            LOGGER.error("Failed to construct uri: " + redirectUri, (Throwable)e);
            throw new UmaWebException(Response.Status.INTERNAL_SERVER_ERROR, factory, UmaErrorResponseType.SERVER_ERROR);
        }
    }
}

