/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.authorization;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONObject;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapDN;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.oxauth.model.common.AbstractToken;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwt.JwtClaims;

@LdapEntry
@LdapObjectClass(values={"top", "oxAuthUmaPCT"})
public class UmaPCT
extends AbstractToken {
    private static final Logger log = LoggerFactory.getLogger(UmaPCT.class);
    @LdapDN
    private String dn;
    @LdapAttribute(name="oxAuthClientId")
    private String clientId;
    @LdapAttribute(name="oxClaimValues")
    private String claimValuesAsJson;

    public UmaPCT() {
        super(2592000);
    }

    public UmaPCT(int lifeTime) {
        super(lifeTime);
    }

    protected UmaPCT(String code, Date creationDate, Date expirationDate) {
        super(code, creationDate, expirationDate);
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClaimValuesAsJson() {
        return this.claimValuesAsJson;
    }

    public void setClaimValuesAsJson(String claimValuesAsJson) {
        this.claimValuesAsJson = claimValuesAsJson;
    }

    public JwtClaims getClaims() {
        try {
            return StringUtils.isNotBlank((String)this.claimValuesAsJson) ? new JwtClaims(new JSONObject(this.claimValuesAsJson)) : new JwtClaims();
        }
        catch (Exception e) {
            log.error("Failed to parse PCT claims. " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setClaims(JwtClaims claims) throws InvalidJwtException {
        this.claimValuesAsJson = claims != null ? claims.toJsonString() : null;
    }
}

