/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.authorization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.gluu.jsf2.service.FacesService;
import org.xdi.model.SimpleCustomProperty;
import org.xdi.oxauth.model.common.SessionId;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwt.JwtClaims;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.uma.persistence.UmaPermission;
import org.xdi.oxauth.service.UserService;
import org.xdi.oxauth.service.external.context.ExternalScriptContext;
import org.xdi.oxauth.uma.authorization.UmaPCT;
import org.xdi.oxauth.uma.service.RedirectParameters;
import org.xdi.oxauth.uma.service.UmaPctService;
import org.xdi.oxauth.uma.service.UmaPermissionService;
import org.xdi.oxauth.uma.service.UmaSessionService;

public class UmaGatherContext
extends ExternalScriptContext {
    private final UmaSessionService sessionService;
    private final UmaPermissionService permissionService;
    private final UmaPctService pctService;
    private final UserService userService;
    private final FacesService facesService;
    private final Map<String, SimpleCustomProperty> configurationAttributes;
    private final AppConfiguration appConfiguration;
    private final SessionId session;
    private final RedirectParameters redirectUserParameters = new RedirectParameters();
    private final UmaPCT pct;
    private final JwtClaims claims;
    private final Map<String, String> pageClaims;
    private String redirectToExternalUrl = null;

    public UmaGatherContext(Map<String, SimpleCustomProperty> configurationAttributes, HttpServletRequest httpRequest, SessionId session, UmaSessionService sessionService, UmaPermissionService permissionService, UmaPctService pctService, Map<String, String> pageClaims, UserService userService, FacesService facesService, AppConfiguration appConfiguration) {
        super(httpRequest);
        this.configurationAttributes = configurationAttributes;
        this.session = session;
        this.sessionService = sessionService;
        this.permissionService = permissionService;
        this.userService = userService;
        this.pctService = pctService;
        this.facesService = facesService;
        this.pct = pctService.getByCode(sessionService.getPct(session));
        this.claims = this.pct.getClaims();
        this.pageClaims = pageClaims;
        this.appConfiguration = appConfiguration;
    }

    public Map<String, SimpleCustomProperty> getConfigurationAttributes() {
        return this.configurationAttributes;
    }

    public User getUser(String ... returnAttributes) {
        return this.sessionService.getUser(this.httpRequest, returnAttributes);
    }

    public String getUserDn() {
        return this.sessionService.getUserDn(this.httpRequest);
    }

    public Client getClient() {
        return this.sessionService.getClient(this.session);
    }

    public Map<String, String> getConnectSessionAttributes() {
        SessionId connectSession = this.sessionService.getConnectSession(this.httpRequest);
        if (connectSession != null) {
            return new HashMap<String, String>(connectSession.getSessionAttributes());
        }
        return new HashMap<String, String>();
    }

    public boolean isAuthenticated() {
        return this.getUser(new String[0]) != null;
    }

    public Map<String, String> getPageClaims() {
        return this.pageClaims;
    }

    public Map<String, String[]> getRequestParameters() {
        return this.httpRequest.getParameterMap();
    }

    public int getStep() {
        return this.sessionService.getStep(this.session);
    }

    public void setStep(int step) {
        this.sessionService.setStep(step, this.session);
    }

    public void addSessionAttribute(String key, String value) {
        this.session.getSessionAttributes().put(key, value);
    }

    public void removeSessionAttribute(String key) {
        this.session.getSessionAttributes().remove(key);
    }

    public Map<String, String> getSessionAttributes() {
        return this.session.getSessionAttributes();
    }

    public void addRedirectUserParam(String paramName, String paramValue) {
        this.redirectUserParameters.add(paramName, paramValue);
    }

    public void removeRedirectUserParameter(String paramName) {
        this.redirectUserParameters.remove(paramName);
    }

    public RedirectParameters getRedirectUserParameters() {
        return this.redirectUserParameters;
    }

    public Map<String, Set<String>> getRedirectUserParametersMap() {
        return this.redirectUserParameters.map();
    }

    public List<UmaPermission> getPermissions() {
        return this.permissionService.getPermissionsByTicket(this.sessionService.getTicket(this.session));
    }

    public JwtClaims getClaims() {
        return this.claims;
    }

    public Object getClaim(String claimName) {
        return this.claims.getClaim(claimName);
    }

    public void putClaim(String claimName, Object claimValue) {
        this.claims.setClaimObject(claimName, claimValue, true);
    }

    public void removeClaim(String claimName) {
        this.claims.removeClaim(claimName);
    }

    public boolean hasClaim(String claimName) {
        return this.getClaim(claimName) != null;
    }

    public void persist() {
        try {
            this.pct.setClaims(this.claims);
        }
        catch (InvalidJwtException e) {
            this.getLog().error("Failed to persist claims", (Throwable)e);
        }
        this.sessionService.persist(this.session);
        this.pctService.merge(this.pct);
    }

    public void redirectToExternalUrl(String url) {
        this.redirectToExternalUrl = url;
    }

    public String getRedirectToExternalUrl() {
        return this.redirectToExternalUrl;
    }

    public String getAuthorizationEndpoint() {
        return this.appConfiguration.getAuthorizationEndpoint();
    }

    public String getIssuer() {
        return this.appConfiguration.getIssuer();
    }

    public String getBaseEndpoint() {
        return this.appConfiguration.getBaseEndpoint();
    }

    public String getClaimsGatheringEndpoint() {
        return this.getBaseEndpoint() + "/uma/gather_claims";
    }
}

