/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.authorization;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.xdi.model.custom.script.conf.CustomScriptConfiguration;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.uma.persistence.UmaPermission;
import org.xdi.oxauth.model.uma.persistence.UmaResource;
import org.xdi.oxauth.model.uma.persistence.UmaScopeDescription;
import org.xdi.oxauth.service.AttributeService;
import org.xdi.oxauth.service.UserService;
import org.xdi.oxauth.uma.authorization.Claims;
import org.xdi.oxauth.uma.authorization.UmaAuthorizationContext;
import org.xdi.oxauth.uma.service.UmaPermissionService;
import org.xdi.oxauth.uma.service.UmaResourceService;
import org.xdi.oxauth.uma.service.UmaSessionService;

public class UmaAuthorizationContextBuilder {
    private final AttributeService attributeService;
    private final UmaResourceService resourceService;
    private final List<UmaPermission> permissions;
    private final Map<UmaScopeDescription, Boolean> scopes;
    private final Claims claims;
    private final HttpServletRequest httpRequest;
    private final AppConfiguration configuration;
    private final UmaSessionService sessionService;
    private final UserService userService;
    private final UmaPermissionService permissionService;
    private final Client client;

    public UmaAuthorizationContextBuilder(AppConfiguration configuration, AttributeService attributeService, UmaResourceService resourceService, List<UmaPermission> permissions, Map<UmaScopeDescription, Boolean> scopes, Claims claims, HttpServletRequest httpRequest, UmaSessionService sessionService, UserService userService, UmaPermissionService permissionService, Client client) {
        this.configuration = configuration;
        this.attributeService = attributeService;
        this.resourceService = resourceService;
        this.permissions = permissions;
        this.client = client;
        this.scopes = scopes;
        this.claims = claims;
        this.httpRequest = httpRequest;
        this.sessionService = sessionService;
        this.userService = userService;
        this.permissionService = permissionService;
    }

    public UmaAuthorizationContext build(CustomScriptConfiguration script) {
        return new UmaAuthorizationContext(this.configuration, this.attributeService, this.scopes, this.getResources(), this.claims, script.getCustomScript().getDn(), this.httpRequest, script.getConfigurationAttributes(), this.sessionService, this.userService, this.permissionService, this.client);
    }

    public Set<String> getResourceIds() {
        HashSet<String> result = new HashSet<String>();
        for (UmaPermission permission : this.permissions) {
            result.add(permission.getResourceId());
        }
        return result;
    }

    public Set<UmaResource> getResources() {
        return this.resourceService.getResources(this.getResourceIds());
    }
}

