/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.authorization;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.xdi.model.SimpleCustomProperty;
import org.xdi.oxauth.model.common.SessionId;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.uma.persistence.UmaPermission;
import org.xdi.oxauth.model.uma.persistence.UmaResource;
import org.xdi.oxauth.model.uma.persistence.UmaScopeDescription;
import org.xdi.oxauth.service.AttributeService;
import org.xdi.oxauth.service.UserService;
import org.xdi.oxauth.service.external.context.ExternalScriptContext;
import org.xdi.oxauth.uma.authorization.Claims;
import org.xdi.oxauth.uma.service.RedirectParameters;
import org.xdi.oxauth.uma.service.UmaPermissionService;
import org.xdi.oxauth.uma.service.UmaSessionService;

public class UmaAuthorizationContext
extends ExternalScriptContext {
    private final Claims claims;
    private final Map<UmaScopeDescription, Boolean> scopes;
    private final Set<UmaResource> resources;
    private final String scriptDn;
    private final Map<String, SimpleCustomProperty> configurationAttributes;
    private final RedirectParameters redirectUserParameters = new RedirectParameters();
    private final AppConfiguration configuration;
    private final AttributeService attributeService;
    private final UmaSessionService sessionService;
    private final UserService userService;
    private final UmaPermissionService permissionService;
    private final Client client;

    public UmaAuthorizationContext(AppConfiguration configuration, AttributeService attributeService, Map<UmaScopeDescription, Boolean> scopes, Set<UmaResource> resources, Claims claims, String scriptDn, HttpServletRequest httpRequest, Map<String, SimpleCustomProperty> configurationAttributes, UmaSessionService sessionService, UserService userService, UmaPermissionService permissionService, Client client) {
        super(httpRequest);
        this.configuration = configuration;
        this.attributeService = attributeService;
        this.sessionService = sessionService;
        this.userService = userService;
        this.permissionService = permissionService;
        this.client = client;
        this.scopes = new HashMap<UmaScopeDescription, Boolean>(scopes);
        this.resources = resources;
        this.claims = claims;
        this.scriptDn = scriptDn;
        this.configurationAttributes = configurationAttributes != null ? configurationAttributes : new HashMap();
    }

    public String getClaimToken() {
        return this.getClaims().getClaimsTokenAsString();
    }

    public Object getClaimTokenClaim(String key) {
        return this.getClaims().getClaimTokenClaim(key);
    }

    public Object getPctClaim(String key) {
        return this.getClaims().getPctClaim(key);
    }

    public String getIssuer() {
        return this.configuration.getIssuer();
    }

    public String getScriptDn() {
        return this.scriptDn;
    }

    public Map<String, SimpleCustomProperty> getConfigurationAttributes() {
        return this.configurationAttributes;
    }

    public Set<String> getScopes() {
        HashSet<String> result = new HashSet<String>();
        for (UmaScopeDescription scope : this.getScopeMap().keySet()) {
            result.add(scope.getId());
        }
        return result;
    }

    public Set<String> getScriptScopes() {
        HashSet<String> result = new HashSet<String>();
        for (UmaScopeDescription scope : this.getScopeMap().keySet()) {
            if (scope.getAuthorizationPolicies() == null || !scope.getAuthorizationPolicies().contains(this.scriptDn)) continue;
            result.add(scope.getId());
        }
        return result;
    }

    public Map<UmaScopeDescription, Boolean> getScopeMap() {
        return Maps.newHashMap(this.scopes);
    }

    public Set<UmaResource> getResources() {
        return this.resources;
    }

    public Set<String> getResourceIds() {
        HashSet<String> result = new HashSet<String>();
        for (UmaResource resource : this.resources) {
            result.add(resource.getId());
        }
        return result;
    }

    public Claims getClaims() {
        return this.claims;
    }

    public Object getClaim(String claimName) {
        return this.claims.get(claimName);
    }

    public void putClaim(String claimName, Object claimValue) {
        this.claims.put(claimName, claimValue);
    }

    public boolean hasClaim(String claimName) {
        return this.claims.has(claimName);
    }

    public void removeClaim(String claimName) {
        this.claims.removeClaim(claimName);
    }

    public void addRedirectUserParam(String paramName, String paramValue) {
        this.redirectUserParameters.add(paramName, paramValue);
    }

    public void removeRedirectUserParameter(String paramName) {
        this.redirectUserParameters.remove(paramName);
    }

    public RedirectParameters getRedirectUserParameters() {
        return this.redirectUserParameters;
    }

    public Map<String, Set<String>> getRedirectUserParametersMap() {
        return this.redirectUserParameters.map();
    }

    public User getUser(String ... returnAttributes) {
        return this.sessionService.getUser(this.httpRequest, returnAttributes);
    }

    public boolean isAuthenticated() {
        return this.getUser(new String[0]) != null;
    }

    public String getUserDn() {
        return this.sessionService.getUserDn(this.httpRequest);
    }

    public Client getClient() {
        return this.client;
    }

    public List<UmaPermission> getPermissions() {
        SessionId session = this.sessionService.getSession(this.httpRequest, this.httpResponse);
        if (session == null) {
            this.getLog().trace("No UMA session set.");
            return Lists.newArrayList();
        }
        return this.permissionService.getPermissionsByTicket(this.sessionService.getTicket(session));
    }
}

