/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.authorization;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.uma.authorization.UmaPCT;

public class Claims {
    private Jwt claimsToken;
    private String claimsTokenAsString;
    private UmaPCT pct;
    private Map<String, Object> claims = new ConcurrentHashMap<String, Object>();

    public Claims(Jwt claimsToken, UmaPCT pct, String claimsTokenAsString) {
        this.claimsToken = claimsToken;
        this.pct = pct;
        this.claimsTokenAsString = claimsTokenAsString;
    }

    public String getClaimsTokenAsString() {
        return this.claimsTokenAsString;
    }

    public Set<String> keys() {
        return this.claims.keySet();
    }

    public Object get(String key) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        if (this.claims.containsKey(key)) {
            return this.claims.get(key);
        }
        if (this.claimsToken != null && this.claimsToken.getClaims() != null && this.claimsToken.getClaims().hasClaim(key)) {
            return this.claimsToken.getClaims().getClaim(key);
        }
        if (this.pct != null && this.pct.getClaims() != null && this.pct.getClaims().hasClaim(key)) {
            return this.pct.getClaims().getClaim(key);
        }
        return null;
    }

    public Object getClaimTokenClaim(String key) {
        if (this.claimsToken != null && this.claimsToken.getClaims() != null && this.claimsToken.getClaims().hasClaim(key)) {
            return this.claimsToken.getClaims().getClaim(key);
        }
        return null;
    }

    public Object getPctClaim(String key) {
        if (this.pct != null && this.pct.getClaims() != null && this.pct.getClaims().hasClaim(key)) {
            return this.pct.getClaims().getClaim(key);
        }
        return null;
    }

    public boolean has(String key) {
        return this.get(key) != null;
    }

    public void put(String key, Object value) {
        this.claims.put(key, value);
    }

    public void removeClaim(String key) {
        this.claims.remove(key);
    }
}

