/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.token.ws.rs;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import java.security.SignatureException;
import java.util.Arrays;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.xdi.oxauth.audit.ApplicationAuditLogger;
import org.xdi.oxauth.model.audit.Action;
import org.xdi.oxauth.model.audit.OAuth2AuditLog;
import org.xdi.oxauth.model.authorize.CodeVerifier;
import org.xdi.oxauth.model.common.AccessToken;
import org.xdi.oxauth.model.common.AuthorizationCodeGrant;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantList;
import org.xdi.oxauth.model.common.ClientCredentialsGrant;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.IdToken;
import org.xdi.oxauth.model.common.RefreshToken;
import org.xdi.oxauth.model.common.ResourceOwnerPasswordCredentialsGrant;
import org.xdi.oxauth.model.common.TokenType;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.crypto.binding.TokenBindingMessage;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.exception.InvalidJweException;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.session.SessionClient;
import org.xdi.oxauth.model.token.JsonWebResponse;
import org.xdi.oxauth.model.token.TokenErrorResponseType;
import org.xdi.oxauth.model.token.TokenParamsValidator;
import org.xdi.oxauth.security.Identity;
import org.xdi.oxauth.service.AttributeService;
import org.xdi.oxauth.service.AuthenticationFilterService;
import org.xdi.oxauth.service.AuthenticationService;
import org.xdi.oxauth.service.GrantService;
import org.xdi.oxauth.service.UserService;
import org.xdi.oxauth.service.external.ExternalResourceOwnerPasswordCredentialsService;
import org.xdi.oxauth.service.external.context.ExternalResourceOwnerPasswordCredentialsContext;
import org.xdi.oxauth.token.ws.rs.TokenRestWebService;
import org.xdi.oxauth.uma.service.UmaTokenService;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.StringHelper;
import org.xdi.util.security.StringEncrypter;

@Path(value="/")
public class TokenRestWebServiceImpl
implements TokenRestWebService {
    @Inject
    private Logger log;
    @Inject
    private Identity identity;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private UserService userService;
    @Inject
    private GrantService grantService;
    @Inject
    private AuthenticationFilterService authenticationFilterService;
    @Inject
    private AuthenticationService authenticationService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private UmaTokenService umaTokenService;
    @Inject
    private ExternalResourceOwnerPasswordCredentialsService externalResourceOwnerPasswordCredentialsService;
    @Inject
    private AttributeService attributeService;

    @Override
    public Response requestAccessToken(String grantType, String code, String redirectUri, String username, String password, String scope, String assertion, String refreshToken, String clientId, String clientSecret, String codeVerifier, String ticket, String claimToken, String claimTokenFormat, String pctCode, String rptCode, HttpServletRequest request, HttpServletResponse response, SecurityContext sec) {
        this.log.debug("Attempting to request access token: grantType = {}, code = {}, redirectUri = {}, username = {}, refreshToken = {}, clientId = {}, ExtraParams = {}, isSecure = {}, codeVerifier = {}, ticket = {}", new Object[]{grantType, code, redirectUri, username, refreshToken, clientId, request.getParameterMap(), sec.isSecure(), codeVerifier, ticket});
        boolean isUma = StringUtils.isNotBlank((String)ticket);
        if (isUma) {
            return this.umaTokenService.requestRpt(grantType, ticket, claimToken, claimTokenFormat, pctCode, rptCode, scope, request);
        }
        OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(request), Action.TOKEN_REQUEST);
        oAuth2AuditLog.setClientId(clientId);
        oAuth2AuditLog.setUsername(username);
        oAuth2AuditLog.setScope(scope);
        String tokenBindingHeader = request.getHeader("Sec-Token-Binding");
        scope = ServerUtil.urlDecode(scope);
        Response.ResponseBuilder builder = Response.ok();
        try {
            this.log.debug("Starting to validate request parameters");
            if (!TokenParamsValidator.validateParams(grantType, code, redirectUri, username, password, scope, assertion, refreshToken)) {
                this.log.trace("Failed to validate request parameters");
                builder = this.error(400, TokenErrorResponseType.INVALID_REQUEST);
            } else {
                this.log.trace("Request parameters are right");
                GrantType gt = GrantType.fromString((String)grantType);
                this.log.debug("Grant type: '{}'", (Object)gt);
                SessionClient sessionClient = this.identity.getSessionClient();
                Client client = null;
                if (sessionClient != null) {
                    client = sessionClient.getClient();
                    this.log.debug("Get sessionClient: '{}'", (Object)sessionClient);
                }
                if (client != null) {
                    this.log.debug("Get client from session: '{}'", (Object)client.getClientId());
                    if (client.isDisabled()) {
                        return this.response(this.error(Response.Status.FORBIDDEN.getStatusCode(), TokenErrorResponseType.DISABLED_CLIENT), oAuth2AuditLog);
                    }
                } else {
                    return this.response(this.error(401, TokenErrorResponseType.INVALID_GRANT), oAuth2AuditLog);
                }
                Function idTokenTokingBindingPreprocessing = TokenBindingMessage.createIdTokenTokingBindingPreprocessing((String)tokenBindingHeader, (String)client.getIdTokenTokenBindingCnf());
                if (gt == GrantType.AUTHORIZATION_CODE) {
                    if (!TokenParamsValidator.validateGrantType(gt, client.getGrantTypes(), this.appConfiguration.getGrantTypesSupported())) {
                        return this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT), oAuth2AuditLog);
                    }
                    this.log.debug("Attempting to find authorizationCodeGrant by clinetId: '{}', code: '{}'", (Object)client.getClientId(), (Object)code);
                    final AuthorizationCodeGrant authorizationCodeGrant = this.authorizationGrantList.getAuthorizationCodeGrant(client.getClientId(), code);
                    this.log.trace("AuthorizationCodeGrant : '{}'", (Object)authorizationCodeGrant);
                    if (authorizationCodeGrant != null) {
                        this.validatePKCE(authorizationCodeGrant, codeVerifier, oAuth2AuditLog);
                        authorizationCodeGrant.setIsCachedWithNoPersistence(false);
                        authorizationCodeGrant.save();
                        RefreshToken reToken = null;
                        if (client.getGrantTypes() != null && client.getGrantTypes().length > 0 && Arrays.asList(client.getGrantTypes()).contains(GrantType.REFRESH_TOKEN)) {
                            reToken = authorizationCodeGrant.createRefreshToken();
                        }
                        if (scope != null && !scope.isEmpty()) {
                            scope = authorizationCodeGrant.checkScopesPolicy(scope);
                        }
                        AccessToken accToken = authorizationCodeGrant.createAccessToken();
                        this.log.debug("Issuing access token: {}", (Object)accToken.getCode());
                        IdToken idToken = null;
                        if (authorizationCodeGrant.getScopes().contains("openid")) {
                            String nonce = authorizationCodeGrant.getNonce();
                            boolean includeIdTokenClaims = Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims());
                            final String idTokenTokenBindingCnf = client.getIdTokenTokenBindingCnf();
                            Function<JsonWebResponse, Void> authorizationCodePreProcessing = new Function<JsonWebResponse, Void>(){

                                public Void apply(JsonWebResponse jsonWebResponse) {
                                    if (StringUtils.isNotBlank((String)idTokenTokenBindingCnf) && StringUtils.isNotBlank((String)authorizationCodeGrant.getTokenBindingHash())) {
                                        TokenBindingMessage.setCnfClaim((JsonWebResponse)jsonWebResponse, (String)authorizationCodeGrant.getTokenBindingHash(), (String)idTokenTokenBindingCnf);
                                    }
                                    return null;
                                }
                            };
                            idToken = authorizationCodeGrant.createIdToken(nonce, null, accToken, authorizationCodeGrant, includeIdTokenClaims, authorizationCodePreProcessing);
                        }
                        builder.entity((Object)this.getJSonResponse(accToken, accToken.getTokenType(), accToken.getExpiresIn(), reToken, scope, idToken));
                        oAuth2AuditLog.updateOAuth2AuditLog(authorizationCodeGrant, true);
                        this.grantService.removeByCode(authorizationCodeGrant.getAuthorizationCode().getCode(), authorizationCodeGrant.getClientId());
                    } else {
                        this.log.debug("AuthorizationCodeGrant is empty by clinetId: '{}', code: '{}'", (Object)client.getClientId(), (Object)code);
                        this.grantService.removeAllByAuthorizationCode(code);
                        builder = this.error(400, TokenErrorResponseType.INVALID_GRANT);
                    }
                } else if (gt == GrantType.REFRESH_TOKEN) {
                    if (!TokenParamsValidator.validateGrantType(gt, client.getGrantTypes(), this.appConfiguration.getGrantTypesSupported())) {
                        return this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT), oAuth2AuditLog);
                    }
                    AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByRefreshToken(client.getClientId(), refreshToken);
                    if (authorizationGrant != null) {
                        RefreshToken reToken = authorizationGrant.createRefreshToken();
                        this.grantService.removeByCode(refreshToken, client.getClientId());
                        if (scope != null && !scope.isEmpty()) {
                            scope = authorizationGrant.checkScopesPolicy(scope);
                        }
                        AccessToken accToken = authorizationGrant.createAccessToken();
                        IdToken idToken = null;
                        if (this.appConfiguration.getOpenidScopeBackwardCompatibility().booleanValue() && authorizationGrant.getScopes().contains("openid")) {
                            boolean includeIdTokenClaims = Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims());
                            idToken = authorizationGrant.createIdToken(null, null, accToken, authorizationGrant, includeIdTokenClaims, (Function<JsonWebResponse, Void>)idTokenTokingBindingPreprocessing);
                        }
                        builder.entity((Object)this.getJSonResponse(accToken, accToken.getTokenType(), accToken.getExpiresIn(), reToken, scope, idToken));
                        oAuth2AuditLog.updateOAuth2AuditLog(authorizationGrant, true);
                    } else {
                        builder = this.error(401, TokenErrorResponseType.INVALID_GRANT);
                    }
                } else if (gt == GrantType.CLIENT_CREDENTIALS) {
                    if (!TokenParamsValidator.validateGrantType(gt, client.getGrantTypes(), this.appConfiguration.getGrantTypesSupported())) {
                        return this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT), oAuth2AuditLog);
                    }
                    ClientCredentialsGrant clientCredentialsGrant = this.authorizationGrantList.createClientCredentialsGrant(new User(), client);
                    if (scope != null && !scope.isEmpty()) {
                        scope = clientCredentialsGrant.checkScopesPolicy(scope);
                    }
                    AccessToken accessToken = clientCredentialsGrant.createAccessToken();
                    IdToken idToken = null;
                    if (this.appConfiguration.getOpenidScopeBackwardCompatibility().booleanValue() && clientCredentialsGrant.getScopes().contains("openid")) {
                        boolean includeIdTokenClaims = Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims());
                        idToken = clientCredentialsGrant.createIdToken(null, null, null, clientCredentialsGrant, includeIdTokenClaims, (Function<JsonWebResponse, Void>)idTokenTokingBindingPreprocessing);
                    }
                    oAuth2AuditLog.updateOAuth2AuditLog(clientCredentialsGrant, true);
                    builder.entity((Object)this.getJSonResponse(accessToken, accessToken.getTokenType(), accessToken.getExpiresIn(), null, scope, idToken));
                } else if (gt == GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS) {
                    String userDn;
                    if (!TokenParamsValidator.validateGrantType(gt, client.getGrantTypes(), this.appConfiguration.getGrantTypesSupported())) {
                        return this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT), oAuth2AuditLog);
                    }
                    boolean authenticated = false;
                    User user = null;
                    if (this.authenticationFilterService.isEnabled() && StringHelper.isNotEmpty((String)(userDn = this.authenticationFilterService.processAuthenticationFilters(request.getParameterMap())))) {
                        user = this.userService.getUserByDn(userDn, new String[0]);
                        authenticated = true;
                    }
                    if (!authenticated) {
                        if (this.externalResourceOwnerPasswordCredentialsService.isEnabled()) {
                            ExternalResourceOwnerPasswordCredentialsContext context = new ExternalResourceOwnerPasswordCredentialsContext(request, response, this.appConfiguration, this.attributeService, this.userService);
                            context.setUser(user);
                            if (this.externalResourceOwnerPasswordCredentialsService.executeExternalAuthenticate(context)) {
                                this.log.trace("RO PC - User is authenticated successfully by external script.");
                                user = context.getUser();
                            }
                        } else {
                            authenticated = this.authenticationService.authenticate(username, password);
                            if (authenticated) {
                                user = this.authenticationService.getAuthenticatedUser();
                            }
                        }
                    }
                    if (user != null) {
                        ResourceOwnerPasswordCredentialsGrant resourceOwnerPasswordCredentialsGrant = this.authorizationGrantList.createResourceOwnerPasswordCredentialsGrant(user, client);
                        RefreshToken reToken = resourceOwnerPasswordCredentialsGrant.createRefreshToken();
                        if (scope != null && !scope.isEmpty()) {
                            scope = resourceOwnerPasswordCredentialsGrant.checkScopesPolicy(scope);
                        }
                        AccessToken accessToken = resourceOwnerPasswordCredentialsGrant.createAccessToken();
                        IdToken idToken = null;
                        if (this.appConfiguration.getOpenidScopeBackwardCompatibility().booleanValue() && resourceOwnerPasswordCredentialsGrant.getScopes().contains("openid")) {
                            boolean includeIdTokenClaims = Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims());
                            idToken = resourceOwnerPasswordCredentialsGrant.createIdToken(null, null, null, resourceOwnerPasswordCredentialsGrant, includeIdTokenClaims, (Function<JsonWebResponse, Void>)idTokenTokingBindingPreprocessing);
                        }
                        oAuth2AuditLog.updateOAuth2AuditLog(resourceOwnerPasswordCredentialsGrant, true);
                        builder.entity((Object)this.getJSonResponse(accessToken, accessToken.getTokenType(), accessToken.getExpiresIn(), reToken, scope, idToken));
                    } else {
                        this.log.error("Invalid user", (Throwable)new RuntimeException("User is empty"));
                        builder = this.error(401, TokenErrorResponseType.INVALID_CLIENT);
                    }
                }
            }
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (SignatureException e) {
            builder = Response.status((int)500);
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (StringEncrypter.EncryptionException e) {
            builder = Response.status((int)500);
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (InvalidJwtException e) {
            builder = Response.status((int)500);
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (InvalidJweException e) {
            builder = Response.status((int)500);
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            builder = Response.status((int)500);
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return this.response(builder, oAuth2AuditLog);
    }

    private void validatePKCE(AuthorizationCodeGrant grant, String codeVerifier, OAuth2AuditLog oAuth2AuditLog) {
        this.log.trace("PKCE validation, code_verifier: {}, code_challenge: {}, method: {}", new Object[]{codeVerifier, grant.getCodeChallenge(), grant.getCodeChallengeMethod()});
        if (Strings.isNullOrEmpty((String)grant.getCodeChallenge()) && Strings.isNullOrEmpty((String)codeVerifier)) {
            return;
        }
        if (!CodeVerifier.matched((String)grant.getCodeChallenge(), (String)grant.getCodeChallengeMethod(), (String)codeVerifier)) {
            this.log.error("PKCE check fails. Code challenge does not match to request code verifier, grantId:" + grant.getGrantId() + ", codeVerifier: " + codeVerifier);
            throw new WebApplicationException(this.response(this.error(401, TokenErrorResponseType.INVALID_GRANT), oAuth2AuditLog));
        }
    }

    private Response response(Response.ResponseBuilder builder, OAuth2AuditLog oAuth2AuditLog) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoTransform(false);
        cacheControl.setNoStore(true);
        builder.cacheControl(cacheControl);
        builder.header("Pragma", (Object)"no-cache");
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        return builder.build();
    }

    private Response.ResponseBuilder error(int p_status, TokenErrorResponseType p_type) {
        return Response.status((int)p_status).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)p_type));
    }

    public String getJSonResponse(AccessToken accessToken, TokenType tokenType, Integer expiresIn, RefreshToken refreshToken, String scope, IdToken idToken) {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("access_token", (Object)accessToken.getCode());
            jsonObj.put("token_type", (Object)tokenType.toString());
            if (expiresIn != null) {
                jsonObj.put("expires_in", (Object)expiresIn);
            }
            if (refreshToken != null) {
                jsonObj.put("refresh_token", (Object)refreshToken.getCode());
            }
            if (scope != null) {
                jsonObj.put("scope", (Object)scope);
            }
            if (idToken != null) {
                jsonObj.put("id_token", (Object)idToken.getCode());
            }
        }
        catch (JSONException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return jsonObj.toString();
    }
}

