/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.token.ws.rs;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Api(value="/", description="Token Endpoint is used to obtain an Access Token, an ID Token, and optionally a Refresh Token. The RP (Client) sends a Token Request to the Token Endpoint to obtain a Token Response")
public interface TokenRestWebService {
    @POST
    @Path(value="/token")
    @Produces(value={"application/json"})
    @ApiOperation(value="To obtain an Access Token, an ID Token, and optionally a Refresh Token, the RP (Client) sends a Token Request to the Token Endpoint to obtain a Token Response", notes="To obtain an Access Token, an ID Token, and optionally a Refresh Token, the RP (Client) sends a Token Request to the Token Endpoint to obtain a Token Response", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=400, message="invalid_request\n The request is missing a required parameter, includes an unsupported parameter value (other than grant type), repeats a parameter, includes multiple credentials,\n utilizes more than one mechanism for authenticating the client, or is otherwise malformed."), @ApiResponse(code=400, message="invalid_client\nClient authentication failed (e.g., unknown client, no client authentication included, or unsupported\nauthentication method).  The authorization server MAY return an HTTP 401 (Unauthorized) status code to indicate\nwhich HTTP authentication schemes are supported.  If the client attempted to authenticate via the \"Authorization\"\nrequest header field, the authorization server MUST respond with an HTTP 401 (Unauthorized) status code and\ninclude the \"WWW-Authenticate\" response header field matching the authentication scheme used by the client."), @ApiResponse(code=400, message="invalid_grant\n The provided authorization grant (e.g., authorization code, resource owner credentials) or refresh token is\n invalid, expired, revoked, does not match the redirection URI used in the authorization request, or was issued to another client."), @ApiResponse(code=400, message="unauthorized_client\nThe authenticated client is not authorized to use this authorization grant type."), @ApiResponse(code=400, message="unsupported_grant_type\nThe authorization grant type is not supported by the authorization server."), @ApiResponse(code=400, message=" invalid_scope\nThe requested scope is invalid, unknown, malformed, or exceeds the scope granted by the resource owner.")})
    public Response requestAccessToken(@FormParam(value="grant_type") @ApiParam(value="Grant type value, one of these: authorization_code, implicit, password, client_credentials, refresh_token as described in OAuth 2.0 [RFC6749]", required=true) String var1, @FormParam(value="code") @ApiParam(value="Code which is returned by authorization endpoint. (For grant_type=authorization_code)", required=false) String var2, @FormParam(value="redirect_uri") @ApiParam(value="Redirection URI to which the response will be sent. This URI MUST exactly match one of the Redirection URI values for the Client pre-registered at the OpenID Provider", required=false) String var3, @FormParam(value="username") @ApiParam(value="End-User username.", required=false) String var4, @FormParam(value="password") @ApiParam(value="End-User password.", required=false) String var5, @FormParam(value="scope") @ApiParam(value="OpenID Connect requests MUST contain the openid scope value. If the openid scope value is not present, the behavior is entirely unspecified. Other scope values MAY be present. Scope values used that are not understood by an implementation SHOULD be ignored.", required=false) String var6, @FormParam(value="assertion") @ApiParam(value="Assertion", required=false) String var7, @FormParam(value="refresh_token") @ApiParam(value="Refresh token", required=false) String var8, @FormParam(value="client_id") @ApiParam(value="OAuth 2.0 Client Identifier valid at the Authorization Server.", required=false) String var9, @FormParam(value="client_secret") @ApiParam(value="The client secret.  The client MAY omit the parameter if the client secret is an empty string.", required=false) String var10, @FormParam(value="code_verifier") @ApiParam(value="The client's PKCE code verifier.", required=false) String var11, @FormParam(value="ticket") String var12, @FormParam(value="claim_token") String var13, @FormParam(value="claim_token_format") String var14, @FormParam(value="pct") String var15, @FormParam(value="rpt") String var16, @Context HttpServletRequest var17, @Context HttpServletResponse var18, @Context SecurityContext var19);
}

