/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.discovery.OpenIdConnectDiscoveryParamsValidator;

@WebServlet(urlPatterns={"/.well-known/webfinger"})
public class WebFinger
extends HttpServlet {
    private static final long serialVersionUID = -4708834950205359151L;
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpServletRequest httpRequest = request;
        HttpServletResponse httpResponse = response;
        httpResponse.setContentType("application/jrd+json");
        PrintWriter out = httpResponse.getWriter();
        String resource = httpRequest.getParameter("resource");
        String rel = httpRequest.getParameter("rel");
        this.log.debug("Attempting to request OpenID Connect Discovery: " + resource + ", " + rel + ", Is Secure = " + httpRequest.isSecure());
        try {
            if (OpenIdConnectDiscoveryParamsValidator.validateParams(resource, rel) && (rel == null || rel.equals("http://openid.net/specs/connect/1.0/issuer"))) {
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("subject", (Object)resource);
                JSONArray linksJsonArray = new JSONArray();
                JSONObject linkJsonObject = new JSONObject();
                linkJsonObject.put("rel", (Object)"http://openid.net/specs/connect/1.0/issuer");
                linkJsonObject.put("href", (Object)this.appConfiguration.getIssuer());
                linksJsonArray.put((Object)linkJsonObject);
                jsonObj.put("links", (Object)linksJsonArray);
                out.println(jsonObj.toString(4).replace("\\/", "/"));
            }
        }
        catch (JSONException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        out.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "OpenID Connect Discovery";
    }
}

