/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.status.ldap;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ejb.DependsOn;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.site.ldap.LDAPConnectionProvider;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.slf4j.Logger;
import org.xdi.service.cdi.async.Asynchronous;
import org.xdi.service.cdi.event.LdapStatusEvent;
import org.xdi.service.cdi.event.Scheduled;
import org.xdi.service.timer.event.TimerEvent;
import org.xdi.service.timer.schedule.TimerSchedule;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class LdapStatusTimer {
    private static final int DEFAULT_INTERVAL = 60;
    @Inject
    private Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    private LdapEntryManager ldapEntryManager;
    @Inject
    @Named(value="ldapAuthEntryManager")
    private List<LdapEntryManager> ldapAuthEntryManagers;
    private AtomicBoolean isActive;

    public void initTimer() {
        this.log.info("Initializing Ldap Status Timer");
        this.isActive = new AtomicBoolean(false);
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(60, 60), (Object)new LdapStatusEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
    }

    @Asynchronous
    public void process(@Observes @Scheduled LdapStatusEvent ldapStatusEvent) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.processInt();
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void processInt() {
        this.logConnectionProviderStatistic(this.ldapEntryManager, "connectionProvider", "bindConnectionProvider");
        for (int i = 0; i < this.ldapAuthEntryManagers.size(); ++i) {
            LdapEntryManager ldapAuthEntryManager = this.ldapAuthEntryManagers.get(i);
            this.logConnectionProviderStatistic(ldapAuthEntryManager, "authConnectionProvider#" + i, "bindAuthConnectionProvider#" + i);
        }
    }

    public void logConnectionProviderStatistic(LdapEntryManager ldapEntryManager, String connectionProviderName, String bindConnectionProviderName) {
        LDAPConnectionProvider ldapConnectionProvider = ldapEntryManager.getLdapOperationService().getConnectionProvider();
        LDAPConnectionProvider bindLdapConnectionProvider = ldapEntryManager.getLdapOperationService().getBindConnectionProvider();
        if (ldapConnectionProvider == null) {
            this.log.error("{} is empty", (Object)connectionProviderName);
        } else if (ldapConnectionProvider.getConnectionPool() == null) {
            this.log.error("{} is empty", (Object)connectionProviderName);
        } else {
            this.log.info("{} statistics: {}", (Object)connectionProviderName, (Object)ldapConnectionProvider.getConnectionPool().getConnectionPoolStatistics());
        }
        if (bindLdapConnectionProvider == null) {
            this.log.error("{} is empty", (Object)bindConnectionProviderName);
        } else if (bindLdapConnectionProvider.getConnectionPool() == null) {
            this.log.error("{} is empty", (Object)bindConnectionProviderName);
        } else {
            this.log.info("{} statistics: {}", (Object)bindConnectionProviderName, (Object)bindLdapConnectionProvider.getConnectionPool().getConnectionPoolStatistics());
        }
    }
}

