/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.fido.u2f;

import com.unboundid.ldap.sdk.Filter;
import java.util.Date;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.site.ldap.persistence.BatchOperation;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.slf4j.Logger;
import org.xdi.ldap.model.SearchScope;
import org.xdi.oxauth.model.config.StaticConfiguration;
import org.xdi.oxauth.model.fido.u2f.RequestMessageLdap;

@Stateless
@Named(value="u2fRequestService")
public class RequestService {
    @Inject
    private Logger log;
    @Inject
    private LdapEntryManager ldapEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;

    public List<RequestMessageLdap> getExpiredRequestMessages(BatchOperation<RequestMessageLdap> batchOperation, Date expirationDate) {
        String u2fBaseDn = this.staticConfiguration.getBaseDn().getU2fBase();
        Filter expirationFilter = Filter.createLessOrEqualFilter((String)"creationDate", (String)this.ldapEntryManager.encodeGeneralizedTime(expirationDate));
        List requestMessageLdap = this.ldapEntryManager.findEntries(u2fBaseDn, RequestMessageLdap.class, expirationFilter, SearchScope.SUB, null, batchOperation, 0, 25, 25);
        return requestMessageLdap;
    }

    public void removeRequestMessage(RequestMessageLdap requestMessageLdap) {
        this.ldapEntryManager.remove((Object)requestMessageLdap);
    }
}

