/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.fido.u2f;

import com.unboundid.ldap.sdk.Filter;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.slf4j.Logger;
import org.xdi.oxauth.crypto.random.ChallengeGenerator;
import org.xdi.oxauth.exception.fido.u2f.DeviceCompromisedException;
import org.xdi.oxauth.model.config.StaticConfiguration;
import org.xdi.oxauth.model.fido.u2f.DeviceRegistration;
import org.xdi.oxauth.model.fido.u2f.DeviceRegistrationResult;
import org.xdi.oxauth.model.fido.u2f.DeviceRegistrationStatus;
import org.xdi.oxauth.model.fido.u2f.RegisterRequestMessageLdap;
import org.xdi.oxauth.model.fido.u2f.RequestMessageLdap;
import org.xdi.oxauth.model.fido.u2f.exception.BadInputException;
import org.xdi.oxauth.model.fido.u2f.message.RawRegisterResponse;
import org.xdi.oxauth.model.fido.u2f.protocol.AuthenticateRequest;
import org.xdi.oxauth.model.fido.u2f.protocol.ClientData;
import org.xdi.oxauth.model.fido.u2f.protocol.DeviceData;
import org.xdi.oxauth.model.fido.u2f.protocol.RegisterRequest;
import org.xdi.oxauth.model.fido.u2f.protocol.RegisterRequestMessage;
import org.xdi.oxauth.model.fido.u2f.protocol.RegisterResponse;
import org.xdi.oxauth.model.util.Base64Util;
import org.xdi.oxauth.service.UserService;
import org.xdi.oxauth.service.fido.u2f.ApplicationService;
import org.xdi.oxauth.service.fido.u2f.AuthenticationService;
import org.xdi.oxauth.service.fido.u2f.ClientDataValidationService;
import org.xdi.oxauth.service.fido.u2f.DeviceRegistrationService;
import org.xdi.oxauth.service.fido.u2f.RawRegistrationService;
import org.xdi.oxauth.service.fido.u2f.RequestService;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.StringHelper;

@Stateless
@Named(value="u2fRegistrationService")
public class RegistrationService
extends RequestService {
    @Inject
    private Logger log;
    @Inject
    private LdapEntryManager ldapEntryManager;
    @Inject
    private ApplicationService applicationService;
    @Inject
    private UserService userService;
    @Inject
    private AuthenticationService u2fAuthenticationService;
    @Inject
    private RawRegistrationService rawRegistrationService;
    @Inject
    private ClientDataValidationService clientDataValidationService;
    @Inject
    private DeviceRegistrationService deviceRegistrationService;
    @Inject
    @Named(value="randomChallengeGenerator")
    private ChallengeGenerator challengeGenerator;
    @Inject
    private StaticConfiguration staticConfiguration;

    public RegisterRequestMessage builRegisterRequestMessage(String appId, String userInum) {
        if (this.applicationService.isValidateApplication()) {
            this.applicationService.checkIsValid(appId);
        }
        ArrayList<AuthenticateRequest> authenticateRequests = new ArrayList<AuthenticateRequest>();
        ArrayList<RegisterRequest> registerRequests = new ArrayList<RegisterRequest>();
        boolean twoStep = StringHelper.isNotEmpty((String)userInum);
        if (twoStep) {
            List<DeviceRegistration> deviceRegistrations = this.deviceRegistrationService.findUserDeviceRegistrations(userInum, appId, new String[0]);
            for (DeviceRegistration deviceRegistration : deviceRegistrations) {
                if (deviceRegistration.isCompromised()) continue;
                try {
                    AuthenticateRequest authenticateRequest = this.u2fAuthenticationService.startAuthentication(appId, deviceRegistration);
                    authenticateRequests.add(authenticateRequest);
                }
                catch (DeviceCompromisedException ex) {
                    this.log.error("Faield to authenticate device", (Throwable)ex);
                }
            }
        }
        RegisterRequest request = this.startRegistration(appId);
        registerRequests.add(request);
        return new RegisterRequestMessage(authenticateRequests, registerRequests);
    }

    public RegisterRequest startRegistration(String appId) {
        return this.startRegistration(appId, this.challengeGenerator.generateChallenge());
    }

    public RegisterRequest startRegistration(String appId, byte[] challenge) {
        return new RegisterRequest(Base64Util.base64urlencode((byte[])challenge), appId);
    }

    public DeviceRegistrationResult finishRegistration(RegisterRequestMessage requestMessage, RegisterResponse response, String userInum) throws BadInputException {
        return this.finishRegistration(requestMessage, response, userInum, null);
    }

    public DeviceRegistrationResult finishRegistration(RegisterRequestMessage requestMessage, RegisterResponse response, String userInum, Set<String> facets) throws BadInputException {
        boolean approved;
        RegisterRequest request = requestMessage.getRegisterRequest();
        String appId = request.getAppId();
        ClientData clientData = response.getClientData();
        this.clientDataValidationService.checkContent(clientData, RawRegistrationService.SUPPORTED_REGISTER_TYPES, request.getChallenge(), facets);
        RawRegisterResponse rawRegisterResponse = this.rawRegistrationService.parseRawRegisterResponse(response.getRegistrationData());
        this.rawRegistrationService.checkSignature(appId, clientData, rawRegisterResponse);
        Date now = new GregorianCalendar(TimeZone.getTimeZone("UTC")).getTime();
        DeviceRegistration deviceRegistration = this.rawRegistrationService.createDevice(rawRegisterResponse);
        deviceRegistration.setStatus(DeviceRegistrationStatus.ACTIVE);
        deviceRegistration.setApplication(appId);
        deviceRegistration.setCreationDate(now);
        int keyHandleHashCode = this.deviceRegistrationService.getKeyHandleHashCode(rawRegisterResponse.getKeyHandle());
        deviceRegistration.setKeyHandleHashCode(keyHandleHashCode);
        String deviceRegistrationId = String.valueOf(System.currentTimeMillis());
        deviceRegistration.setId(deviceRegistrationId);
        String responseDeviceData = response.getDeviceData();
        if (StringHelper.isNotEmpty((String)responseDeviceData)) {
            try {
                String responseDeviceDataDecoded = new String(Base64Util.base64urldecode((String)responseDeviceData));
                DeviceData deviceData = (DeviceData)ServerUtil.jsonMapperWithWrapRoot().readValue(responseDeviceDataDecoded, DeviceData.class);
                deviceRegistration.setDeviceData(deviceData);
            }
            catch (Exception ex) {
                throw new BadInputException(String.format("Device data is invalid: %s", responseDeviceData), (Throwable)ex);
            }
        }
        if (!(approved = StringHelper.equals((String)"navigator.id.finishEnrollment", (String)response.getClientData().getTyp()))) {
            this.log.debug("Registratio request with keyHandle '{}' was canceled", (Object)rawRegisterResponse.getKeyHandle());
            return new DeviceRegistrationResult(deviceRegistration, DeviceRegistrationResult.Status.CANCELED);
        }
        boolean twoStep = StringHelper.isNotEmpty((String)userInum);
        if (twoStep) {
            deviceRegistration.setDn(this.deviceRegistrationService.getDnForU2fDevice(userInum, deviceRegistrationId));
            List<DeviceRegistration> foundDeviceRegistrations = this.deviceRegistrationService.findDeviceRegistrationsByKeyHandle(appId, deviceRegistration.getKeyHandle(), "oxId");
            if (foundDeviceRegistrations.size() != 0) {
                throw new BadInputException(String.format("KeyHandle %s was compromised", deviceRegistration.getKeyHandle()));
            }
            this.deviceRegistrationService.addUserDeviceRegistration(userInum, deviceRegistration);
        } else {
            deviceRegistration.setDn(this.deviceRegistrationService.getDnForOneStepU2fDevice(deviceRegistrationId));
            this.deviceRegistrationService.addOneStepDeviceRegistration(deviceRegistration);
        }
        return new DeviceRegistrationResult(deviceRegistration, DeviceRegistrationResult.Status.APPROVED);
    }

    public void storeRegisterRequestMessage(RegisterRequestMessage requestMessage, String userInum, String sessionId) {
        Date now = new GregorianCalendar(TimeZone.getTimeZone("UTC")).getTime();
        String registerRequestMessageId = UUID.randomUUID().toString();
        RegisterRequestMessageLdap registerRequestMessageLdap = new RegisterRequestMessageLdap(this.getDnForRegisterRequestMessage(registerRequestMessageId), registerRequestMessageId, now, sessionId, userInum, requestMessage);
        this.ldapEntryManager.persist((Object)registerRequestMessageLdap);
    }

    public RegisterRequestMessage getRegisterRequestMessage(String oxId) {
        String requestDn = this.getDnForRegisterRequestMessage(oxId);
        RegisterRequestMessageLdap registerRequestMessageLdap = (RegisterRequestMessageLdap)this.ldapEntryManager.find(RegisterRequestMessageLdap.class, (Object)requestDn);
        if (registerRequestMessageLdap == null) {
            return null;
        }
        return registerRequestMessageLdap.getRegisterRequestMessage();
    }

    public RegisterRequestMessageLdap getRegisterRequestMessageByRequestId(String requestId) {
        Filter requestIdFilter;
        String baseDn = this.getDnForRegisterRequestMessage(null);
        List registerRequestMessagesLdap = this.ldapEntryManager.findEntries(baseDn, RegisterRequestMessageLdap.class, requestIdFilter = Filter.createEqualityFilter((String)"oxRequestId", (String)requestId));
        if (registerRequestMessagesLdap == null || registerRequestMessagesLdap.isEmpty()) {
            return null;
        }
        return (RegisterRequestMessageLdap)registerRequestMessagesLdap.get(0);
    }

    public void removeRegisterRequestMessage(RequestMessageLdap registerRequestMessageLdap) {
        this.removeRequestMessage(registerRequestMessageLdap);
    }

    public String getDnForRegisterRequestMessage(String oxId) {
        String u2fBaseDn = this.staticConfiguration.getBaseDn().getU2fBase();
        if (StringHelper.isEmpty((String)oxId)) {
            return String.format("ou=registration_requests,%s", u2fBaseDn);
        }
        return String.format("oxid=%s,ou=registration_requests,%s", oxId, u2fBaseDn);
    }
}

