/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.fido.u2f;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.xdi.oxauth.crypto.signature.SHA256withECDSASignatureVerification;
import org.xdi.oxauth.model.exception.SignatureException;
import org.xdi.oxauth.model.fido.u2f.exception.BadInputException;
import org.xdi.oxauth.model.fido.u2f.message.RawAuthenticateResponse;
import org.xdi.oxauth.model.fido.u2f.protocol.ClientData;
import org.xdi.oxauth.model.util.Base64Util;
import org.xdi.util.io.ByteDataInputStream;

@Stateless
@Named
public class RawAuthenticationService {
    public static final String AUTHENTICATE_GET_TYPE = "navigator.id.getAssertion";
    public static final String AUTHENTICATE_CANCEL_TYPE = "navigator.id.cancelAssertion";
    public static final String[] SUPPORTED_AUTHENTICATE_TYPES = new String[]{"navigator.id.getAssertion", "navigator.id.cancelAssertion"};
    @Inject
    private Logger log;
    @Inject
    @Named(value="sha256withECDSASignatureVerification")
    private SHA256withECDSASignatureVerification signatureVerification;

    public RawAuthenticateResponse parseRawAuthenticateResponse(String rawDataBase64) {
        ByteDataInputStream bis = new ByteDataInputStream(Base64Util.base64urldecode((String)rawDataBase64));
        try {
            RawAuthenticateResponse rawAuthenticateResponse = new RawAuthenticateResponse(bis.readSigned(), (long)bis.readInt(), bis.readAll());
            return rawAuthenticateResponse;
        }
        catch (IOException ex) {
            throw new BadInputException("Failed to parse RAW authenticate response", (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)bis);
        }
    }

    public void checkSignature(String appId, ClientData clientData, RawAuthenticateResponse rawAuthenticateResponse, byte[] publicKey) throws BadInputException {
        String rawClientData = clientData.getRawClientData();
        byte[] signedBytes = this.packBytesToSign(this.signatureVerification.hash(appId), rawAuthenticateResponse.getUserPresence(), rawAuthenticateResponse.getCounter(), this.signatureVerification.hash(rawClientData));
        try {
            this.signatureVerification.checkSignature(this.signatureVerification.decodePublicKey(publicKey), signedBytes, rawAuthenticateResponse.getSignature());
        }
        catch (SignatureException ex) {
            throw new BadInputException("Failed to checkSignature", (Throwable)ex);
        }
    }

    private byte[] packBytesToSign(byte[] appIdHash, byte userPresence, long counter, byte[] challengeHash) {
        ByteArrayDataOutput encoded = ByteStreams.newDataOutput();
        encoded.write(appIdHash);
        encoded.write((int)userPresence);
        encoded.writeInt((int)counter);
        encoded.write(challengeHash);
        return encoded.toByteArray();
    }
}

