/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.fido.u2f;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.xdi.oxauth.model.fido.u2f.exception.BadInputException;
import org.xdi.oxauth.model.fido.u2f.protocol.ClientData;

@Stateless
@Named
public class ClientDataValidationService {
    @Inject
    private Logger log;

    public void checkContent(ClientData clientData, String[] types, String challenge, Set<String> facets) throws BadInputException {
        if (!ArrayUtils.contains((Object[])types, (Object)clientData.getTyp())) {
            throw new BadInputException("Bad clientData: wrong typ " + clientData.getTyp());
        }
        if (!challenge.equals(clientData.getChallenge())) {
            throw new BadInputException("Bad clientData: wrong challenge");
        }
        if (facets != null && !facets.isEmpty()) {
            String canonicalOrigin;
            Set<String> allowedFacets = ClientDataValidationService.canonicalizeOrigins(facets);
            try {
                canonicalOrigin = ClientDataValidationService.canonicalizeOrigin(clientData.getOrigin());
            }
            catch (RuntimeException e) {
                throw new BadInputException("Bad clientData: Malformed origin", (Throwable)e);
            }
            ClientDataValidationService.verifyOrigin(canonicalOrigin, allowedFacets);
        }
    }

    private static void verifyOrigin(String origin, Set<String> allowedOrigins) throws BadInputException {
        if (!allowedOrigins.contains(origin)) {
            throw new BadInputException(origin + " is not a recognized facet for this application");
        }
    }

    public static Set<String> canonicalizeOrigins(Set<String> origins) {
        HashSet<String> result = new HashSet<String>();
        for (String origin : origins) {
            result.add(ClientDataValidationService.canonicalizeOrigin(origin));
        }
        return result;
    }

    public static String canonicalizeOrigin(String url) {
        try {
            URI uri = new URI(url);
            if (uri.getAuthority() == null) {
                return url;
            }
            return uri.getScheme() + "://" + uri.getAuthority();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Specified bad origin", e);
        }
    }
}

