/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.fido.u2f;

import java.net.URI;
import java.net.URISyntaxException;
import javax.ejb.Stateless;
import javax.inject.Named;
import org.xdi.net.InetAddressUtility;
import org.xdi.oxauth.exception.fido.u2f.BadConfigurationException;

@Stateless
@Named
public class ApplicationService {
    private boolean validateApplication = true;

    public boolean isValidateApplication() {
        return this.validateApplication;
    }

    public void checkIsValid(String appId) {
        if (!appId.contains(":")) {
            throw new BadConfigurationException("App ID does not look like a valid facet or URL. Web facets must start with 'https://'.");
        }
        if (appId.startsWith("http:")) {
            throw new BadConfigurationException("HTTP is not supported for App IDs. Use HTTPS instead.");
        }
        if (appId.startsWith("https://")) {
            URI url = this.checkValidUrl(appId);
            this.checkPathIsNotSlash(url);
        }
    }

    private void checkPathIsNotSlash(URI url) {
        if ("/".equals(url.getPath())) {
            throw new BadConfigurationException("The path of the URL set as App ID is '/'. This is probably not what you want -- remove the trailing slash of the App ID URL.");
        }
    }

    private URI checkValidUrl(String appId) {
        URI url = null;
        try {
            url = new URI(appId);
        }
        catch (URISyntaxException e) {
            throw new BadConfigurationException("App ID looks like a HTTPS URL, but has syntax errors.", e);
        }
        return url;
    }

    private void checkNotIpAddress(URI url) {
        if (InetAddressUtility.isIpAddress((String)url.getAuthority()) || url.getHost() != null && InetAddressUtility.isIpAddress((String)url.getHost())) {
            throw new BadConfigurationException("App ID must not be an IP-address, since it is not supported. Use a host name instead.");
        }
    }
}

