/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.external.context;

import java.util.ArrayList;
import java.util.List;
import org.xdi.oxauth.model.common.IAuthorizationGrant;
import org.xdi.oxauth.model.common.Scope;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.token.JsonWebResponse;
import org.xdi.oxauth.service.external.context.ExternalScriptContext;

public class DynamicScopeExternalContext
extends ExternalScriptContext {
    private List<Scope> dynamicScopes;
    private JsonWebResponse jsonWebResponse;
    private IAuthorizationGrant authorizationGrant;

    public DynamicScopeExternalContext(List<Scope> dynamicScopes, JsonWebResponse jsonWebResponse, IAuthorizationGrant authorizationGrant) {
        super(null);
        this.dynamicScopes = dynamicScopes;
        this.jsonWebResponse = jsonWebResponse;
        this.authorizationGrant = authorizationGrant;
    }

    public List<String> getDynamicScopes() {
        ArrayList<String> scopes = new ArrayList<String>();
        if (this.dynamicScopes != null) {
            for (Scope scope : this.dynamicScopes) {
                scopes.add(scope.getDisplayName());
            }
        }
        return scopes;
    }

    public List<Scope> getScopes() {
        return this.dynamicScopes;
    }

    public JsonWebResponse getJsonWebResponse() {
        return this.jsonWebResponse;
    }

    public IAuthorizationGrant getAuthorizationGrant() {
        return this.authorizationGrant;
    }

    public User getUser() {
        return this.authorizationGrant.getUser();
    }
}

