/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.external.context;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gluu.jsf2.service.FacesService;
import org.xdi.model.SimpleCustomProperty;
import org.xdi.oxauth.authorize.ws.rs.ConsentGatheringSessionService;
import org.xdi.oxauth.model.common.SessionId;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.service.UserService;
import org.xdi.oxauth.service.external.context.ExternalScriptContext;

public class ConsentGatheringContext
extends ExternalScriptContext {
    private final ConsentGatheringSessionService sessionService;
    private final UserService userService;
    private final FacesService facesService;
    private final AppConfiguration appConfiguration;
    private final Map<String, SimpleCustomProperty> configurationAttributes;
    private final SessionId session;
    private final Map<String, String> pageAttributes;

    public ConsentGatheringContext(Map<String, SimpleCustomProperty> configurationAttributes, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SessionId session, Map<String, String> pageAttributes, ConsentGatheringSessionService sessionService, UserService userService, FacesService facesService, AppConfiguration appConfiguration) {
        super(httpRequest, httpResponse);
        this.configurationAttributes = configurationAttributes;
        this.session = session;
        this.pageAttributes = pageAttributes;
        this.sessionService = sessionService;
        this.userService = userService;
        this.facesService = facesService;
        this.appConfiguration = appConfiguration;
    }

    public Map<String, SimpleCustomProperty> getConfigurationAttributes() {
        return this.configurationAttributes;
    }

    public User getUser(String ... returnAttributes) {
        return this.sessionService.getUser(this.httpRequest, returnAttributes);
    }

    public String getUserDn() {
        return this.sessionService.getUserDn(this.httpRequest);
    }

    public Client getClient() {
        return this.sessionService.getClient(this.session);
    }

    public Map<String, String> getConnectSessionAttributes() {
        SessionId connectSession = this.sessionService.getConnectSession(this.httpRequest);
        if (connectSession != null) {
            return new HashMap<String, String>(connectSession.getSessionAttributes());
        }
        return new HashMap<String, String>();
    }

    public boolean isAuthenticated() {
        return this.getUser(new String[0]) != null;
    }

    public Map<String, String> getPageAttributes() {
        return this.pageAttributes;
    }

    public Map<String, String[]> getRequestParameters() {
        return this.httpRequest.getParameterMap();
    }

    public int getStep() {
        return this.sessionService.getStep(this.session);
    }

    public void setStep(int step) {
        this.sessionService.setStep(step, this.session);
    }

    public void addSessionAttribute(String key, String value) {
        this.session.getSessionAttributes().put(key, value);
    }

    public void removeSessionAttribute(String key) {
        this.session.getSessionAttributes().remove(key);
    }

    public Map<String, String> getSessionAttributes() {
        return this.session.getSessionAttributes();
    }

    public void persist() {
        this.session.getSessionAttributes().putAll(this.pageAttributes);
        this.sessionService.persist(this.session);
    }

    public UserService getUserService() {
        return this.userService;
    }

    public FacesService getFacesService() {
        return this.facesService;
    }

    public AppConfiguration getAppConfiguration() {
        return this.appConfiguration;
    }
}

