/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.external;

import javax.ejb.DependsOn;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.xdi.model.custom.script.CustomScriptType;
import org.xdi.model.custom.script.conf.CustomScriptConfiguration;
import org.xdi.model.custom.script.type.introspection.IntrospectionType;
import org.xdi.oxauth.service.external.context.ExternalIntrospectionContext;
import org.xdi.service.custom.script.ExternalScriptService;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalIntrospectionService
extends ExternalScriptService {
    private static final long serialVersionUID = -8609727759114795446L;
    @Inject
    private Logger log;

    public ExternalIntrospectionService() {
        super(CustomScriptType.INTROSPECTION);
    }

    public boolean executeExternalModifyResponse(JSONObject responseAsJsonObject, ExternalIntrospectionContext context) {
        if (this.customScriptConfigurations == null || this.customScriptConfigurations.isEmpty()) {
            this.log.debug("There is no any external interception scripts defined.");
            return false;
        }
        for (CustomScriptConfiguration script : this.customScriptConfigurations) {
            if (this.executeExternalModifyResponse(script, responseAsJsonObject, context)) continue;
            this.log.debug("Stopped running external interception scripts because script {} returns false.", (Object)script.getName());
            return false;
        }
        return true;
    }

    private boolean executeExternalModifyResponse(CustomScriptConfiguration customScriptConfiguration, JSONObject responseAsJsonObject, ExternalIntrospectionContext context) {
        try {
            this.log.debug("Executing external 'executeExternalModifyResponse' method, script name: {}, responseAsJsonObject: {} , context: {}", new Object[]{customScriptConfiguration.getName(), responseAsJsonObject, context});
            IntrospectionType script = (IntrospectionType)customScriptConfiguration.getExternalType();
            context.setScript(customScriptConfiguration);
            boolean result = script.modifyResponse((Object)responseAsJsonObject, (Object)context);
            this.log.debug("Finished external 'executeExternalModifyResponse' method, script name: {}, responseAsJsonObject: {} , context: {}, result: {}", new Object[]{customScriptConfiguration.getName(), responseAsJsonObject, context, result});
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }
}

