/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.external;

import java.util.Map;
import javax.ejb.DependsOn;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.xdi.model.custom.script.CustomScriptType;
import org.xdi.model.custom.script.conf.CustomScriptConfiguration;
import org.xdi.model.custom.script.type.id.IdGeneratorType;
import org.xdi.service.custom.script.ExternalScriptService;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalIdGeneratorService
extends ExternalScriptService {
    private static final long serialVersionUID = 1727751544454591273L;

    public ExternalIdGeneratorService() {
        super(CustomScriptType.ID_GENERATOR);
    }

    public String executeExternalGenerateIdMethod(CustomScriptConfiguration customScriptConfiguration, String appId, String idType, String idPrefix) {
        try {
            this.log.debug("Executing python 'generateId' method");
            IdGeneratorType externalType = (IdGeneratorType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            return externalType.generateId(appId, idType, idPrefix, configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return null;
        }
    }

    public String executeExternalDefaultGenerateIdMethod(String appId, String idType, String idPrefix) {
        return this.executeExternalGenerateIdMethod(this.defaultExternalCustomScript, appId, idType, idPrefix);
    }
}

