/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.external;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.DependsOn;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.xdi.model.custom.script.CustomScriptType;
import org.xdi.model.custom.script.conf.CustomScriptConfiguration;
import org.xdi.model.custom.script.type.authz.ConsentGatheringType;
import org.xdi.oxauth.service.external.context.ConsentGatheringContext;
import org.xdi.service.LookupService;
import org.xdi.service.custom.script.ExternalScriptService;
import org.xdi.util.StringHelper;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalConsentGatheringService
extends ExternalScriptService {
    private static final long serialVersionUID = 1741073794567832914L;
    @Inject
    private Logger log;
    @Inject
    private LookupService lookupService;
    protected Map<String, CustomScriptConfiguration> scriptInumMap;

    public ExternalConsentGatheringService() {
        super(CustomScriptType.CONSENT_GATHERING);
    }

    protected void reloadExternal() {
        this.scriptInumMap = this.buildExternalConfigurationsInumMap(this.customScriptConfigurations);
    }

    private Map<String, CustomScriptConfiguration> buildExternalConfigurationsInumMap(List<CustomScriptConfiguration> customScriptConfigurations) {
        HashMap<String, CustomScriptConfiguration> reloadedExternalConfigurations = new HashMap<String, CustomScriptConfiguration>(customScriptConfigurations.size());
        for (CustomScriptConfiguration customScriptConfiguration : customScriptConfigurations) {
            reloadedExternalConfigurations.put(customScriptConfiguration.getInum(), customScriptConfiguration);
        }
        return reloadedExternalConfigurations;
    }

    public CustomScriptConfiguration getScriptByDn(String scriptDn) {
        String consentScriptInum = this.lookupService.getInumFromDn(scriptDn);
        return this.getScriptByInum(consentScriptInum);
    }

    public CustomScriptConfiguration getScriptByInum(String inum) {
        if (StringHelper.isEmpty((String)inum)) {
            return null;
        }
        return this.scriptInumMap.get(inum);
    }

    private ConsentGatheringType consentScript(CustomScriptConfiguration script) {
        return (ConsentGatheringType)script.getExternalType();
    }

    public boolean authorize(CustomScriptConfiguration script, int step, ConsentGatheringContext context) {
        try {
            this.log.debug("Executing python 'authorize' method, script: " + script.getName());
            boolean result = this.consentScript(script).authorize(step, (Object)context);
            this.log.debug("python 'authorize' result: " + result);
            return result;
        }
        catch (Exception ex) {
            this.log.error("Failed to execute python 'authorize' method, script: " + script.getName() + ", message: " + ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return false;
        }
    }

    public int getNextStep(CustomScriptConfiguration script, int step, ConsentGatheringContext context) {
        try {
            this.log.debug("Executing python 'getNextStep' method, script: " + script.getName());
            int result = this.consentScript(script).getNextStep(step, (Object)context);
            this.log.debug("python 'getNextStep' result: " + result);
            return result;
        }
        catch (Exception ex) {
            this.log.error("Failed to execute python 'getNextStep' method, script: " + script.getName() + ", message: " + ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return -1;
        }
    }

    public boolean prepareForStep(CustomScriptConfiguration script, int step, ConsentGatheringContext context) {
        try {
            this.log.debug("Executing python 'prepareForStep' method, script: " + script.getName());
            boolean result = this.consentScript(script).prepareForStep(step, (Object)context);
            this.log.debug("python 'prepareForStep' result: " + result);
            return result;
        }
        catch (Exception ex) {
            this.log.error("Failed to execute python 'prepareForStep' method, script: " + script.getName() + ", message: " + ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return false;
        }
    }

    public int getStepsCount(CustomScriptConfiguration script, ConsentGatheringContext context) {
        try {
            this.log.debug("Executing python 'getStepsCount' method, script: " + script.getName());
            int result = this.consentScript(script).getStepsCount((Object)context);
            this.log.debug("python 'getStepsCount' result: " + result);
            return result;
        }
        catch (Exception ex) {
            this.log.error("Failed to execute python 'getStepsCount' method, script: " + script.getName() + ", message: " + ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return -1;
        }
    }

    public String getPageForStep(CustomScriptConfiguration script, int step, ConsentGatheringContext context) {
        try {
            this.log.debug("Executing python 'getPageForStep' method, script: " + script.getName());
            String result = this.consentScript(script).getPageForStep(step, (Object)context);
            this.log.debug("python 'getPageForStep' result: " + result);
            return result;
        }
        catch (Exception ex) {
            this.log.error("Failed to execute python 'getPageForStep' method, script: " + script.getName() + ", message: " + ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return "";
        }
    }
}

