/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.slf4j.Logger;
import org.xdi.oxauth.model.config.StaticConfiguration;
import org.xdi.oxauth.model.ldap.SectorIdentifier;
import org.xdi.util.StringHelper;

@Named
public class SectorIdentifierService {
    @Inject
    private Logger log;
    @Inject
    private LdapEntryManager ldapEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;

    public SectorIdentifier getSectorIdentifierById(String oxId) {
        SectorIdentifier result = null;
        try {
            result = (SectorIdentifier)this.ldapEntryManager.find(SectorIdentifier.class, (Object)this.getDnForSectorIdentifier(oxId));
        }
        catch (Exception e) {
            this.log.error("Failed to find sector identifier by oxId " + oxId, (Throwable)e);
        }
        return result;
    }

    public String getDnForSectorIdentifier(String oxId) {
        String sectorIdentifierDn = this.staticConfiguration.getBaseDn().getSectorIdentifiers();
        if (StringHelper.isEmpty((String)oxId)) {
            return sectorIdentifierDn;
        }
        return String.format("oxId=%s,%s", oxId, sectorIdentifierDn);
    }
}

