/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.unboundid.ldap.sdk.Filter;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.slf4j.Logger;
import org.xdi.oxauth.model.common.Scope;
import org.xdi.oxauth.model.config.StaticConfiguration;
import org.xdi.service.CacheService;
import org.xdi.util.StringHelper;

@Stateless
@Named
public class ScopeService {
    private static final String CACHE_SCOPE_NAME = "ScopeCache";
    @Inject
    private Logger log;
    @Inject
    private CacheService cacheService;
    @Inject
    private LdapEntryManager ldapEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;

    public List<Scope> getAllScopesList() {
        String scopesBaseDN = this.staticConfiguration.getBaseDn().getScopes();
        return this.ldapEntryManager.findEntries(scopesBaseDN, Scope.class, Filter.createPresenceFilter((String)"inum"));
    }

    public List<String> getDefaultScopesDn() {
        ArrayList<String> defaultScopes = new ArrayList<String>();
        for (Scope scope : this.getAllScopesList()) {
            if (!scope.getIsDefault()) continue;
            defaultScopes.add(scope.getDn());
        }
        return defaultScopes;
    }

    public List<String> getScopesDn(List<String> scopeNames) {
        ArrayList<String> scopes = new ArrayList<String>();
        for (String scopeName : scopeNames) {
            Scope scope = this.getScopeByDisplayName(scopeName);
            if (scope == null) continue;
            scopes.add(scope.getDn());
        }
        return scopes;
    }

    public Scope getScopeByDn(String dn) {
        Scope scope = this.fromCacheByDn(dn);
        if (scope == null) {
            scope = (Scope)this.ldapEntryManager.find(Scope.class, (Object)dn);
            this.putInCache(scope);
        }
        return scope;
    }

    public Scope getScopeByDnSilently(String dn) {
        try {
            return this.getScopeByDn(dn);
        }
        catch (Exception e) {
            this.log.trace(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Scope getScopeByDisplayName(String displayName) {
        Scope scope = this.fromCacheByName(displayName);
        if (scope == null) {
            String scopesBaseDN = this.staticConfiguration.getBaseDn().getScopes();
            Scope scopeExample = new Scope();
            scopeExample.setDn(scopesBaseDN);
            scopeExample.setDisplayName(displayName);
            List scopes = this.ldapEntryManager.findEntries((Object)scopeExample);
            if (scopes != null && scopes.size() > 0) {
                scope = (Scope)scopes.get(0);
            }
            this.putInCache(scope);
        }
        return scope;
    }

    public List<Scope> getScopeByClaim(String claimDn) {
        List scopes = this.fromCacheByClaimDn(claimDn);
        if (scopes == null) {
            Filter filter = Filter.createEqualityFilter((String)"oxAuthClaim", (String)claimDn);
            String scopesBaseDN = this.staticConfiguration.getBaseDn().getScopes();
            scopes = this.ldapEntryManager.findEntries(scopesBaseDN, Scope.class, filter);
            this.putInCache(claimDn, scopes);
        }
        return scopes;
    }

    public List<Scope> getScopesByClaim(List<Scope> scopes, String claimDn) {
        ArrayList<Scope> result = new ArrayList<Scope>();
        for (Scope scope : scopes) {
            List<String> claims = scope.getOxAuthClaims();
            if (claims == null || !claims.contains(claimDn)) continue;
            result.add(scope);
        }
        return result;
    }

    private void putInCache(Scope scope) {
        if (scope == null) {
            return;
        }
        try {
            this.cacheService.put(CACHE_SCOPE_NAME, ScopeService.getScopeNameCacheKey(scope.getDisplayName()), (Object)scope, true);
            this.cacheService.put(CACHE_SCOPE_NAME, ScopeService.getScopeDnCacheKey(scope.getDn()), (Object)scope, true);
        }
        catch (Exception ex) {
            this.log.error("Failed to put scope in cache, scope: '{}'", (Object)scope, (Object)ex);
        }
    }

    private void putInCache(String claimDn, List<Scope> scopes) {
        if (scopes == null) {
            return;
        }
        try {
            String key = ScopeService.getClaimDnCacheKey(claimDn);
            this.cacheService.put(CACHE_SCOPE_NAME, key, scopes);
        }
        catch (Exception ex) {
            this.log.error("Failed to put scopes in cache, claimDn: '{}'", (Object)claimDn, (Object)ex);
        }
    }

    private Scope fromCacheByDn(String dn) {
        try {
            String key = ScopeService.getScopeDnCacheKey(dn);
            return (Scope)this.cacheService.get(CACHE_SCOPE_NAME, key);
        }
        catch (Exception ex) {
            this.log.error("Failed to get scope from cache, scopeDn: '{}'", (Object)dn, (Object)ex);
            return null;
        }
    }

    private Scope fromCacheByName(String name) {
        try {
            String key = ScopeService.getScopeNameCacheKey(name);
            return (Scope)this.cacheService.get(CACHE_SCOPE_NAME, key);
        }
        catch (Exception ex) {
            this.log.error("Failed to get scope from cache, name: '{}'", (Object)name, (Object)ex);
            return null;
        }
    }

    private List<Scope> fromCacheByClaimDn(String claimDn) {
        try {
            String key = ScopeService.getClaimDnCacheKey(claimDn);
            return (List)this.cacheService.get(CACHE_SCOPE_NAME, key);
        }
        catch (Exception ex) {
            this.log.error("Failed to get scopes from cache, claimDn: '{}'", (Object)claimDn, (Object)ex);
            return null;
        }
    }

    private static String getClaimDnCacheKey(String claimDn) {
        return "claim_dn" + StringHelper.toLowerCase((String)claimDn);
    }

    private static String getScopeNameCacheKey(String name) {
        return "scope_name_" + StringHelper.toLowerCase((String)name);
    }

    private static String getScopeDnCacheKey(String dn) {
        return "scope_dn_" + StringHelper.toLowerCase((String)dn);
    }
}

