/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.slf4j.Logger;
import org.xdi.oxauth.client.QueryStringDecoder;
import org.xdi.oxauth.model.common.SessionId;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.session.EndSessionErrorResponseType;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.service.ClientService;

@Stateless
@Named
public class RedirectionUriService {
    @Inject
    private Logger log;
    @Inject
    private ClientService clientService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;

    public String validateRedirectionUri(String clientIdentifier, String redirectionUri) {
        try {
            Client client = this.clientService.getClient(clientIdentifier);
            if (client != null) {
                String sectorIdentifierUri = client.getSectorIdentifierUri();
                String[] redirectUris = client.getRedirectUris();
                if (StringUtils.isNotBlank((String)sectorIdentifierUri)) {
                    ClientRequest clientRequest = new ClientRequest(sectorIdentifierUri);
                    clientRequest.setHttpMethod("GET");
                    ClientResponse clientResponse = clientRequest.get(String.class);
                    int status = clientResponse.getStatus();
                    if (status == 200) {
                        String entity = (String)clientResponse.getEntity(String.class);
                        JSONArray sectorIdentifierJsonArray = new JSONArray(entity);
                        redirectUris = new String[sectorIdentifierJsonArray.length()];
                        for (int i = 0; i < sectorIdentifierJsonArray.length(); ++i) {
                            redirectUris[i] = sectorIdentifierJsonArray.getString(i);
                        }
                    } else {
                        return null;
                    }
                }
                if (StringUtils.isNotBlank((String)redirectionUri) && redirectUris != null) {
                    this.log.debug("Validating redirection URI: clientIdentifier = {}, redirectionUri = {}, found = {}", new Object[]{clientIdentifier, redirectionUri, redirectUris.length});
                    String redirectUriWithoutParams = RedirectionUriService.uriWithoutParams(redirectionUri);
                    for (String uri : redirectUris) {
                        this.log.debug("Comparing {} == {}", (Object)uri, (Object)redirectionUri);
                        if (uri.equals(redirectionUri)) {
                            return redirectionUri;
                        }
                        String uriWithoutParams = RedirectionUriService.uriWithoutParams(uri);
                        Map<String, String> params = RedirectionUriService.getParams(uri);
                        if ((!uriWithoutParams.equals(redirectUriWithoutParams) || params.size() != 0 || RedirectionUriService.getParams(redirectionUri).size() != 0) && (!uriWithoutParams.equals(redirectUriWithoutParams) || params.size() <= 0 || !RedirectionUriService.compareParams(redirectionUri, uri))) continue;
                        return redirectionUri;
                    }
                } else if (redirectUris != null && redirectUris.length == 1) {
                    return redirectUris[0];
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public String validatePostLogoutRedirectUri(String clientId, String postLogoutRedirectUri) {
        boolean isBlank = Util.isNullOrEmpty((String)postLogoutRedirectUri);
        Client client = this.clientService.getClient(clientId);
        if (client != null) {
            String[] postLogoutRedirectUris = client.getPostLogoutRedirectUris();
            if (postLogoutRedirectUris != null && StringUtils.isNotBlank((String)postLogoutRedirectUri)) {
                this.log.debug("Validating post logout redirect URI: clientId = {}, postLogoutRedirectUri = {}", (Object)clientId, (Object)postLogoutRedirectUri);
                for (String uri : postLogoutRedirectUris) {
                    this.log.debug("Comparing {} == {}", (Object)uri, (Object)postLogoutRedirectUri);
                    if (!uri.equals(postLogoutRedirectUri)) continue;
                    return postLogoutRedirectUri;
                }
            } else if (postLogoutRedirectUris != null && postLogoutRedirectUris.length == 1) {
                return postLogoutRedirectUris[0];
            }
        }
        if (!isBlank) {
            this.errorResponseFactory.throwBadRequestException((IErrorType)EndSessionErrorResponseType.POST_LOGOUT_URI_NOT_ASSOCIATED_WITH_CLIENT);
        }
        return null;
    }

    public String validatePostLogoutRedirectUri(SessionId sessionId, String postLogoutRedirectUri) {
        if (sessionId == null) {
            this.errorResponseFactory.throwBadRequestException((IErrorType)EndSessionErrorResponseType.SESSION_NOT_PASSED);
            return null;
        }
        if (Strings.isNullOrEmpty((String)postLogoutRedirectUri)) {
            this.errorResponseFactory.throwBadRequestException((IErrorType)EndSessionErrorResponseType.POST_LOGOUT_URI_NOT_PASSED);
            return null;
        }
        HashSet clientsByDns = sessionId.getPermissionGrantedMap() != null ? this.clientService.getClient(sessionId.getPermissionGrantedMap().getClientIds(true), true) : Sets.newHashSet();
        this.log.trace("Validating post logout redirect URI: postLogoutRedirectUri = {}", (Object)postLogoutRedirectUri);
        for (Client client : clientsByDns) {
            String[] postLogoutRedirectUris = client.getPostLogoutRedirectUris();
            if (postLogoutRedirectUris == null) continue;
            for (String uri : postLogoutRedirectUris) {
                this.log.debug("Comparing {} == {}, clientId: {}", new Object[]{uri, postLogoutRedirectUri, client.getClientId()});
                if (!uri.equals(postLogoutRedirectUri)) continue;
                return postLogoutRedirectUri;
            }
        }
        this.errorResponseFactory.throwBadRequestException((IErrorType)EndSessionErrorResponseType.POST_LOGOUT_URI_NOT_ASSOCIATED_WITH_CLIENT);
        return null;
    }

    public static Map<String, String> getParams(String uri) {
        int paramsIndex;
        Map<String, String> params = new HashMap<String, String>();
        if (uri != null && (paramsIndex = uri.indexOf("?")) != -1) {
            String queryString = uri.substring(paramsIndex + 1);
            params = QueryStringDecoder.decode((String)queryString);
        }
        return params;
    }

    public static String uriWithoutParams(String uri) {
        int paramsIndex;
        if (uri != null && (paramsIndex = uri.indexOf("?")) != -1) {
            return uri.substring(0, paramsIndex);
        }
        return uri;
    }

    public static boolean compareParams(String uri1, String uri2) {
        if (StringUtils.isBlank((String)uri1) || StringUtils.isBlank((String)uri2)) {
            return false;
        }
        Map<String, String> params1 = RedirectionUriService.getParams(uri1);
        Map<String, String> params2 = RedirectionUriService.getParams(uri2);
        return params1.equals(params2);
    }
}

