/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.unboundid.ldap.sdk.Filter;
import java.net.URI;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.slf4j.Logger;
import org.xdi.ldap.model.SimpleBranch;
import org.xdi.oxauth.model.common.PairwiseIdType;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.ldap.PairwiseIdentifier;
import org.xdi.oxauth.model.util.SubjectIdentifierGenerator;
import org.xdi.oxauth.service.UserService;
import org.xdi.util.StringHelper;

@Stateless
@Named
public class PairwiseIdentifierService {
    @Inject
    private Logger log;
    @Inject
    private LdapEntryManager ldapEntryManager;
    @Inject
    private UserService userService;
    @Inject
    private AppConfiguration appConfiguration;

    public void addBranch(String userInum) {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName("pairwiseIdentifiers");
        branch.setDn(this.getBaseDnForPairwiseIdentifiers(userInum));
        this.ldapEntryManager.persist((Object)branch);
    }

    public boolean containsBranch(String userInum) {
        return this.ldapEntryManager.contains(SimpleBranch.class, this.getBaseDnForPairwiseIdentifiers(userInum));
    }

    public void prepareBranch(String userInum) {
        if (!this.containsBranch(userInum)) {
            this.addBranch(userInum);
        }
    }

    public PairwiseIdentifier findPairWiseIdentifier(String userInum, String sectorIdentifierUri, String clientId) throws Exception {
        PairwiseIdType pairwiseIdType = PairwiseIdType.fromString((String)this.appConfiguration.getPairwiseIdType());
        String sectorIdentifier = URI.create(sectorIdentifierUri).getHost();
        if (PairwiseIdType.PERSISTENT == pairwiseIdType) {
            this.prepareBranch(userInum);
            String baseDnForPairwiseIdentifiers = this.getBaseDnForPairwiseIdentifiers(userInum);
            Filter filter = null;
            if (this.appConfiguration.isShareSubjectIdBetweenClientsWithSameSectorId().booleanValue()) {
                filter = Filter.createEqualityFilter((String)"oxSectorIdentifier", (String)sectorIdentifier);
            } else {
                Filter sectorIdentifierFilter = Filter.createEqualityFilter((String)"oxSectorIdentifier", (String)sectorIdentifier);
                Filter clientIdFilter = Filter.createEqualityFilter((String)"oxAuthClientId", (String)clientId);
                filter = Filter.createANDFilter((Filter[])new Filter[]{sectorIdentifierFilter, clientIdFilter});
            }
            List entries = this.ldapEntryManager.findEntries(baseDnForPairwiseIdentifiers, PairwiseIdentifier.class, filter);
            if (entries != null && !entries.isEmpty()) {
                if (entries.size() > 1) {
                    this.log.error("Found more then one pairwise identifier by sector identifier: {}" + sectorIdentifier);
                    for (PairwiseIdentifier pairwiseIdentifier : entries) {
                        this.log.error("PairwiseIdentifier: {}", (Object)pairwiseIdentifier);
                    }
                }
                return (PairwiseIdentifier)((Object)entries.get(0));
            }
        } else {
            String key = this.appConfiguration.getPairwiseCalculationKey();
            String salt = this.appConfiguration.getPairwiseCalculationSalt();
            String localAccountId = this.appConfiguration.isShareSubjectIdBetweenClientsWithSameSectorId() != false ? userInum : userInum + clientId;
            String calculatedSub = SubjectIdentifierGenerator.generatePairwiseSubjectIdentifier((String)sectorIdentifierUri, (String)localAccountId, (String)key, (String)salt, (AppConfiguration)this.appConfiguration);
            PairwiseIdentifier pairwiseIdentifier = new PairwiseIdentifier(sectorIdentifierUri, clientId);
            pairwiseIdentifier.setId(calculatedSub);
            return pairwiseIdentifier;
        }
        return null;
    }

    public void addPairwiseIdentifier(String userInum, PairwiseIdentifier pairwiseIdentifier) {
        this.prepareBranch(userInum);
        this.userService.addUserAttributeByUserInum(userInum, "oxPPID", pairwiseIdentifier.getId());
        this.ldapEntryManager.persist((Object)pairwiseIdentifier);
    }

    public String getDnForPairwiseIdentifier(String oxId, String userInum) {
        String baseDn = this.getBaseDnForPairwiseIdentifiers(userInum);
        if (StringHelper.isEmpty((String)oxId)) {
            return baseDn;
        }
        return String.format("oxId=%s,%s", oxId, baseDn);
    }

    public String getBaseDnForPairwiseIdentifiers(String userInum) {
        String userBaseDn = this.userService.getDnForUser(userInum);
        return String.format("ou=pairwiseIdentifiers,%s", userBaseDn);
    }
}

