/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import java.lang.annotation.Annotation;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.slf4j.Logger;
import org.xdi.oxauth.model.config.Conf;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.crypto.AbstractCryptoProvider;
import org.xdi.oxauth.model.crypto.CryptoProviderFactory;
import org.xdi.oxauth.service.cdi.event.KeyGenerationEvent;
import org.xdi.service.cdi.async.Asynchronous;
import org.xdi.service.cdi.event.Scheduled;
import org.xdi.service.timer.event.TimerEvent;
import org.xdi.service.timer.schedule.TimerSchedule;

@ApplicationScoped
@Named
public class KeyGeneratorTimer {
    private static final String EVENT_TYPE = "KeyGeneratorTimerEvent";
    private static final int DEFAULT_INTERVAL = 48;
    @Inject
    private Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private LdapEntryManager ldapEntryManager;
    @Inject
    private AppConfiguration appConfiguration;
    private AtomicBoolean isActive;

    public void initTimer() {
        this.log.debug("Initializing Key Generator Timer");
        this.isActive = new AtomicBoolean(false);
        int interval = this.appConfiguration.getKeyRegenerationInterval();
        if (interval <= 0) {
            interval = 48;
        }
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(interval *= 3600, interval), (Object)new KeyGenerationEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
    }

    @Asynchronous
    public void process(@Observes @Scheduled KeyGenerationEvent keyGenerationEvent) {
        if (!this.appConfiguration.getKeyRegenerationEnabled().booleanValue()) {
            return;
        }
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.updateKeys();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.isActive.set(false);
        }
    }

    public String updateKeys() throws JSONException, Exception {
        String dn = this.configurationFactory.getLdapConfiguration().getString("oxauth_ConfigurationEntryDN");
        Conf conf = (Conf)this.ldapEntryManager.find(Conf.class, (Object)dn);
        JSONObject jwks = new JSONObject(conf.getWebKeys());
        conf.setWebKeys(this.updateKeys(jwks).toString());
        long nextRevision = conf.getRevision() + 1L;
        conf.setRevision(nextRevision);
        this.ldapEntryManager.merge((Object)conf);
        return conf.getWebKeys();
    }

    private JSONObject updateKeys(JSONObject jwks) throws Exception {
        JSONObject jsonObject = AbstractCryptoProvider.generateJwks((int)this.appConfiguration.getKeyRegenerationInterval(), (int)this.appConfiguration.getIdTokenLifetime(), (AppConfiguration)this.appConfiguration);
        JSONArray keys = jwks.getJSONArray("keys");
        for (int i = 0; i < keys.length(); ++i) {
            JSONObject key = keys.getJSONObject(i);
            if (key.has("exp") && !key.isNull("exp")) {
                GregorianCalendar now = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                GregorianCalendar expirationDate = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                expirationDate.setTimeInMillis(key.getLong("exp"));
                if (expirationDate.before(now)) {
                    this.log.debug("Removing JWK: {}, Expiration date: {}", (Object)key.getString("kid"), (Object)key.getString("exp"));
                    AbstractCryptoProvider cryptoProvider = CryptoProviderFactory.getCryptoProvider((AppConfiguration)this.appConfiguration);
                    cryptoProvider.deleteKey(key.getString("kid"));
                    continue;
                }
                jsonObject.getJSONArray("keys").put((Object)key);
                continue;
            }
            GregorianCalendar expirationTime = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            expirationTime.add(10, this.appConfiguration.getKeyRegenerationInterval());
            expirationTime.add(13, this.appConfiguration.getIdTokenLifetime());
            key.put("exp", expirationTime.getTimeInMillis());
            jsonObject.getJSONArray("keys").put((Object)key);
        }
        return jsonObject;
    }
}

