/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.StaticUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.BatchOperation;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.gluu.site.ldap.persistence.exception.EntryPersistenceException;
import org.slf4j.Logger;
import org.xdi.ldap.model.SearchScope;
import org.xdi.oxauth.audit.ApplicationAuditLogger;
import org.xdi.oxauth.model.audit.Action;
import org.xdi.oxauth.model.audit.OAuth2AuditLog;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.CacheGrant;
import org.xdi.oxauth.model.common.ClientTokens;
import org.xdi.oxauth.model.common.SessionTokens;
import org.xdi.oxauth.model.config.StaticConfiguration;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.ldap.Grant;
import org.xdi.oxauth.model.ldap.TokenLdap;
import org.xdi.oxauth.model.ldap.TokenType;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.oxauth.util.TokenHashUtil;
import org.xdi.service.CacheService;

@Stateless
@Named
public class GrantService {
    @Inject
    private Logger log;
    @Inject
    private LdapEntryManager ldapEntryManager;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private ClientService clientService;
    @Inject
    private CacheService cacheService;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private AppConfiguration appConfiguration;

    public static String generateGrantId() {
        return UUID.randomUUID().toString();
    }

    public String buildDn(String p_uniqueIdentifier, String p_grantId, String p_clientId) {
        StringBuilder dn = new StringBuilder();
        dn.append(String.format("uniqueIdentifier=%s,oxAuthGrantId=%s,", p_uniqueIdentifier, p_grantId));
        dn.append(this.clientService.buildClientDn(p_clientId));
        return dn.toString();
    }

    public String baseDn() {
        return this.staticConfiguration.getBaseDn().getClients();
    }

    public void merge(TokenLdap p_token) {
        this.ldapEntryManager.merge((Object)p_token);
    }

    public void mergeSilently(TokenLdap p_token) {
        try {
            this.ldapEntryManager.merge((Object)p_token);
        }
        catch (Exception e) {
            this.log.trace(e.getMessage(), (Throwable)e);
        }
    }

    private boolean shouldPutInCache(TokenType tokenType, boolean isImplicitFlow) {
        if (isImplicitFlow && BooleanUtils.isTrue((Boolean)this.appConfiguration.getUseCacheForAllImplicitFlowObjects())) {
            return true;
        }
        switch (tokenType) {
            case ID_TOKEN: {
                if (!ServerUtil.isTrue(this.appConfiguration.getPersistIdTokenInLdap())) {
                    return true;
                }
            }
            case REFRESH_TOKEN: {
                if (ServerUtil.isTrue(this.appConfiguration.getPersistRefreshTokenInLdap())) break;
                return true;
            }
        }
        return false;
    }

    public void persist(TokenLdap token) {
        String hashedToken = TokenHashUtil.getHashedToken(token.getTokenCode());
        token.setTokenCode(hashedToken);
        if (this.shouldPutInCache(token.getTokenTypeEnum(), token.isImplicitFlow())) {
            ClientTokens clientTokens = this.getCacheClientTokens(token.getClientId());
            clientTokens.getTokenHashes().add(hashedToken);
            String expiration = null;
            switch (token.getTokenTypeEnum()) {
                case ID_TOKEN: {
                    expiration = Integer.toString(this.appConfiguration.getIdTokenLifetime());
                    break;
                }
                case REFRESH_TOKEN: {
                    expiration = Integer.toString(this.appConfiguration.getRefreshTokenLifetime());
                    break;
                }
                case ACCESS_TOKEN: {
                    int lifetime = this.appConfiguration.getAccessTokenLifetime();
                    Client client = this.clientService.getClient(token.getClientId());
                    if (client != null && client.getAccessTokenLifetime() != null && client.getAccessTokenLifetime() > 0) {
                        lifetime = client.getAccessTokenLifetime();
                    }
                    expiration = Integer.toString(lifetime);
                }
            }
            token.setIsFromCache(true);
            this.cacheService.put(expiration, hashedToken, (Object)token);
            this.cacheService.put(expiration, clientTokens.cacheKey(), (Object)clientTokens);
            if (StringUtils.isNotBlank((String)token.getSessionDn())) {
                SessionTokens sessionTokens = this.getCacheSessionTokens(token.getSessionDn());
                sessionTokens.getTokenHashes().add(hashedToken);
                this.cacheService.put(expiration, sessionTokens.cacheKey(), (Object)sessionTokens);
            }
            return;
        }
        this.prepareGrantBranch(token.getGrantId(), token.getClientId());
        this.ldapEntryManager.persist((Object)token);
    }

    public ClientTokens getCacheClientTokens(String clientId) {
        ClientTokens clientTokens = new ClientTokens(clientId);
        Object o = this.cacheService.get(null, clientTokens.cacheKey());
        if (o instanceof ClientTokens) {
            return (ClientTokens)o;
        }
        return clientTokens;
    }

    public SessionTokens getCacheSessionTokens(String sessionDn) {
        SessionTokens sessionTokens = new SessionTokens(sessionDn);
        Object o = this.cacheService.get(null, sessionTokens.cacheKey());
        if (o instanceof SessionTokens) {
            return (SessionTokens)o;
        }
        return sessionTokens;
    }

    public void remove(Grant grant) {
        this.ldapEntryManager.remove((Object)grant);
        this.log.trace("Removed grant, id: " + grant.getId());
    }

    public void remove(TokenLdap p_token) {
        if (p_token.isFromCache()) {
            this.cacheService.remove(null, TokenHashUtil.getHashedToken(p_token.getTokenCode()));
            this.log.trace("Removed token from cache, code: " + p_token.getTokenCode());
        } else {
            this.ldapEntryManager.remove((Object)p_token);
            this.log.trace("Removed token from LDAP, code: " + p_token.getTokenCode());
        }
    }

    public void removeSilently(TokenLdap token) {
        try {
            this.remove(token);
            if (StringUtils.isNotBlank((String)token.getAuthorizationCode())) {
                this.cacheService.remove(null, CacheGrant.cacheKey(token.getClientId(), token.getAuthorizationCode(), token.getGrantId()));
            }
        }
        catch (Exception e) {
            this.log.trace(e.getMessage(), (Throwable)e);
        }
    }

    public void removeGrants(List<Grant> entries) {
        if (entries != null && !entries.isEmpty()) {
            for (Grant g : entries) {
                try {
                    this.remove(g);
                }
                catch (Exception e) {
                    this.log.error("Failed to remove entry", (Throwable)e);
                }
            }
        }
    }

    public void remove(List<TokenLdap> p_entries) {
        if (p_entries != null && !p_entries.isEmpty()) {
            for (TokenLdap t : p_entries) {
                try {
                    this.remove(t);
                }
                catch (Exception e) {
                    this.log.error("Failed to remove entry", (Throwable)e);
                }
            }
        }
    }

    public void removeSilently(List<TokenLdap> p_entries) {
        if (p_entries != null && !p_entries.isEmpty()) {
            for (TokenLdap t : p_entries) {
                this.removeSilently(t);
            }
        }
    }

    public void remove(AuthorizationGrant p_grant) {
        if (p_grant != null && p_grant.getTokenLdap() != null) {
            try {
                this.remove(p_grant.getTokenLdap());
            }
            catch (Exception e) {
                this.log.trace(e.getMessage(), (Throwable)e);
            }
        }
    }

    public List<TokenLdap> getGrantsOfClient(String p_clientId) {
        try {
            String baseDn = this.clientService.buildClientDn(p_clientId);
            return this.ldapEntryManager.findEntries(baseDn, TokenLdap.class, Filter.create((String)"oxAuthTokenCode=*"));
        }
        catch (Exception e) {
            this.log.trace(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public TokenLdap getGrantsByCodeAndClient(String p_code, String p_clientId) {
        return this.load(this.clientService.buildClientDn(p_clientId), p_code);
    }

    public TokenLdap getGrantsByCode(String p_code) {
        return this.getGrantsByCode(p_code, false);
    }

    public TokenLdap getGrantsByCode(String p_code, boolean onlyFromCache) {
        Object grant = this.cacheService.get(null, TokenHashUtil.getHashedToken(p_code));
        if (grant instanceof TokenLdap) {
            return (TokenLdap)grant;
        }
        if (onlyFromCache) {
            return null;
        }
        return this.load(this.baseDn(), p_code);
    }

    private TokenLdap load(String p_baseDn, String p_code) {
        try {
            List entries = this.ldapEntryManager.findEntries(p_baseDn, TokenLdap.class, Filter.create((String)String.format("oxAuthTokenCode=%s", TokenHashUtil.getHashedToken(p_code))));
            if (entries != null && !entries.isEmpty()) {
                return (TokenLdap)entries.get(0);
            }
        }
        catch (LDAPException e) {
            this.log.trace(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.log.trace(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public List<TokenLdap> getGrantsByGrantId(String p_grantId) {
        try {
            return this.ldapEntryManager.findEntries(this.baseDn(), TokenLdap.class, Filter.create((String)String.format("oxAuthGrantId=%s", p_grantId)));
        }
        catch (LDAPException e) {
            this.log.trace(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.log.trace(e.getMessage(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    public List<TokenLdap> getGrantsByAuthorizationCode(String p_authorizationCode) {
        try {
            return this.ldapEntryManager.findEntries(this.baseDn(), TokenLdap.class, Filter.create((String)String.format("oxAuthAuthorizationCode=%s", TokenHashUtil.getHashedToken(p_authorizationCode))));
        }
        catch (LDAPException e) {
            this.log.trace(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.log.trace(e.getMessage(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    public List<TokenLdap> getGrantsBySessionDn(String sessionDn) {
        ArrayList<TokenLdap> grants = new ArrayList<TokenLdap>();
        try {
            List ldapGrants = this.ldapEntryManager.findEntries(this.baseDn(), TokenLdap.class, Filter.create((String)String.format("oxAuthSessionDn=%s", sessionDn)));
            if (ldapGrants != null) {
                grants.addAll(ldapGrants);
            }
            grants.addAll(this.getGrantsFromCacheBySessionDn(sessionDn));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return grants;
    }

    public List<TokenLdap> getGrantsFromCacheBySessionDn(String sessionDn) {
        if (StringUtils.isBlank((String)sessionDn)) {
            return Collections.emptyList();
        }
        return this.getCacheTokensEntries(this.getCacheSessionTokens(sessionDn).getTokenHashes());
    }

    public List<TokenLdap> getCacheClientTokensEntries(String clientId) {
        Object o = this.cacheService.get(null, new ClientTokens(clientId).cacheKey());
        if (o instanceof ClientTokens) {
            return this.getCacheTokensEntries(((ClientTokens)o).getTokenHashes());
        }
        return Collections.emptyList();
    }

    public List<TokenLdap> getCacheTokensEntries(Set<String> tokenHashes) {
        ArrayList<TokenLdap> tokens = new ArrayList<TokenLdap>();
        for (String tokenHash : tokenHashes) {
            Object o1 = this.cacheService.get(null, tokenHash);
            if (!(o1 instanceof TokenLdap)) continue;
            TokenLdap token = (TokenLdap)o1;
            token.setIsFromCache(true);
            tokens.add(token);
        }
        return tokens;
    }

    public void removeAllTokensBySession(String sessionDn) {
        this.removeSilently(this.getGrantsBySessionDn(sessionDn));
    }

    public void removeByCode(String p_code, String p_clientId) {
        TokenLdap t = this.getGrantsByCodeAndClient(p_code, p_clientId);
        if (t != null) {
            this.removeSilently(t);
        }
        this.cacheService.remove(null, CacheGrant.cacheKey(p_clientId, p_code, null));
    }

    public void removeAllByAuthorizationCode(String p_authorizationCode) {
        this.removeSilently(this.getGrantsByAuthorizationCode(p_authorizationCode));
    }

    public void removeAllByGrantId(String p_grantId) {
        this.removeSilently(this.getGrantsByGrantId(p_grantId));
    }

    public void cleanUp() {
        try {
            this.cleanUpImpl();
        }
        catch (EntryPersistenceException ex) {
            this.log.error("Failed to process grant clean up properly", (Throwable)ex);
        }
    }

    private void cleanUpImpl() {
        BatchOperation<TokenLdap> tokenBatchService = new BatchOperation<TokenLdap>(this.ldapEntryManager){

            protected List<TokenLdap> getChunkOrNull(int chunkSize) {
                return GrantService.this.ldapEntryManager.findEntries(GrantService.this.baseDn(), TokenLdap.class, this.getFilter(), SearchScope.SUB, null, (BatchOperation)this, 0, chunkSize, chunkSize);
            }

            protected void performAction(List<TokenLdap> entries) {
                GrantService.this.auditLogging(entries);
                GrantService.this.remove(entries);
            }

            private Filter getFilter() {
                try {
                    return Filter.create((String)String.format("(oxAuthExpiration<=%s)", StaticUtils.encodeGeneralizedTime((Date)new Date())));
                }
                catch (LDAPException e) {
                    GrantService.this.log.trace(e.getMessage(), (Throwable)e);
                    return Filter.createPresenceFilter((String)"oxAuthExpiration");
                }
            }
        };
        tokenBatchService.iterateAllByChunks(25);
        BatchOperation<Grant> grantBatchService = new BatchOperation<Grant>(this.ldapEntryManager){

            protected List<Grant> getChunkOrNull(int chunkSize) {
                return GrantService.this.ldapEntryManager.findEntries(GrantService.this.baseDn(), Grant.class, this.getFilter(), SearchScope.SUB, null, (BatchOperation)this, 0, chunkSize, chunkSize);
            }

            protected void performAction(List<Grant> entries) {
                GrantService.this.removeGrants(entries);
            }

            private Filter getFilter() {
                try {
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(13, -60);
                    return Filter.create((String)String.format("(&(oxAuthCreation<=%s)(|(numsubordinates=0)(hasSubordinates=FALSE)))", StaticUtils.encodeGeneralizedTime((Date)calendar.getTime())));
                }
                catch (LDAPException e) {
                    GrantService.this.log.trace(e.getMessage(), (Throwable)e);
                    return Filter.createPresenceFilter((String)"oxAuthCreation");
                }
            }
        };
        grantBatchService.iterateAllByChunks(25);
        BatchOperation<Grant> oldGrantBatchService = new BatchOperation<Grant>(this.ldapEntryManager){

            protected List<Grant> getChunkOrNull(int chunkSize) {
                return GrantService.this.ldapEntryManager.findEntries(GrantService.this.baseDn(), Grant.class, this.getFilter(), SearchScope.SUB, null, (BatchOperation)this, 0, chunkSize, chunkSize);
            }

            protected void performAction(List<Grant> entries) {
                GrantService.this.removeGrants(entries);
            }

            private Filter getFilter() {
                try {
                    return Filter.create((String)"(&(!(oxAuthCreation=*))(|(numsubordinates=0)(hasSubordinates=FALSE)))");
                }
                catch (LDAPException e) {
                    GrantService.this.log.trace(e.getMessage(), (Throwable)e);
                    return Filter.createPresenceFilter((String)"oxAuthCreation");
                }
            }
        };
        oldGrantBatchService.iterateAllByChunks(25);
    }

    private void addGrantBranch(String p_grantId, String p_clientId) {
        Grant grant = new Grant();
        grant.setDn(this.getBaseDnForGrant(p_grantId, p_clientId));
        grant.setId(p_grantId);
        grant.setCreationDate(new Date());
        this.ldapEntryManager.persist((Object)grant);
    }

    private void prepareGrantBranch(String p_grantId, String p_clientId) {
        if (!this.containsGrantBranch(p_grantId, p_clientId)) {
            this.addGrantBranch(p_grantId, p_clientId);
        }
    }

    private boolean containsGrantBranch(String p_grantId, String p_clientId) {
        return this.ldapEntryManager.contains(Grant.class, this.getBaseDnForGrant(p_grantId, p_clientId));
    }

    private String getBaseDnForGrant(String p_grantId, String p_clientId) {
        StringBuilder dn = new StringBuilder();
        dn.append(String.format("oxAuthGrantId=%s,", p_grantId));
        dn.append(this.clientService.buildClientDn(p_clientId));
        return dn.toString();
    }

    private void auditLogging(Collection<TokenLdap> entries) {
        for (TokenLdap tokenLdap : entries) {
            OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(null, Action.SESSION_DESTROYED);
            oAuth2AuditLog.setSuccess(true);
            oAuth2AuditLog.setClientId(tokenLdap.getClientId());
            oAuth2AuditLog.setScope(tokenLdap.getScope());
            oAuth2AuditLog.setUsername(tokenLdap.getUserId());
            this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        }
    }
}

