/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.xdi.util.StringHelper;
import org.xdi.util.security.PropertiesDecrypter;
import org.xdi.util.security.StringEncrypter;

@ApplicationScoped
@Named
public class EncryptionService {
    @Inject
    private Logger log;
    @Inject
    private StringEncrypter stringEncrypter;

    public String decrypt(String encryptedString) throws StringEncrypter.EncryptionException {
        if (StringHelper.isEmpty((String)encryptedString)) {
            return null;
        }
        return this.stringEncrypter.decrypt(encryptedString);
    }

    public String decrypt(String encryptedValue, boolean returnSource) {
        String resultValue;
        block3: {
            if (encryptedValue == null) {
                return encryptedValue;
            }
            resultValue = returnSource ? encryptedValue : null;
            try {
                resultValue = this.stringEncrypter.decrypt(encryptedValue);
            }
            catch (Exception ex) {
                if (returnSource) break block3;
                this.log.error(String.format("Failed to decrypt value: '%s'", encryptedValue, ex));
            }
        }
        return resultValue;
    }

    public String encrypt(String unencryptedString) throws StringEncrypter.EncryptionException {
        if (StringHelper.isEmpty((String)unencryptedString)) {
            return null;
        }
        return this.stringEncrypter.encrypt(unencryptedString);
    }

    public Properties decryptProperties(Properties connectionProperties) {
        return PropertiesDecrypter.decryptProperties((StringEncrypter)this.stringEncrypter, (Properties)connectionProperties);
    }
}

