/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.google.common.collect.Sets;
import com.unboundid.ldap.sdk.Filter;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.jettison.json.JSONArray;
import org.gluu.site.ldap.persistence.BatchOperation;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.gluu.site.ldap.persistence.exception.EntryPersistenceException;
import org.python.jline.internal.Preconditions;
import org.slf4j.Logger;
import org.xdi.ldap.model.CustomAttribute;
import org.xdi.ldap.model.CustomEntry;
import org.xdi.ldap.model.SearchScope;
import org.xdi.oxauth.model.common.Scope;
import org.xdi.oxauth.model.config.StaticConfiguration;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.exception.InvalidClaimException;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.service.ClientFilterService;
import org.xdi.oxauth.service.EncryptionService;
import org.xdi.oxauth.service.ScopeService;
import org.xdi.service.CacheService;
import org.xdi.util.StringHelper;
import org.xdi.util.security.StringEncrypter;

@Stateless
@Named
public class ClientService {
    public static final String[] CLIENT_OBJECT_CLASSES = new String[]{"oxAuthClient"};
    private static final String CACHE_CLIENT_NAME = "ClientCache";
    private static final String CACHE_CLIENT_FILTER_NAME = "ClientFilterCache";
    @Inject
    private Logger log;
    @Inject
    private LdapEntryManager ldapEntryManager;
    @Inject
    private CacheService cacheService;
    @Inject
    private ScopeService scopeService;
    @Inject
    private ClientFilterService clientFilterService;
    @Inject
    private EncryptionService encryptionService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private StaticConfiguration staticConfiguration;

    private static String getClientIdCacheKey(String clientId) {
        return "client_id_" + StringHelper.toLowerCase((String)clientId);
    }

    private static String getClientDnCacheKey(String dn) {
        return "client_dn_" + StringHelper.toLowerCase((String)dn);
    }

    public void persist(Client client) {
        this.ldapEntryManager.persist((Object)client);
    }

    public void merge(Client client) {
        this.ldapEntryManager.merge((Object)client);
        this.removeFromCache(client);
    }

    public boolean authenticate(String clientId, String password) {
        this.log.debug("Authenticating Client with LDAP: clientId = {}", (Object)clientId);
        boolean authenticated = false;
        try {
            Client client = this.getClient(clientId);
            if (client == null) {
                this.log.error("Failed to find client = {}", (Object)clientId);
                return authenticated;
            }
            String decryptedClientSecret = this.decryptSecret(client.getClientSecret());
            authenticated = client != null && decryptedClientSecret != null && decryptedClientSecret.equals(password);
        }
        catch (StringEncrypter.EncryptionException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return authenticated;
    }

    public Set<Client> getClient(Collection<String> clientIds, boolean silent) {
        HashSet set = Sets.newHashSet();
        if (clientIds == null) {
            return set;
        }
        for (String clientId : clientIds) {
            try {
                Client client = this.getClient(clientId);
                if (client == null) continue;
                set.add(client);
            }
            catch (RuntimeException e) {
                if (silent) continue;
                throw e;
            }
        }
        return set;
    }

    public Client getClient(String clientId) {
        if (clientId != null && !clientId.isEmpty()) {
            Client result = this.getClientByDn(this.buildClientDn(clientId));
            this.log.debug("Found {} entries for client id = {}", (Object)(result != null ? 1 : 0), (Object)clientId);
            return result;
        }
        return null;
    }

    public Client getClient(String clientId, String registrationAccessToken) {
        Filter registrationAccessTokenInum;
        Filter filterInum;
        Filter filter;
        String baseDN = this.staticConfiguration.getBaseDn().getClients();
        List clients = this.ldapEntryManager.findEntries(baseDN, Client.class, filter = Filter.createANDFilter((Filter[])new Filter[]{filterInum = Filter.createEqualityFilter((String)"inum", (String)clientId), registrationAccessTokenInum = Filter.createEqualityFilter((String)"oxAuthRegistrationAccessToken", (String)registrationAccessToken)}), null, 1, 1);
        if (clients != null && clients.size() > 0) {
            return (Client)clients.get(0);
        }
        return null;
    }

    public Set<Client> getClientsByDns(Collection<String> dnList) {
        return this.getClientsByDns(dnList, true);
    }

    public Set<Client> getClientsByDns(Collection<String> dnList, boolean silently) {
        Preconditions.checkNotNull(dnList);
        HashSet result = Sets.newHashSet();
        for (String clientDn : dnList) {
            try {
                result.add(this.getClientByDn(clientDn));
            }
            catch (RuntimeException e) {
                if (silently) continue;
                throw e;
            }
        }
        return result;
    }

    public Client getClientByDn(String dn) {
        Client client = this.fromCache(dn);
        if (client == null) {
            try {
                client = (Client)this.ldapEntryManager.find(Client.class, (Object)dn);
                this.putInCache(client);
            }
            catch (Exception ex) {
                this.log.debug(ex.getMessage());
            }
        } else {
            this.log.trace("Get client from cache by Dn '{}'", (Object)dn);
        }
        return client;
    }

    private void putInCache(Client client) {
        if (client == null) {
            return;
        }
        try {
            this.cacheService.put(CACHE_CLIENT_FILTER_NAME, ClientService.getClientIdCacheKey(client.getClientId()), (Object)client, true);
            this.cacheService.put(CACHE_CLIENT_NAME, ClientService.getClientDnCacheKey(client.getDn()), (Object)client, true);
        }
        catch (Exception e) {
            this.log.error("Failed to put client in cache, client:" + client, (Throwable)e);
        }
    }

    private Client fromCache(String dn) {
        try {
            String key = ClientService.getClientDnCacheKey(dn);
            return (Client)this.cacheService.get(CACHE_CLIENT_NAME, key);
        }
        catch (Exception e) {
            this.log.error("Failed to fetch client from cache, dn: " + dn, (Throwable)e);
            return null;
        }
    }

    public CustomAttribute getCustomAttribute(Client client, String attributeName) {
        for (CustomAttribute customAttribute : client.getCustomAttributes()) {
            if (!StringHelper.equalsIgnoreCase((String)attributeName, (String)customAttribute.getName())) continue;
            return customAttribute;
        }
        return null;
    }

    public void setCustomAttribute(Client client, String attributeName, String attributeValue) {
        CustomAttribute customAttribute = this.getCustomAttribute(client, attributeName);
        if (customAttribute == null) {
            customAttribute = new CustomAttribute(attributeName);
            client.getCustomAttributes().add(customAttribute);
        }
        customAttribute.setValue(attributeValue);
    }

    public List<Client> getAllClients(String[] returnAttributes) {
        String baseDn = this.staticConfiguration.getBaseDn().getClients();
        List result = this.ldapEntryManager.findEntries(baseDn, Client.class, returnAttributes, null);
        return result;
    }

    public List<Client> getAllClients(String[] returnAttributes, int size) {
        String baseDn = this.staticConfiguration.getBaseDn().getClients();
        List result = this.ldapEntryManager.findEntries(baseDn, Client.class, null, returnAttributes, size, size);
        return result;
    }

    public List<Client> getClientsWithExpirationDate(BatchOperation<Client> batchOperation, int searchLimit, int sizeLimit) {
        String baseDN = this.staticConfiguration.getBaseDn().getClients();
        Filter filter = Filter.createPresenceFilter((String)"oxAuthClientSecretExpiresAt");
        return this.ldapEntryManager.findEntries(baseDN, Client.class, filter, SearchScope.SUB, null, batchOperation, 0, searchLimit, sizeLimit);
    }

    public String buildClientDn(String p_clientId) {
        StringBuilder dn = new StringBuilder();
        dn.append(String.format("inum=%s,", p_clientId));
        dn.append(this.staticConfiguration.getBaseDn().getClients());
        return dn.toString();
    }

    public void remove(Client client) {
        if (client != null) {
            this.removeFromCache(client);
            String clientDn = client.getDn();
            this.ldapEntryManager.removeWithSubtree(clientDn);
        }
    }

    private void removeFromCache(Client client) {
        try {
            String clientId = client.getClientId();
            String clientDn = client.getDn();
            this.cacheService.remove(CACHE_CLIENT_FILTER_NAME, ClientService.getClientIdCacheKey(clientId));
            this.cacheService.remove(CACHE_CLIENT_NAME, ClientService.getClientDnCacheKey(clientDn));
        }
        catch (Exception e) {
            this.log.error("Failed to remove client from cache.", (Throwable)e);
        }
    }

    public void updatAccessTime(Client client, boolean isUpdateLogonTime) {
        if (!this.appConfiguration.getUpdateClientAccessTime().booleanValue()) {
            return;
        }
        String clientDn = client.getDn();
        CustomEntry customEntry = new CustomEntry();
        customEntry.setDn(clientDn);
        customEntry.setCustomObjectClasses(CLIENT_OBJECT_CLASSES);
        Date now = new GregorianCalendar(TimeZone.getTimeZone("UTC")).getTime();
        CustomAttribute customAttributeLastAccessTime = new CustomAttribute("oxLastAccessTime", now);
        customEntry.getCustomAttributes().add(customAttributeLastAccessTime);
        if (isUpdateLogonTime) {
            CustomAttribute customAttributeLastLogonTime = new CustomAttribute("oxLastLogonTime", now);
            customEntry.getCustomAttributes().add(customAttributeLastLogonTime);
        }
        try {
            this.ldapEntryManager.merge((Object)customEntry);
        }
        catch (EntryPersistenceException epe) {
            this.log.error("Failed to update oxLastAccessTime and oxLastLogonTime of client '{}'", (Object)clientDn);
        }
        this.removeFromCache(client);
    }

    public Object getAttribute(Client client, String clientAttribute) throws InvalidClaimException {
        String attribute = null;
        if (clientAttribute != null) {
            if (clientAttribute.equals("displayName")) {
                attribute = client.getClientName();
            } else if (clientAttribute.equals("inum")) {
                attribute = client.getClientId();
            } else if (clientAttribute.equals("oxAuthAppType")) {
                attribute = client.getApplicationType();
            } else if (clientAttribute.equals("oxAuthIdTokenSignedResponseAlg")) {
                attribute = client.getIdTokenSignedResponseAlg();
            } else if (clientAttribute.equals("oxAuthRedirectURI") && client.getRedirectUris() != null) {
                JSONArray array = new JSONArray();
                for (String redirectUri : client.getRedirectUris()) {
                    array.put((Object)redirectUri);
                }
                attribute = array;
            } else if (clientAttribute.equals("oxAuthScope") && client.getScopes() != null) {
                JSONArray array = new JSONArray();
                for (String scopeDN : client.getScopes()) {
                    Scope s = this.scopeService.getScopeByDn(scopeDN);
                    if (s == null) continue;
                    String scopeName = s.getDisplayName();
                    array.put((Object)scopeName);
                }
                attribute = array;
            } else {
                for (CustomAttribute customAttribute : client.getCustomAttributes()) {
                    if (!customAttribute.getName().equals(clientAttribute)) continue;
                    List values = customAttribute.getValues();
                    if (values == null) break;
                    if (values.size() == 1) {
                        attribute = values.get(0);
                        break;
                    }
                    JSONArray array = new JSONArray();
                    for (String v : values) {
                        array.put((Object)v);
                    }
                    attribute = array;
                    break;
                }
            }
        }
        return attribute;
    }

    public String decryptSecret(String encryptedClientSecret) throws StringEncrypter.EncryptionException {
        return this.encryptionService.decrypt(encryptedClientSecret);
    }

    public String encryptSecret(String clientSecret) throws StringEncrypter.EncryptionException {
        return this.encryptionService.encrypt(clientSecret);
    }
}

