/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.DependsOn;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.service.BaseAuthFilterService;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ClientFilterService
extends BaseAuthFilterService {
    @Inject
    private LdapEntryManager ldapEntryManager;
    @Inject
    private AppConfiguration appConfiguration;

    @PostConstruct
    public void init() {
        super.init(this.appConfiguration.getClientAuthenticationFilters(), Boolean.TRUE.equals(this.appConfiguration.getClientAuthenticationFiltersEnabled()), false);
    }

    @Override
    public String processAuthenticationFilter(BaseAuthFilterService.AuthenticationFilterWithParameters authenticationFilterWithParameters, Map<?, ?> attributeValues) {
        if (attributeValues == null) {
            return null;
        }
        Map<String, String> normalizedAttributeValues = ClientFilterService.normalizeAttributeMap(attributeValues);
        String resultDn = this.loadEntryDN(this.ldapEntryManager, authenticationFilterWithParameters, normalizedAttributeValues);
        if (StringUtils.isBlank((String)resultDn)) {
            return null;
        }
        return resultDn;
    }
}

