/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.unboundid.ldap.sdk.Filter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.slf4j.Logger;
import org.xdi.ldap.model.SimpleBranch;
import org.xdi.oxauth.model.ldap.ClientAuthorizations;
import org.xdi.oxauth.service.UserService;
import org.xdi.service.CacheService;
import org.xdi.util.StringHelper;

@Stateless
@Named
public class ClientAuthorizationsService {
    @Inject
    private Logger log;
    @Inject
    private LdapEntryManager ldapEntryManager;
    @Inject
    private UserService userService;
    @Inject
    private CacheService cacheService;
    private static final String CACHE_CLIENT_CUTHORIZATION = "ClientAuthorizationCache";

    public void addBranch(String userInum) {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName("clientAuthorizations");
        branch.setDn(this.getBaseDnForClientAuthorizations(userInum));
        this.ldapEntryManager.persist((Object)branch);
    }

    public boolean containsBranch(String userInum) {
        return this.ldapEntryManager.contains(SimpleBranch.class, this.getBaseDnForClientAuthorizations(userInum));
    }

    public void prepareBranch(String userInum) {
        if (!this.containsBranch(userInum)) {
            this.addBranch(userInum);
        }
    }

    public ClientAuthorizations findClientAuthorizations(String userInum, String clientId, boolean persistInLdap) {
        if (persistInLdap) {
            this.prepareBranch(userInum);
            String baseDn = this.getBaseDnForClientAuthorizations(userInum);
            Filter filter = Filter.createEqualityFilter((String)"oxAuthClientId", (String)clientId);
            List entries = this.ldapEntryManager.findEntries(baseDn, ClientAuthorizations.class, filter);
            if (entries != null && !entries.isEmpty()) {
                if (entries.size() > 1) {
                    this.log.error("Found more then one client authorization entry by client Id: {}" + clientId);
                    for (ClientAuthorizations entry : entries) {
                        this.log.error(entry.toString());
                    }
                }
                return (ClientAuthorizations)entries.get(0);
            }
        } else {
            String key = this.getCacheKey(userInum, clientId);
            Object cacheOjb = this.cacheService.get(CACHE_CLIENT_CUTHORIZATION, key);
            if (cacheOjb != null && cacheOjb instanceof ClientAuthorizations) {
                return (ClientAuthorizations)cacheOjb;
            }
        }
        return null;
    }

    public void add(String userInum, String clientId, Set<String> scopes, boolean persistInLdap) {
        if (persistInLdap) {
            this.prepareBranch(userInum);
            ClientAuthorizations clientAuthorizations = this.findClientAuthorizations(userInum, clientId, persistInLdap);
            if (clientAuthorizations == null) {
                clientAuthorizations = new ClientAuthorizations();
                clientAuthorizations.setId(UUID.randomUUID().toString());
                clientAuthorizations.setClientId(clientId);
                clientAuthorizations.setScopes(scopes.toArray(new String[scopes.size()]));
                clientAuthorizations.setDn(this.getBaseDnForClientAuthorizations(clientAuthorizations.getId(), userInum));
                this.ldapEntryManager.persist((Object)clientAuthorizations);
            } else if (clientAuthorizations.getScopes() != null) {
                HashSet<String> set = new HashSet<String>(scopes);
                set.addAll(Arrays.asList(clientAuthorizations.getScopes()));
                clientAuthorizations.setScopes(set.toArray(new String[set.size()]));
                this.ldapEntryManager.merge((Object)clientAuthorizations);
            }
        } else {
            ClientAuthorizations clientAuthorizations = this.findClientAuthorizations(userInum, clientId, persistInLdap);
            String key = this.getCacheKey(userInum, clientId);
            if (clientAuthorizations == null) {
                clientAuthorizations = new ClientAuthorizations();
                clientAuthorizations.setId(UUID.randomUUID().toString());
                clientAuthorizations.setClientId(clientId);
                clientAuthorizations.setScopes(scopes.toArray(new String[scopes.size()]));
                clientAuthorizations.setDn(this.getBaseDnForClientAuthorizations(clientAuthorizations.getId(), userInum));
                this.cacheService.put(CACHE_CLIENT_CUTHORIZATION, key, (Object)clientAuthorizations);
            } else if (clientAuthorizations.getScopes() != null) {
                HashSet<String> set = new HashSet<String>(scopes);
                set.addAll(Arrays.asList(clientAuthorizations.getScopes()));
                clientAuthorizations.setScopes(set.toArray(new String[set.size()]));
                this.cacheService.put(CACHE_CLIENT_CUTHORIZATION, key, (Object)clientAuthorizations);
            }
        }
    }

    public String getBaseDnForClientAuthorizations(String oxId, String userInum) {
        String baseDn = this.getBaseDnForClientAuthorizations(userInum);
        if (StringHelper.isEmpty((String)oxId)) {
            return baseDn;
        }
        return String.format("oxId=%s,%s", oxId, baseDn);
    }

    public String getBaseDnForClientAuthorizations(String userInum) {
        String userBaseDn = this.userService.getDnForUser(userInum);
        return String.format("ou=clientAuthorizations,%s", userBaseDn);
    }

    private String getCacheKey(String userInum, String clientId) {
        return userInum + "_" + clientId;
    }
}

