/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import java.lang.annotation.Annotation;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ejb.DependsOn;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.oxauth.fido2.persist.AuthenticationPersistenceService;
import org.gluu.oxauth.fido2.persist.RegistrationPersistenceService;
import org.gluu.site.ldap.persistence.BatchOperation;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.slf4j.Logger;
import org.xdi.model.ApplicationType;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantList;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.fido.u2f.DeviceRegistration;
import org.xdi.oxauth.model.fido.u2f.RequestMessageLdap;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.GrantService;
import org.xdi.oxauth.service.MetricService;
import org.xdi.oxauth.service.SessionIdService;
import org.xdi.oxauth.service.fido.u2f.DeviceRegistrationService;
import org.xdi.oxauth.service.fido.u2f.RequestService;
import org.xdi.oxauth.uma.service.UmaPctService;
import org.xdi.oxauth.uma.service.UmaPermissionService;
import org.xdi.oxauth.uma.service.UmaResourceService;
import org.xdi.oxauth.uma.service.UmaRptService;
import org.xdi.service.cache.CacheProvider;
import org.xdi.service.cdi.async.Asynchronous;
import org.xdi.service.cdi.event.CleanerEvent;
import org.xdi.service.cdi.event.Scheduled;
import org.xdi.service.timer.event.TimerEvent;
import org.xdi.service.timer.schedule.TimerSchedule;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class CleanerTimer {
    public static final int BATCH_SIZE = 25;
    private static final int DEFAULT_INTERVAL = 600;
    @Inject
    private Logger log;
    @Inject
    private LdapEntryManager ldapEntryManager;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private ClientService clientService;
    @Inject
    private GrantService grantService;
    @Inject
    private UmaRptService umaRptService;
    @Inject
    private UmaPctService umaPctService;
    @Inject
    private UmaPermissionService umaPermissionService;
    @Inject
    private UmaResourceService umaResourceService;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private CacheProvider cacheProvider;
    @Inject
    @Named(value="u2fRequestService")
    private RequestService u2fRequestService;
    @Inject
    private AuthenticationPersistenceService authenticationPersistenceService;
    @Inject
    private RegistrationPersistenceService registrationPersistenceService;
    @Inject
    private MetricService metricService;
    @Inject
    private DeviceRegistrationService deviceRegistrationService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private Event<TimerEvent> cleanerEvent;
    private AtomicBoolean isActive;

    public void initTimer() {
        this.log.debug("Initializing Cleaner Timer");
        this.isActive = new AtomicBoolean(false);
        int interval = this.appConfiguration.getCleanServiceInterval();
        if (interval <= 0) {
            interval = 600;
        }
        this.cleanerEvent.fire((Object)new TimerEvent(new TimerSchedule(interval, interval), (Object)new CleanerEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
    }

    @Asynchronous
    public void process(@Observes @Scheduled CleanerEvent cleanerEvent) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            Date now = new Date();
            this.processCache(now);
            this.processAuthorizationGrantList();
            this.processRegisteredClients();
            this.umaRptService.cleanup(now);
            this.umaPermissionService.cleanup(now);
            this.umaPctService.cleanup(now);
            this.umaResourceService.cleanup(now);
            this.processU2fRequests();
            this.processU2fDeviceRegistrations();
            this.registrationPersistenceService.cleanup(now, 25);
            this.authenticationPersistenceService.cleanup(now, 25);
            this.processMetricEntries();
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void processCache(Date now) {
        try {
            this.cacheProvider.cleanup(now);
        }
        catch (Exception e) {
            this.log.error("Failed to clean up cache.", (Throwable)e);
        }
    }

    private void processAuthorizationGrantList() {
        this.log.debug("Start AuthorizationGrant clean up");
        this.grantService.cleanUp();
        this.log.debug("End AuthorizationGrant clean up");
    }

    private void processRegisteredClients() {
        this.log.debug("Start Client clean up");
        BatchOperation<Client> clientBatchService = new BatchOperation<Client>(this.ldapEntryManager){

            protected List<Client> getChunkOrNull(int chunkSize) {
                return CleanerTimer.this.clientService.getClientsWithExpirationDate(this, chunkSize, chunkSize);
            }

            protected void performAction(List<Client> entries) {
                for (Client client : entries) {
                    try {
                        GregorianCalendar now = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                        GregorianCalendar expirationDate = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                        expirationDate.setTime(client.getClientSecretExpiresAt());
                        if (!expirationDate.before(now)) continue;
                        List<AuthorizationGrant> toRemove = CleanerTimer.this.authorizationGrantList.getAuthorizationGrant(client.getClientId());
                        CleanerTimer.this.authorizationGrantList.removeAuthorizationGrants(toRemove);
                        CleanerTimer.this.log.debug("Removing Client: {}, Expiration date: {}", (Object)client.getClientId(), (Object)client.getClientSecretExpiresAt());
                        CleanerTimer.this.clientService.remove(client);
                    }
                    catch (Exception e) {
                        CleanerTimer.this.log.error("Failed to remove entry", (Throwable)e);
                    }
                }
            }
        };
        clientBatchService.iterateAllByChunks(25);
        this.log.debug("End Client clean up");
    }

    private void processU2fRequests() {
        this.log.debug("Start U2F request clean up");
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        ((Calendar)calendar).add(13, -90);
        final Date expirationDate = calendar.getTime();
        BatchOperation<RequestMessageLdap> requestMessageLdapBatchService = new BatchOperation<RequestMessageLdap>(this.ldapEntryManager){

            protected List<RequestMessageLdap> getChunkOrNull(int chunkSize) {
                return CleanerTimer.this.u2fRequestService.getExpiredRequestMessages(this, expirationDate);
            }

            protected void performAction(List<RequestMessageLdap> entries) {
                for (RequestMessageLdap requestMessageLdap : entries) {
                    try {
                        CleanerTimer.this.log.debug("Removing RequestMessageLdap: {}, Creation date: {}", (Object)requestMessageLdap.getRequestId(), (Object)requestMessageLdap.getCreationDate());
                        CleanerTimer.this.u2fRequestService.removeRequestMessage(requestMessageLdap);
                    }
                    catch (Exception e) {
                        CleanerTimer.this.log.error("Failed to remove entry", (Throwable)e);
                    }
                }
            }
        };
        requestMessageLdapBatchService.iterateAllByChunks(25);
        this.log.debug("End U2F request clean up");
    }

    private void processU2fDeviceRegistrations() {
        this.log.debug("Start U2F request clean up");
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        ((Calendar)calendar).add(13, -90);
        final Date expirationDate = calendar.getTime();
        BatchOperation<DeviceRegistration> deviceRegistrationBatchService = new BatchOperation<DeviceRegistration>(this.ldapEntryManager){

            protected List<DeviceRegistration> getChunkOrNull(int chunkSize) {
                return CleanerTimer.this.deviceRegistrationService.getExpiredDeviceRegistrations(this, expirationDate);
            }

            protected void performAction(List<DeviceRegistration> entries) {
                for (DeviceRegistration deviceRegistration : entries) {
                    try {
                        CleanerTimer.this.log.debug("Removing DeviceRegistration: {}, Creation date: {}", (Object)deviceRegistration.getId(), (Object)deviceRegistration.getCreationDate());
                        CleanerTimer.this.deviceRegistrationService.removeUserDeviceRegistration(deviceRegistration);
                    }
                    catch (Exception e) {
                        CleanerTimer.this.log.error("Failed to remove entry", (Throwable)e);
                    }
                }
            }
        };
        deviceRegistrationBatchService.iterateAllByChunks(25);
        this.log.debug("End U2F request clean up");
    }

    private void processMetricEntries() {
        this.log.debug("Start metric entries clean up");
        int keepDataDays = this.appConfiguration.getMetricReporterKeepDataDays();
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        ((Calendar)calendar).add(5, -keepDataDays);
        Date expirationDate = calendar.getTime();
        this.metricService.removeExpiredMetricEntries(25, expirationDate, ApplicationType.OX_AUTH, this.metricService.applianceInum());
        this.log.debug("End metric entries clean up");
    }
}

