/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ejb.Stateless;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gluu.jsf2.message.FacesMessages;
import org.gluu.jsf2.service.FacesService;
import org.slf4j.Logger;
import org.xdi.model.security.Identity;
import org.xdi.oxauth.auth.Authenticator;
import org.xdi.oxauth.model.authorize.AuthorizeErrorResponseType;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.common.Scope;
import org.xdi.oxauth.model.common.SessionId;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.util.StringUtils;
import org.xdi.oxauth.service.ClientAuthorizationsService;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.RequestParameterService;
import org.xdi.oxauth.service.ScopeService;
import org.xdi.oxauth.service.SessionIdService;
import org.xdi.oxauth.service.UserService;
import org.xdi.oxauth.util.ServerUtil;

@Stateless
@Named
public class AuthorizeService {
    public static final List<String> ALLOWED_PARAMETER = Collections.unmodifiableList(Arrays.asList("scope", "response_type", "client_id", "redirect_uri", "state", "response_mode", "nonce", "display", "prompt", "max_age", "ui_locales", "id_token_hint", "login_hint", "acr_values", "session_id", "request", "request_uri", "origin_headers", "code_challenge", "code_challenge_method", "custom_response_headers", "claims"));
    @Inject
    private Logger log;
    @Inject
    private ClientService clientService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private UserService userService;
    @Inject
    private ClientAuthorizationsService clientAuthorizationsService;
    @Inject
    private Identity identity;
    @Inject
    private Authenticator authenticator;
    @Inject
    private FacesService facesService;
    @Inject
    private FacesMessages facesMessages;
    @Inject
    private ExternalContext externalContext;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ScopeService scopeService;
    @Inject
    private RequestParameterService requestParameterService;

    public SessionId getSession() {
        return this.getSession(null);
    }

    public SessionId getSession(String sessionId) {
        SessionId ldapSessionId;
        if (org.apache.commons.lang.StringUtils.isBlank((String)sessionId) && org.apache.commons.lang.StringUtils.isBlank((String)(sessionId = this.sessionIdService.getSessionIdFromCookie()))) {
            return null;
        }
        if (!this.identity.isLoggedIn()) {
            this.authenticator.authenticateBySessionId(sessionId);
        }
        if ((ldapSessionId = this.sessionIdService.getSessionId(sessionId)) == null) {
            this.identity.logout();
        }
        return ldapSessionId;
    }

    public void permissionGranted(HttpServletRequest httpRequest, SessionId session) {
        this.log.trace("permissionGranted");
        try {
            Map<String, String> sessionAttribute;
            boolean persistDuringImplicitFlow;
            User user = this.userService.getUserByDn(session.getUserDn(), new String[0]);
            if (user == null) {
                this.log.error("Permission denied. Failed to find session user: userDn = " + session.getUserDn() + ".");
                this.permissionDenied(session);
                return;
            }
            String clientId = session.getSessionAttributes().get("client_id");
            Client client = this.clientService.getClient(clientId);
            String scope = session.getSessionAttributes().get("scope");
            String responseType = session.getSessionAttributes().get("response_type");
            boolean bl = persistDuringImplicitFlow = ServerUtil.isFalse(this.appConfiguration.getUseCacheForAllImplicitFlowObjects()) || !ResponseType.isImplicitFlow((String)responseType);
            if (!client.getTrustedClient() && persistDuringImplicitFlow) {
                HashSet scopes = Sets.newHashSet((Iterable)StringUtils.spaceSeparatedToList((String)scope));
                this.clientAuthorizationsService.add(user.getAttribute("inum"), client.getClientId(), scopes, client.getPersistClientAuthorizations());
            }
            session.addPermission(clientId, true);
            this.sessionIdService.updateSessionId(session);
            if (!this.appConfiguration.getInvalidateSessionCookiesAfterAuthorizationFlow().booleanValue()) {
                this.sessionIdService.createSessionIdCookie(session.getId(), session.getSessionState(), session.getOPBrowserState(), false);
            }
            if ((sessionAttribute = this.requestParameterService.getAllowedParameters(session.getSessionAttributes())).containsKey("prompt")) {
                List prompts = Prompt.fromString((String)sessionAttribute.get("prompt"), (String)" ");
                prompts.remove(Prompt.CONSENT);
                sessionAttribute.put("prompt", StringUtils.implodeEnum((List)prompts, (String)" "));
            }
            String parametersAsString = this.requestParameterService.parametersAsString(sessionAttribute);
            String uri = httpRequest.getContextPath() + "/restv1/authorize?" + parametersAsString;
            this.log.trace("permissionGranted, redirectTo: {}", (Object)uri);
            if (this.invalidateSessionCookiesIfNeeded() && !uri.contains("session_id")) {
                uri = uri + "&session_id=" + session.getId();
            }
            this.facesService.redirectToExternalURL(uri);
        }
        catch (UnsupportedEncodingException e) {
            this.log.trace(e.getMessage(), (Throwable)e);
        }
    }

    public void permissionDenied(SessionId session) {
        this.log.trace("permissionDenied");
        this.invalidateSessionCookiesIfNeeded();
        if (session == null) {
            this.authenticationFailedSessionInvalid();
            return;
        }
        StringBuilder sb = new StringBuilder();
        String redirectUri = session.getSessionAttributes().get("redirect_uri");
        String state = session.getSessionAttributes().get("state");
        sb.append(redirectUri);
        if (redirectUri != null && redirectUri.contains("?")) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        sb.append(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED, state));
        this.facesService.redirectToExternalURL(sb.toString());
    }

    private void authenticationFailedSessionInvalid() {
        this.facesMessages.add(FacesMessage.SEVERITY_ERROR, "login.errorSessionInvalidMessage");
        this.facesService.redirect("/error.xhtml");
    }

    public List<Scope> getScopes() {
        SessionId session = this.getSession();
        String scope = session.getSessionAttributes().get("scope");
        return this.getScopes(scope);
    }

    public List<Scope> getScopes(String scopes) {
        ArrayList<Scope> result = new ArrayList<Scope>();
        if (scopes != null && !scopes.isEmpty()) {
            String[] scopesName;
            for (String scopeName : scopesName = scopes.split(" ")) {
                Scope s = this.scopeService.getScopeByDisplayName(scopeName);
                if (s == null || s.getDescription() == null) continue;
                result.add(s);
            }
        }
        return result;
    }

    private boolean invalidateSessionCookiesIfNeeded() {
        if (this.appConfiguration.getInvalidateSessionCookiesAfterAuthorizationFlow().booleanValue()) {
            return this.invalidateSessionCookies();
        }
        return false;
    }

    private boolean invalidateSessionCookies() {
        try {
            if (this.externalContext.getResponse() instanceof HttpServletResponse) {
                HttpServletResponse httpResponse = (HttpServletResponse)this.externalContext.getResponse();
                this.log.trace("Invalidated {} cookie.", (Object)"session_id");
                httpResponse.addHeader("Set-Cookie", "session_id=deleted; Path=/; Secure; HttpOnly; Expires=Thu, 01 Jan 1970 00:00:01 GMT;");
                this.log.trace("Invalidated {} cookie.", (Object)"consent_session_id");
                httpResponse.addHeader("Set-Cookie", "consent_session_id=deleted; Path=/; Secure; HttpOnly; Expires=Thu, 01 Jan 1970 00:00:01 GMT;");
                return true;
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

