/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.codahale.metrics.Timer;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.Stateless;
import javax.faces.context.ExternalContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.gluu.jsf2.service.FacesService;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.gluu.site.ldap.persistence.exception.EntryPersistenceException;
import org.slf4j.Logger;
import org.xdi.ldap.model.CustomAttribute;
import org.xdi.ldap.model.CustomEntry;
import org.xdi.ldap.model.GluuStatus;
import org.xdi.model.SimpleProperty;
import org.xdi.model.ldap.GluuLdapConfiguration;
import org.xdi.model.metric.MetricType;
import org.xdi.model.security.Credentials;
import org.xdi.model.security.SimplePrincipal;
import org.xdi.oxauth.model.common.SessionId;
import org.xdi.oxauth.model.common.SimpleUser;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.session.SessionClient;
import org.xdi.oxauth.security.Identity;
import org.xdi.oxauth.service.AuthenticationProtectionService;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.MetricService;
import org.xdi.oxauth.service.RequestParameterService;
import org.xdi.oxauth.service.SessionIdService;
import org.xdi.oxauth.service.UserService;
import org.xdi.oxauth.service.external.ExternalAuthenticationService;
import org.xdi.util.StringHelper;

@Stateless
@Named
public class AuthenticationService {
    private static final String EVENT_CONTEXT_AUTHENTICATED_USER = "authenticatedUser";
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private Identity identity;
    @Inject
    private Credentials credentials;
    @Inject
    @Named(value="ldapAuthConfig")
    private List<GluuLdapConfiguration> ldapAuthConfigs;
    @Inject
    private LdapEntryManager ldapEntryManager;
    @Inject
    @Named(value="ldapAuthEntryManager")
    private List<LdapEntryManager> ldapAuthEntryManagers;
    @Inject
    private UserService userService;
    @Inject
    private ClientService clientService;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private ExternalAuthenticationService externalAuthenticationService;
    @Inject
    private MetricService metricService;
    @Inject
    private ExternalContext externalContext;
    @Inject
    private FacesService facesService;
    @Inject
    private RequestParameterService requestParameterService;
    @Inject
    private AuthenticationProtectionService authenticationProtectionService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String userName, String password) {
        this.log.debug("Authenticating user with LDAP: username: '{}', credentials: '{}'", (Object)userName, (Object)System.identityHashCode(this.credentials));
        boolean authenticated = false;
        boolean protectionServiceEnabled = this.authenticationProtectionService.isEnabled();
        Timer.Context timerContext = this.metricService.getTimer(MetricType.OXAUTH_USER_AUTHENTICATION_RATE).time();
        try {
            authenticated = this.ldapAuthConfigs == null || this.ldapAuthConfigs.size() == 0 ? this.localAuthenticate(userName, password) : this.externalAuthenticate(userName, password);
        }
        finally {
            timerContext.stop();
        }
        String userId = userName;
        if (this.identity.getUser() != null && StringHelper.isNotEmpty((String)this.identity.getUser().getUserId())) {
            userId = this.identity.getUser().getUserId();
        }
        this.setAuthenticatedUserSessionAttribute(userId, authenticated);
        MetricType metricType = authenticated ? MetricType.OXAUTH_USER_AUTHENTICATION_SUCCESS : MetricType.OXAUTH_USER_AUTHENTICATION_FAILURES;
        this.metricService.incCounter(metricType);
        if (protectionServiceEnabled) {
            this.authenticationProtectionService.storeAttempt(userId, authenticated);
            this.authenticationProtectionService.doDelayIfNeeded(userId);
        }
        return authenticated;
    }

    private void setAuthenticatedUserSessionAttribute(String userName, boolean authenticated) {
        SessionId sessionId = this.sessionIdService.getSessionId();
        if (sessionId != null) {
            Map<String, String> sessionIdAttributes = sessionId.getSessionAttributes();
            if (authenticated) {
                sessionIdAttributes.put("auth_user", userName);
            }
            this.sessionIdService.updateSessionIdIfNeeded(sessionId, authenticated);
        }
    }

    private boolean localAuthenticate(String userName, String password) {
        User user = this.userService.getUser(userName, new String[0]);
        if (user != null) {
            if (!this.checkUserStatus(user)) {
                return false;
            }
            boolean authenticated = this.ldapEntryManager.authenticate(user.getDn(), password);
            if (authenticated) {
                this.configureAuthenticatedUser(user);
                this.updateLastLogonUserTime(user);
                this.log.trace("Authenticate: credentials: '{}', credentials.userName: '{}', authenticatedUser.userId: '{}'", new Object[]{System.identityHashCode(this.credentials), this.credentials.getUsername(), this.getAuthenticatedUserId()});
            }
            return authenticated;
        }
        return false;
    }

    private boolean externalAuthenticate(String keyValue, String password) {
        for (int i = 0; i < this.ldapAuthConfigs.size(); ++i) {
            boolean authenticated;
            GluuLdapConfiguration ldapAuthConfig = this.ldapAuthConfigs.get(i);
            LdapEntryManager ldapAuthEntryManager = this.ldapAuthEntryManagers.get(i);
            String primaryKey = "uid";
            if (StringHelper.isNotEmpty((String)ldapAuthConfig.getPrimaryKey())) {
                primaryKey = ldapAuthConfig.getPrimaryKey();
            }
            String localPrimaryKey = "uid";
            if (StringHelper.isNotEmpty((String)ldapAuthConfig.getLocalPrimaryKey())) {
                localPrimaryKey = ldapAuthConfig.getLocalPrimaryKey();
            }
            if (!(authenticated = this.authenticate(ldapAuthConfig, ldapAuthEntryManager, keyValue, password, primaryKey, localPrimaryKey))) continue;
            return authenticated;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String keyValue, String password, String primaryKey, String localPrimaryKey) {
        if (this.ldapAuthConfigs == null) {
            return this.authenticate(null, this.ldapEntryManager, keyValue, password, primaryKey, localPrimaryKey);
        }
        boolean authenticated = false;
        boolean protectionServiceEnabled = this.authenticationProtectionService.isEnabled();
        Timer.Context timerContext = this.metricService.getTimer(MetricType.OXAUTH_USER_AUTHENTICATION_RATE).time();
        try {
            for (int i = 0; i < this.ldapAuthConfigs.size(); ++i) {
                LdapEntryManager ldapAuthEntryManager;
                GluuLdapConfiguration ldapAuthConfig = this.ldapAuthConfigs.get(i);
                authenticated = this.authenticate(ldapAuthConfig, ldapAuthEntryManager = this.ldapAuthEntryManagers.get(i), keyValue, password, primaryKey, localPrimaryKey);
                if (!authenticated) continue;
                break;
            }
        }
        finally {
            timerContext.stop();
        }
        String userId = null;
        if (this.identity.getUser() != null && StringHelper.isNotEmpty((String)this.identity.getUser().getUserId())) {
            userId = this.identity.getUser().getUserId();
        }
        this.setAuthenticatedUserSessionAttribute(userId, authenticated);
        MetricType metricType = authenticated ? MetricType.OXAUTH_USER_AUTHENTICATION_SUCCESS : MetricType.OXAUTH_USER_AUTHENTICATION_FAILURES;
        this.metricService.incCounter(metricType);
        if (protectionServiceEnabled) {
            this.authenticationProtectionService.storeAttempt(keyValue, authenticated);
            this.authenticationProtectionService.doDelayIfNeeded(keyValue);
        }
        return authenticated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(GluuLdapConfiguration ldapAuthConfig, LdapEntryManager ldapAuthEntryManager, String keyValue, String password, String primaryKey, String localPrimaryKey) {
        boolean authenticated = false;
        boolean protectionServiceEnabled = this.authenticationProtectionService.isEnabled();
        Timer.Context timerContext = this.metricService.getTimer(MetricType.OXAUTH_USER_AUTHENTICATION_RATE).time();
        try {
            authenticated = this.authenticateImpl(ldapAuthConfig, ldapAuthEntryManager, keyValue, password, primaryKey, localPrimaryKey);
        }
        finally {
            timerContext.stop();
        }
        String userId = keyValue;
        if (this.identity.getUser() != null && StringHelper.isNotEmpty((String)this.identity.getUser().getUserId())) {
            userId = this.identity.getUser().getUserId();
        }
        this.setAuthenticatedUserSessionAttribute(userId, authenticated);
        MetricType metricType = authenticated ? MetricType.OXAUTH_USER_AUTHENTICATION_SUCCESS : MetricType.OXAUTH_USER_AUTHENTICATION_FAILURES;
        this.metricService.incCounter(metricType);
        if (protectionServiceEnabled) {
            this.authenticationProtectionService.storeAttempt(userId, authenticated);
            this.authenticationProtectionService.doDelayIfNeeded(userId);
        }
        return authenticated;
    }

    private boolean authenticateImpl(GluuLdapConfiguration ldapAuthConfig, LdapEntryManager ldapAuthEntryManager, String keyValue, String password, String primaryKey, String localPrimaryKey) {
        this.log.debug("Attempting to find userDN by primary key: '{}' and key value: '{}', credentials: '{}'", new Object[]{primaryKey, keyValue, System.identityHashCode(this.credentials)});
        try {
            List<String> baseDNs = ldapAuthConfig == null ? Arrays.asList(this.userService.getDnForUser(null)) : ldapAuthConfig.getBaseDNs();
            if (baseDNs != null && !baseDNs.isEmpty()) {
                for (Object e : baseDNs) {
                    String baseDn = e instanceof SimpleProperty ? ((SimpleProperty)e).getValue() : e.toString();
                    User user = this.getUserByAttribute(ldapAuthEntryManager, baseDn, primaryKey, keyValue);
                    if (user == null) continue;
                    String userDn = user.getDn();
                    this.log.debug("Attempting to authenticate userDN: {}", (Object)userDn);
                    if (!ldapAuthEntryManager.authenticate(userDn, password)) continue;
                    this.log.debug("User authenticated: {}", (Object)userDn);
                    this.log.debug("Attempting to find userDN by local primary key: {}", (Object)localPrimaryKey);
                    User localUser = this.userService.getUserByAttribute(localPrimaryKey, keyValue);
                    if (localUser == null) continue;
                    if (!this.checkUserStatus(localUser)) {
                        return false;
                    }
                    this.configureAuthenticatedUser(localUser);
                    this.updateLastLogonUserTime(localUser);
                    this.log.trace("authenticate_external: credentials: '{}', credentials.userName: '{}', authenticatedUser.userId: '{}'", new Object[]{System.identityHashCode(this.credentials), this.credentials.getUsername(), this.getAuthenticatedUserId()});
                    return true;
                }
            } else {
                this.log.error("There are no baseDns specified in authentication configuration.");
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String userName) {
        this.log.debug("Authenticating user with LDAP: username: '{}', credentials: '{}'", (Object)userName, (Object)System.identityHashCode(this.credentials));
        boolean authenticated = false;
        boolean protectionServiceEnabled = this.authenticationProtectionService.isEnabled();
        Timer.Context timerContext = this.metricService.getTimer(MetricType.OXAUTH_USER_AUTHENTICATION_RATE).time();
        try {
            User user = this.userService.getUser(userName, new String[0]);
            if (user != null && this.checkUserStatus(user)) {
                this.credentials.setUsername(user.getUserId());
                this.configureAuthenticatedUser(user);
                this.updateLastLogonUserTime(user);
                this.log.trace("Authenticate: credentials: '{}', credentials.userName: '{}', authenticatedUser.userId: '{}'", new Object[]{System.identityHashCode(this.credentials), this.credentials.getUsername(), this.getAuthenticatedUserId()});
                authenticated = true;
            }
        }
        finally {
            timerContext.stop();
        }
        this.setAuthenticatedUserSessionAttribute(userName, authenticated);
        MetricType metricType = authenticated ? MetricType.OXAUTH_USER_AUTHENTICATION_SUCCESS : MetricType.OXAUTH_USER_AUTHENTICATION_FAILURES;
        this.metricService.incCounter(metricType);
        if (protectionServiceEnabled) {
            this.authenticationProtectionService.storeAttempt(userName, authenticated);
            this.authenticationProtectionService.doDelayIfNeeded(userName);
        }
        return authenticated;
    }

    private User getUserByAttribute(LdapEntryManager ldapAuthEntryManager, String baseDn, String attributeName, String attributeValue) {
        this.log.debug("Getting user information from LDAP: attributeName = '{}', attributeValue = '{}'", (Object)attributeName, (Object)attributeValue);
        if (StringHelper.isEmpty((String)attributeValue)) {
            return null;
        }
        SimpleUser sampleUser = new SimpleUser();
        sampleUser.setDn(baseDn);
        ArrayList<CustomAttribute> customAttributes = new ArrayList<CustomAttribute>();
        customAttributes.add(new CustomAttribute(attributeName, attributeValue));
        sampleUser.setCustomAttributes(customAttributes);
        this.log.debug("Searching user by attributes: '{}', baseDn: '{}'", customAttributes, (Object)baseDn);
        List entries = ldapAuthEntryManager.findEntries((Object)sampleUser, 1);
        this.log.debug("Found '{}' entries", (Object)entries.size());
        if (entries.size() > 0) {
            SimpleUser foundUser = (SimpleUser)entries.get(0);
            return (User)ldapAuthEntryManager.find(User.class, (Object)foundUser.getDn());
        }
        return null;
    }

    private boolean checkUserStatus(User user) {
        CustomAttribute userStatus = this.userService.getCustomAttribute(user, "gluuStatus");
        if (userStatus != null && GluuStatus.ACTIVE.equals((Object)GluuStatus.getByValue((String)userStatus.getValue()))) {
            return true;
        }
        this.log.warn("User '{}' was disabled", (Object)user.getUserId());
        return false;
    }

    private void updateLastLogonUserTime(User user) {
        if (!this.appConfiguration.getUpdateUserLastLogonTime().booleanValue()) {
            return;
        }
        CustomEntry customEntry = new CustomEntry();
        customEntry.setDn(user.getDn());
        List personCustomObjectClassList = this.appConfiguration.getPersonCustomObjectClassList();
        if (personCustomObjectClassList != null && !personCustomObjectClassList.isEmpty()) {
            customEntry.setCustomObjectClasses(personCustomObjectClassList.toArray(new String[personCustomObjectClassList.size()]));
        } else {
            customEntry.setCustomObjectClasses(UserService.USER_OBJECT_CLASSES);
        }
        CustomAttribute customAttribute = new CustomAttribute("oxLastLogonTime", new Date());
        customEntry.getCustomAttributes().add(customAttribute);
        try {
            this.ldapEntryManager.merge((Object)customEntry);
        }
        catch (EntryPersistenceException epe) {
            this.log.error("Failed to update oxLastLogonTime of user '{}'", (Object)user.getUserId());
        }
    }

    public SessionId configureSessionUser(SessionId sessionId, Map<String, String> sessionIdAttributes) {
        SessionId newSessionId;
        this.log.trace("configureSessionUser: credentials: '{}', sessionId: '{}', credentials.userName: '{}', authenticatedUser.userId: '{}'", new Object[]{System.identityHashCode(this.credentials), sessionId, this.credentials.getUsername(), this.getAuthenticatedUserId()});
        User user = this.getAuthenticatedUser();
        if (sessionId == null) {
            newSessionId = this.sessionIdService.generateAuthenticatedSessionId(this.getHttpRequest(), user.getDn(), sessionIdAttributes);
        } else {
            String sessionAuthUser = sessionIdAttributes.get("auth_user");
            this.log.trace("configureSessionUser sessionId: '{}', sessionId.auth_user: '{}'", (Object)sessionId, (Object)sessionAuthUser);
            newSessionId = this.sessionIdService.setSessionIdStateAuthenticated(this.getHttpRequest(), sessionId, user.getDn());
        }
        this.identity.setSessionId(sessionId);
        return newSessionId;
    }

    public SessionId configureEventUser() {
        User user = this.getAuthenticatedUser();
        if (user == null) {
            return null;
        }
        this.log.debug("ConfigureEventUser: username: '{}', credentials: '{}'", (Object)user.getUserId(), (Object)System.identityHashCode(this.credentials));
        SessionId sessionId = this.sessionIdService.generateAuthenticatedSessionId(this.getHttpRequest(), user.getDn());
        this.identity.setSessionId(sessionId);
        return sessionId;
    }

    private HttpServletRequest getHttpRequest() {
        if (this.externalContext == null) {
            return null;
        }
        return (HttpServletRequest)this.externalContext.getRequest();
    }

    public void configureEventUser(SessionId sessionId) {
        this.sessionIdService.updateSessionId(sessionId);
        this.identity.setSessionId(sessionId);
    }

    public void quietLogin(String userName) {
        SimplePrincipal principal = new SimplePrincipal(userName);
        this.identity.acceptExternallyAuthenticatedPrincipal((Principal)principal);
        this.identity.quietLogin();
    }

    private void configureAuthenticatedUser(User user) {
        this.identity.setUser(user);
    }

    public User getAuthenticatedUser() {
        Map<String, String> sessionIdAttributes;
        String userId;
        if (this.identity.getUser() != null) {
            return this.identity.getUser();
        }
        SessionId sessionId = this.sessionIdService.getSessionId();
        if (sessionId != null && StringHelper.isNotEmpty((String)(userId = (sessionIdAttributes = sessionId.getSessionAttributes()).get("auth_user")))) {
            User user = this.userService.getUser(userId, new String[0]);
            this.identity.setUser(user);
            return user;
        }
        return null;
    }

    public String getAuthenticatedUserId() {
        User authenticatedUser = this.getAuthenticatedUser();
        if (authenticatedUser != null) {
            return authenticatedUser.getUserId();
        }
        return null;
    }

    public Client configureSessionClient() {
        String clientInum = this.credentials.getUsername();
        this.log.debug("ConfigureSessionClient: username: '{}', credentials: '{}'", (Object)clientInum, (Object)System.identityHashCode(this.credentials));
        Client client = this.clientService.getClient(clientInum);
        this.configureSessionClient(client);
        return client;
    }

    public void configureSessionClient(Client client) {
        SessionClient sessionClient = new SessionClient();
        sessionClient.setClient(client);
        this.identity.setSessionClient(sessionClient);
        this.clientService.updatAccessTime(client, true);
    }

    public void onSuccessfulLogin(SessionId sessionUser) {
        this.log.info("Attempting to redirect user: SessionUser: {}", (Object)sessionUser);
        if (sessionUser == null || StringUtils.isBlank((String)sessionUser.getUserDn())) {
            return;
        }
        User user = this.userService.getUserByDn(sessionUser.getUserDn(), new String[0]);
        this.log.info("Attempting to redirect user: User: {}", (Object)user);
        if (user != null) {
            Map<String, String> result = sessionUser.getSessionAttributes();
            Map<String, String> allowedParameters = this.requestParameterService.getAllowedParameters(result);
            result.put("session_id", sessionUser.getId());
            this.log.trace("Logged in successfully! User: {}, page: /authorize.xhtml, map: {}", (Object)user, allowedParameters);
            this.facesService.redirect("/authorize.xhtml", allowedParameters);
        }
    }

    public User getUserOrRemoveSession(SessionId p_sessionId) {
        if (p_sessionId != null) {
            try {
                if (StringUtils.isNotBlank((String)p_sessionId.getUserDn())) {
                    User user = this.userService.getUserByDn(p_sessionId.getUserDn(), new String[0]);
                    if (user != null) {
                        return user;
                    }
                    this.sessionIdService.remove(p_sessionId);
                } else {
                    this.sessionIdService.remove(p_sessionId);
                }
            }
            catch (Exception e) {
                this.log.trace(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public String parametersAsString() throws UnsupportedEncodingException {
        Map<String, String> parameterMap = this.getParametersMap(null);
        return this.requestParameterService.parametersAsString(parameterMap);
    }

    public Map<String, String> getParametersMap(List<String> extraParameters) {
        HashMap<String, String> parameterMap = new HashMap<String, String>(this.externalContext.getRequestParameterMap());
        return this.requestParameterService.getParametersMap(extraParameters, parameterMap);
    }

    public boolean isParameterExists(String p_name) {
        return this.identity.isSetWorkingParameter(p_name);
    }
}

