/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.xdi.model.GluuAttribute;
import org.xdi.oxauth.model.config.StaticConfiguration;
import org.xdi.service.CacheService;
import org.xdi.util.StringHelper;

@Stateless
@Named
public class AttributeService
extends org.xdi.service.AttributeService {
    private static final String CACHE_ATTRIBUTE = "AttributeCache";
    @Inject
    private Logger log;
    @Inject
    private CacheService cacheService;
    @Inject
    private StaticConfiguration staticConfiguration;

    public GluuAttribute getAttributeByDn(String dn) {
        GluuAttribute gluuAttribute = (GluuAttribute)this.cacheService.get(CACHE_ATTRIBUTE, dn);
        if (gluuAttribute == null) {
            gluuAttribute = (GluuAttribute)this.ldapEntryManager.find(GluuAttribute.class, (Object)dn);
            this.cacheService.put(CACHE_ATTRIBUTE, dn, (Object)gluuAttribute, true);
        } else {
            this.log.trace("Get attribute from cache by Dn '{}'", (Object)dn);
        }
        return gluuAttribute;
    }

    public GluuAttribute getByLdapName(String name) {
        List gluuAttributes = this.getAttributesByAttribute("gluuAttributeName", name, this.staticConfiguration.getBaseDn().getAttributes());
        if (gluuAttributes.size() > 0) {
            for (GluuAttribute gluuAttribute : gluuAttributes) {
                if (gluuAttribute.getName() == null || !gluuAttribute.getName().equals(name)) continue;
                return gluuAttribute;
            }
        }
        return null;
    }

    public GluuAttribute getByClaimName(String name) {
        List gluuAttributes = this.getAttributesByAttribute("oxAuthClaimName", name, this.staticConfiguration.getBaseDn().getAttributes());
        if (gluuAttributes.size() > 0) {
            for (GluuAttribute gluuAttribute : gluuAttributes) {
                if (gluuAttribute.getOxAuthClaimName() == null || !gluuAttribute.getOxAuthClaimName().equals(name)) continue;
                return gluuAttribute;
            }
        }
        return null;
    }

    public List<GluuAttribute> getAllAttributes() {
        return this.getAllAttributes(this.staticConfiguration.getBaseDn().getAttributes());
    }

    public String getDnForAttribute(String inum) {
        String attributesDn = this.staticConfiguration.getBaseDn().getAttributes();
        if (StringHelper.isEmpty((String)inum)) {
            return attributesDn;
        }
        return String.format("inum=%s,%s", inum, attributesDn);
    }

    public List<String> getAttributesDn(List<String> claimNames) {
        ArrayList<String> claims = new ArrayList<String>();
        for (String claimName : claimNames) {
            GluuAttribute gluuAttribute = this.getByClaimName(claimName);
            if (gluuAttribute == null) continue;
            claims.add(gluuAttribute.getDn());
        }
        return claims;
    }
}

