/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.xdi.model.SmtpConfiguration;
import org.xdi.oxauth.crypto.signature.SHA256withECDSASignatureVerification;
import org.xdi.oxauth.model.appliance.GluuAppliance;
import org.xdi.oxauth.model.config.StaticConfiguration;
import org.xdi.oxauth.service.ApplianceService;
import org.xdi.service.cache.CacheConfiguration;
import org.xdi.service.cache.InMemoryConfiguration;

@ApplicationScoped
@Named
public class ApplicationFactory {
    @Inject
    private Logger log;
    @Inject
    private ApplianceService applianceService;
    @Inject
    private StaticConfiguration staticConfiguration;

    @Produces
    @ApplicationScoped
    @Named(value="sha256withECDSASignatureVerification")
    public SHA256withECDSASignatureVerification getBouncyCastleSignatureVerification() {
        return new SHA256withECDSASignatureVerification();
    }

    @Produces
    @ApplicationScoped
    public CacheConfiguration getCacheConfiguration() {
        CacheConfiguration cacheConfiguration = this.applianceService.getAppliance().getCacheConfiguration();
        if (cacheConfiguration == null || cacheConfiguration.getCacheProviderType() == null) {
            this.log.error("Failed to read cache configuration from LDAP. Please check appliance oxCacheConfiguration attribute that must contain cache configuration JSON represented by CacheConfiguration.class. Applieance DN: " + this.applianceService.getAppliance().getDn());
            this.log.info("Creating fallback IN-MEMORY cache configuration ... ");
            cacheConfiguration = new CacheConfiguration();
            cacheConfiguration.setInMemoryConfiguration(new InMemoryConfiguration());
            this.log.info("IN-MEMORY cache configuration is created.");
        } else if (cacheConfiguration.getNativePersistenceConfiguration() != null) {
            cacheConfiguration.getNativePersistenceConfiguration().setBaseDn(StringUtils.remove((String)this.staticConfiguration.getBaseDn().getUmaBase(), (String)"ou=uma,").trim());
        }
        this.log.info("Cache configuration: " + cacheConfiguration);
        return cacheConfiguration;
    }

    @Produces
    @RequestScoped
    public SmtpConfiguration getSmtpConfiguration() {
        GluuAppliance appliance = this.applianceService.getAppliance();
        SmtpConfiguration smtpConfiguration = appliance.getSmtpConfiguration();
        if (smtpConfiguration == null) {
            return new SmtpConfiguration();
        }
        this.applianceService.decryptSmtpPassword(smtpConfiguration);
        return smtpConfiguration;
    }
}

