/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.slf4j.Logger;
import org.xdi.model.SmtpConfiguration;
import org.xdi.oxauth.model.appliance.GluuAppliance;
import org.xdi.oxauth.model.config.StaticConfiguration;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.service.EncryptionService;
import org.xdi.util.StringHelper;
import org.xdi.util.security.StringEncrypter;

@Stateless
@Named
public class ApplianceService {
    @Inject
    private Logger log;
    @Inject
    private LdapEntryManager ldapEntryManager;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private EncryptionService encryptionService;

    public void addAppliance(GluuAppliance appliance) {
        this.ldapEntryManager.persist((Object)appliance);
    }

    public void updateAppliance(GluuAppliance appliance) {
        this.ldapEntryManager.merge((Object)appliance);
    }

    public boolean containsAppliance(GluuAppliance appliance) {
        return this.ldapEntryManager.contains((Object)appliance);
    }

    public GluuAppliance getApplianceByInum(String inum) {
        return (GluuAppliance)this.ldapEntryManager.find(GluuAppliance.class, (Object)this.getDnForAppliance(inum));
    }

    public GluuAppliance getAppliance() {
        String applianceInum = this.getApplianceInum();
        if (StringHelper.isEmpty((String)applianceInum)) {
            return null;
        }
        return (GluuAppliance)this.ldapEntryManager.find(GluuAppliance.class, (Object)this.getDnForAppliance(this.getApplianceInum()));
    }

    public List<GluuAppliance> getAppliances() {
        List applianceList = this.ldapEntryManager.findEntries(this.getDnForAppliance(null), GluuAppliance.class, null);
        return applianceList;
    }

    public String getDnForAppliance(String inum) {
        String baseDn = this.staticConfiguration.getBaseDn().getAppliance();
        if (StringHelper.isEmpty((String)inum)) {
            return baseDn;
        }
        return String.format("inum=%s,%s", inum, baseDn);
    }

    public String getDnForAppliance() {
        return this.getDnForAppliance(this.getApplianceInum());
    }

    public String getApplianceInum() {
        return this.appConfiguration.getApplianceInum();
    }

    public void decryptSmtpPassword(SmtpConfiguration smtpConfiguration) {
        if (smtpConfiguration == null) {
            return;
        }
        String password = smtpConfiguration.getPassword();
        if (StringHelper.isNotEmpty((String)password)) {
            try {
                smtpConfiguration.setPasswordDecrypted(this.encryptionService.decrypt(password));
            }
            catch (StringEncrypter.EncryptionException ex) {
                this.log.error("Failed to decrypt SMTP user password", (Throwable)ex);
            }
        }
    }
}

