/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.unboundid.ldap.sdk.ResultCode;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletContext;
import org.codehaus.jackson.map.ObjectMapper;
import org.gluu.site.ldap.LDAPConnectionProvider;
import org.gluu.site.ldap.OperationsFacade;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.gluu.site.ldap.persistence.exception.LdapMappingException;
import org.jboss.weld.util.reflection.ParameterizedTypeImpl;
import org.slf4j.Logger;
import org.xdi.exception.ConfigurationException;
import org.xdi.model.SimpleProperty;
import org.xdi.model.custom.script.CustomScriptType;
import org.xdi.model.ldap.GluuLdapConfiguration;
import org.xdi.oxauth.model.appliance.GluuAppliance;
import org.xdi.oxauth.model.auth.AuthenticationMode;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.config.oxIDPAuthConf;
import org.xdi.oxauth.model.event.ApplicationInitializedEvent;
import org.xdi.oxauth.model.util.SecurityProviderUtility;
import org.xdi.oxauth.service.ApplianceService;
import org.xdi.oxauth.service.CleanerTimer;
import org.xdi.oxauth.service.EncryptionService;
import org.xdi.oxauth.service.KeyGeneratorTimer;
import org.xdi.oxauth.service.MetricService;
import org.xdi.oxauth.service.cdi.event.AuthConfigurationEvent;
import org.xdi.oxauth.service.cdi.event.ReloadAuthScript;
import org.xdi.oxauth.service.logger.LoggerService;
import org.xdi.oxauth.service.status.ldap.LdapStatusTimer;
import org.xdi.service.PythonService;
import org.xdi.service.cdi.async.Asynchronous;
import org.xdi.service.cdi.event.ApplicationInitialized;
import org.xdi.service.cdi.event.LdapConfigurationReload;
import org.xdi.service.cdi.event.Scheduled;
import org.xdi.service.cdi.util.CdiUtil;
import org.xdi.service.custom.lib.CustomLibrariesLoader;
import org.xdi.service.custom.script.CustomScriptManager;
import org.xdi.service.ldap.LdapConnectionProviders;
import org.xdi.service.ldap.LdapConnectionService;
import org.xdi.service.metric.inject.ReportMetric;
import org.xdi.service.timer.QuartzSchedulerManager;
import org.xdi.service.timer.event.TimerEvent;
import org.xdi.service.timer.schedule.TimerSchedule;
import org.xdi.util.StringHelper;
import org.xdi.util.properties.FileConfiguration;
import org.xdi.util.security.StringEncrypter;

@ApplicationScoped
@Named
public class AppInitializer {
    private static final String EVENT_TYPE = "AppInitializerTimerEvent";
    private static final int DEFAULT_INTERVAL = 30;
    public static final String LDAP_AUTH_CONFIG_NAME = "ldapAuthConfig";
    public static final String LDAP_METRIC_CONFIG_GROUP_NAME = "metric";
    public static final String LDAP_ENTRY_MANAGER_NAME = "ldapEntryManager";
    public static final String LDAP_METRIC_ENTRY_MANAGER_NAME = "ldapMetricEntryManager";
    public static final String LDAP_AUTH_ENTRY_MANAGER_NAME = "ldapAuthEntryManager";
    @Inject
    private Logger log;
    @Inject
    private BeanManager beanManager;
    @Inject
    private Event<String> event;
    @Inject
    private Event<ApplicationInitializedEvent> eventApplicationInitialized;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    @Named(value="ldapEntryManager")
    private Instance<LdapEntryManager> ldapEntryManagerInstance;
    @Inject
    @Named(value="ldapMetricEntryManager")
    @ReportMetric
    private Instance<LdapEntryManager> ldapMetricEntryManagerInstance;
    @Inject
    @Named(value="ldapAuthEntryManager")
    private Instance<List<LdapEntryManager>> ldapAuthEntryManagerInstance;
    @Inject
    @Named(value="ldapAuthConfig")
    private Instance<List<GluuLdapConfiguration>> ldapAuthConfigInstance;
    @Inject
    private Instance<AuthenticationMode> authenticationModeInstance;
    @Inject
    private Instance<EncryptionService> encryptionServiceInstance;
    @Inject
    private ApplianceService applianceService;
    @Inject
    private PythonService pythonService;
    @Inject
    private MetricService metricService;
    @Inject
    private CustomScriptManager customScriptManager;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private CleanerTimer cleanerTimer;
    @Inject
    private KeyGeneratorTimer keyGeneratorTimer;
    @Inject
    private CustomLibrariesLoader customLibrariesLoader;
    @Inject
    private LdapStatusTimer ldapStatusTimer;
    @Inject
    private QuartzSchedulerManager quartzSchedulerManager;
    @Inject
    private LoggerService loggerService;
    private List<GluuLdapConfiguration> ldapAuthConfigs;
    private LdapConnectionProviders connectionProviders;
    private LdapConnectionProviders metricConnectionProviders;
    private List<LdapConnectionService> authConnectionProviders;
    private List<LdapConnectionService> authBindConnectionProviders;
    private AtomicBoolean isActive;
    private long lastFinishedTime;
    private AuthenticationMode authenticationMode;

    @PostConstruct
    public void createApplicationComponents() {
        SecurityProviderUtility.installBCProvider();
    }

    public void applicationInitialized(@Observes @Initialized(value=ApplicationScoped.class) Object init) {
        this.customLibrariesLoader.init();
        this.connectionProviders = this.createConnectionProvider(null, true);
        this.metricConnectionProviders = this.createConnectionProvider(LDAP_METRIC_CONFIG_GROUP_NAME, false);
        this.configurationFactory.create();
        LdapEntryManager localLdapEntryManager = (LdapEntryManager)this.ldapEntryManagerInstance.get();
        List<GluuLdapConfiguration> ldapAuthConfigs = this.loadLdapAuthConfigs(localLdapEntryManager);
        this.createAuthConnectionProviders(ldapAuthConfigs);
        this.setDefaultAuthenticationMethod(localLdapEntryManager);
        this.pythonService.initPythonInterpreter(this.configurationFactory.getLdapConfiguration().getString("pythonModulesDir", null));
        List<CustomScriptType> supportedCustomScriptTypes = Arrays.asList(CustomScriptType.PERSON_AUTHENTICATION, CustomScriptType.CONSENT_GATHERING, CustomScriptType.CLIENT_REGISTRATION, CustomScriptType.ID_GENERATOR, CustomScriptType.UMA_RPT_POLICY, CustomScriptType.UMA_CLAIMS_GATHERING, CustomScriptType.APPLICATION_SESSION, CustomScriptType.DYNAMIC_SCOPE, CustomScriptType.INTROSPECTION, CustomScriptType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        this.initSchedulerService();
        this.metricService.initTimer();
        this.configurationFactory.initTimer();
        this.loggerService.initTimer();
        this.ldapStatusTimer.initTimer();
        this.cleanerTimer.initTimer();
        this.customScriptManager.initTimer(supportedCustomScriptTypes);
        this.keyGeneratorTimer.initTimer();
        this.initTimer();
        this.eventApplicationInitialized.select(new Annotation[]{ApplicationInitialized.Literal.APPLICATION}).fire((Object)new ApplicationInitializedEvent());
    }

    protected void initSchedulerService() {
        this.quartzSchedulerManager.start();
        String disableScheduler = System.getProperties().getProperty("gluu.disable.scheduler");
        if (disableScheduler != null && Boolean.valueOf(disableScheduler).booleanValue()) {
            this.log.warn("Suspending Quartz Scheduler Service...");
            this.quartzSchedulerManager.standby();
            return;
        }
    }

    @Produces
    @ApplicationScoped
    public StringEncrypter getStringEncrypter() {
        String encodeSalt = this.configurationFactory.getCryptoConfigurationSalt();
        if (StringHelper.isEmpty((String)encodeSalt)) {
            throw new ConfigurationException("Encode salt isn't defined");
        }
        try {
            StringEncrypter stringEncrypter = StringEncrypter.instance((String)encodeSalt);
            return stringEncrypter;
        }
        catch (StringEncrypter.EncryptionException ex) {
            throw new ConfigurationException("Failed to create StringEncrypter instance");
        }
    }

    public void initTimer() {
        this.isActive = new AtomicBoolean(false);
        this.lastFinishedTime = System.currentTimeMillis();
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(60, 30), (Object)new AuthConfigurationEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
    }

    public void destroy(@Observes @BeforeDestroyed(value=ApplicationScoped.class) ServletContext init) {
        this.log.info("Closing LDAP connection at server shutdown...");
        LdapEntryManager ldapEntryManager = (LdapEntryManager)this.ldapEntryManagerInstance.get();
        this.closeLdapEntryManager(ldapEntryManager, LDAP_ENTRY_MANAGER_NAME);
        LdapEntryManager ldapMetricEntryManager = (LdapEntryManager)this.ldapMetricEntryManagerInstance.get();
        this.closeLdapEntryManager(ldapMetricEntryManager, LDAP_METRIC_ENTRY_MANAGER_NAME);
        List ldapAuthEntryManagers = (List)this.ldapAuthEntryManagerInstance.get();
        this.closeLdapAuthEntryManagers(ldapAuthEntryManagers);
    }

    @Asynchronous
    public void reloadConfigurationTimerEvent(@Observes @Scheduled AuthConfigurationEvent authConfigurationEvent) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.reloadConfiguration();
        }
        catch (Throwable ex) {
            this.log.error("Exception happened while reloading application configuration", ex);
        }
        finally {
            this.isActive.set(false);
            this.lastFinishedTime = System.currentTimeMillis();
        }
    }

    private void reloadConfiguration() {
        LdapEntryManager localLdapEntryManager = (LdapEntryManager)this.ldapEntryManagerInstance.get();
        this.log.trace("Attempting to use {}: {}", (Object)LDAP_ENTRY_MANAGER_NAME, (Object)localLdapEntryManager.getLdapOperationService());
        List<GluuLdapConfiguration> newLdapAuthConfigs = this.loadLdapAuthConfigs(localLdapEntryManager);
        if (!this.ldapAuthConfigs.equals(newLdapAuthConfigs)) {
            this.recreateLdapAuthEntryManagers(newLdapAuthConfigs);
            this.event.select(new Annotation[]{ReloadAuthScript.Literal.INSTANCE}).fire((Object)"CustomScriptModifiedInternlTypesEvent");
        }
        this.setDefaultAuthenticationMethod(localLdapEntryManager);
    }

    public LdapEntryManager createLdapAuthEntryManager(GluuLdapConfiguration ldapAuthConfig) {
        LdapConnectionProviders ldapConnectionProviders = this.createAuthConnectionProviders(ldapAuthConfig);
        LdapEntryManager ldapAuthEntryManager = new LdapEntryManager(new OperationsFacade((LDAPConnectionProvider)ldapConnectionProviders.getConnectionProvider(), (LDAPConnectionProvider)ldapConnectionProviders.getConnectionBindProvider()));
        this.log.debug("Created custom authentication LdapEntryManager: {}", (Object)ldapAuthEntryManager);
        return ldapAuthEntryManager;
    }

    @Produces
    @ApplicationScoped
    @Named(value="ldapAuthConfig")
    public List<GluuLdapConfiguration> createLdapAuthConfigs() {
        return this.ldapAuthConfigs;
    }

    @Produces
    @ApplicationScoped
    @Named(value="ldapAuthEntryManager")
    public List<LdapEntryManager> createLdapAuthEntryManager() {
        ArrayList<LdapEntryManager> ldapAuthEntryManagers = new ArrayList<LdapEntryManager>();
        if (this.ldapAuthConfigs.size() == 0) {
            return ldapAuthEntryManagers;
        }
        for (int i = 0; i < this.ldapAuthConfigs.size(); ++i) {
            LdapEntryManager ldapAuthEntryManager = new LdapEntryManager(new OperationsFacade((LDAPConnectionProvider)this.authConnectionProviders.get(i), (LDAPConnectionProvider)this.authBindConnectionProviders.get(i)));
            this.log.debug("Created {}#{}: {}", new Object[]{LDAP_AUTH_ENTRY_MANAGER_NAME, i, ldapAuthEntryManager});
            ldapAuthEntryManagers.add(ldapAuthEntryManager);
        }
        return ldapAuthEntryManagers;
    }

    @Produces
    @Named(value="ldapEntryManager")
    @ApplicationScoped
    public LdapEntryManager createLdapEntryManager() {
        LdapEntryManager ldapEntryManager = new LdapEntryManager(new OperationsFacade((LDAPConnectionProvider)this.connectionProviders.getConnectionProvider(), (LDAPConnectionProvider)this.connectionProviders.getConnectionBindProvider()));
        this.log.info("Created {}:{} with provider {}", new Object[]{LDAP_ENTRY_MANAGER_NAME, ldapEntryManager, ldapEntryManager.getLdapOperationService().getConnectionProvider()});
        return ldapEntryManager;
    }

    @Produces
    @Named(value="ldapMetricEntryManager")
    @ReportMetric
    @ApplicationScoped
    public LdapEntryManager createLdapMetricEntryManager() {
        LdapEntryManager ldapMetricEntryManager = new LdapEntryManager(new OperationsFacade((LDAPConnectionProvider)this.metricConnectionProviders.getConnectionProvider()));
        this.log.info("Created {}:{} with provider {}", new Object[]{LDAP_METRIC_ENTRY_MANAGER_NAME, ldapMetricEntryManager, ldapMetricEntryManager.getLdapOperationService().getConnectionProvider()});
        return ldapMetricEntryManager;
    }

    public void recreateLdapEntryManager(@Observes @LdapConfigurationReload String event) {
        this.connectionProviders = this.recreateLdapEntryManagerImpl(LDAP_ENTRY_MANAGER_NAME, null, true, new Annotation[0]);
        this.forceCreateNewEntryManager(this.ldapEntryManagerInstance, LDAP_ENTRY_MANAGER_NAME);
        this.metricConnectionProviders = this.recreateLdapEntryManagerImpl(LDAP_METRIC_ENTRY_MANAGER_NAME, LDAP_METRIC_CONFIG_GROUP_NAME, false, new Annotation[]{ReportMetric.Literal.INSTANCE});
        this.forceCreateNewEntryManager(this.ldapMetricEntryManagerInstance, LDAP_METRIC_ENTRY_MANAGER_NAME);
    }

    protected <T> LdapConnectionProviders recreateLdapEntryManagerImpl(String entryManagerName, String configId, boolean createBind, Annotation ... qualifiers) {
        LdapEntryManager oldLdapEntryManager = (LdapEntryManager)CdiUtil.getContextBean((BeanManager)this.beanManager, LdapEntryManager.class, (String)entryManagerName, (Annotation[])qualifiers);
        LdapConnectionProviders createConnectionProviders = this.createConnectionProvider(configId, createBind);
        this.closeLdapEntryManager(oldLdapEntryManager, entryManagerName);
        return createConnectionProviders;
    }

    protected <T> void forceCreateNewEntryManager(Instance<T> instance, String entryManagerName) {
        Object ldapEntryManager = instance.get();
        instance.destroy(ldapEntryManager);
        this.log.info("Recreated instance {}: {}", (Object)entryManagerName, ldapEntryManager);
    }

    private LdapConnectionProviders createConnectionProvider(String configId, boolean createBind) {
        Properties connectionProperties = this.getLdapConfigProperties(configId);
        String logConfigId = StringHelper.isEmpty((String)configId) ? "" : configId + "-";
        LdapConnectionService connectionProvider = this.createConnectionProvider(connectionProperties);
        if (!ResultCode.SUCCESS.equals((Object)connectionProvider.getCreationResultCode())) {
            throw new ConfigurationException("Failed to create LDAP connection pool!");
        }
        this.log.debug("Created {}connectionProvider: {}", (Object)logConfigId, (Object)connectionProvider);
        LdapConnectionService bindConnectionProvider = null;
        if (createBind) {
            Properties bindConnectionProperties = this.prepareBindConnectionProperties(connectionProperties);
            bindConnectionProvider = this.createBindConnectionProvider(bindConnectionProperties, connectionProperties);
            if (!ResultCode.SUCCESS.equals((Object)bindConnectionProvider.getCreationResultCode())) {
                throw new ConfigurationException("Failed to create LDAP connection pool!");
            }
            this.log.debug("Created {}bindConnectionProvider: {}", (Object)logConfigId, (Object)bindConnectionProvider);
        }
        return new LdapConnectionProviders(connectionProvider, bindConnectionProvider);
    }

    protected Properties getLdapConfigProperties(String configId) {
        Properties connectionProperties = this.configurationFactory.getLdapConfiguration().getProperties();
        if (StringHelper.isNotEmpty((String)configId)) {
            connectionProperties = (Properties)connectionProperties.clone();
            String baseGroup = configId + ".";
            for (Object key : connectionProperties.keySet()) {
                String propertyName = (String)key;
                if (!propertyName.startsWith(baseGroup)) continue;
                propertyName = propertyName.substring(baseGroup.length());
                Object value = connectionProperties.get(key);
                connectionProperties.put(propertyName, value);
            }
        }
        return connectionProperties;
    }

    private void closeLdapEntryManager(LdapEntryManager oldLdapEntryManager, String entryManagerName) {
        if (oldLdapEntryManager != null && oldLdapEntryManager.getLdapOperationService() != null) {
            this.log.debug("Attempting to destroy {}:{} with provider {}", new Object[]{entryManagerName, oldLdapEntryManager, oldLdapEntryManager.getLdapOperationService().getConnectionProvider()});
            oldLdapEntryManager.destroy();
            this.log.debug("Destroyed {}:{} with provider {}", new Object[]{entryManagerName, oldLdapEntryManager, oldLdapEntryManager.getLdapOperationService().getConnectionProvider()});
        }
    }

    public void recreateLdapAuthEntryManagers(List<GluuLdapConfiguration> newLdapAuthConfigs) {
        List oldLdapAuthEntryManagers = (List)CdiUtil.getContextBean((BeanManager)this.beanManager, (Type)new ParameterizedTypeImpl(List.class, new Type[]{LdapEntryManager.class}), (String)LDAP_AUTH_ENTRY_MANAGER_NAME, (Annotation[])new Annotation[0]);
        this.createAuthConnectionProviders(newLdapAuthConfigs);
        this.closeLdapAuthEntryManagers(oldLdapAuthEntryManagers);
        for (LdapEntryManager oldLdapAuthEntryManager : oldLdapAuthEntryManagers) {
            this.log.debug("Attempting to destroy {}: {}", (Object)LDAP_AUTH_ENTRY_MANAGER_NAME, (Object)oldLdapAuthEntryManager);
            oldLdapAuthEntryManager.destroy();
            this.log.debug("Destroyed {}: {}", (Object)LDAP_AUTH_ENTRY_MANAGER_NAME, (Object)oldLdapAuthEntryManager);
        }
        List ldapAuthEntryManagers = (List)this.ldapAuthEntryManagerInstance.get();
        this.ldapAuthEntryManagerInstance.destroy((Object)ldapAuthEntryManagers);
        this.log.info("Recreated instance {}: {}", (Object)LDAP_AUTH_ENTRY_MANAGER_NAME, (Object)ldapAuthEntryManagers);
    }

    private void createAuthConnectionProviders(List<GluuLdapConfiguration> newLdapAuthConfigs) {
        List oldLdapAuthConfigs = (List)this.ldapAuthConfigInstance.get();
        ArrayList<LdapConnectionService> tmpAuthConnectionProviders = new ArrayList<LdapConnectionService>();
        ArrayList<LdapConnectionService> tmpAuthBindConnectionProviders = new ArrayList<LdapConnectionService>();
        for (GluuLdapConfiguration ldapAuthConfig : newLdapAuthConfigs) {
            LdapConnectionProviders ldapConnectionProviders = this.createAuthConnectionProviders(ldapAuthConfig);
            tmpAuthConnectionProviders.add(ldapConnectionProviders.getConnectionProvider());
            tmpAuthBindConnectionProviders.add(ldapConnectionProviders.getConnectionBindProvider());
        }
        this.ldapAuthConfigs = newLdapAuthConfigs;
        this.authConnectionProviders = tmpAuthConnectionProviders;
        this.authBindConnectionProviders = tmpAuthBindConnectionProviders;
        this.ldapAuthConfigInstance.destroy((Object)oldLdapAuthConfigs);
    }

    private void closeLdapAuthEntryManagers(List<LdapEntryManager> oldLdapAuthEntryManagers) {
        for (LdapEntryManager oldLdapAuthEntryManager : oldLdapAuthEntryManagers) {
            this.log.debug("Attempting to destroy {}: {}", (Object)LDAP_AUTH_ENTRY_MANAGER_NAME, (Object)oldLdapAuthEntryManager);
            oldLdapAuthEntryManager.destroy();
            this.log.debug("Destroyed {}: {}", (Object)LDAP_AUTH_ENTRY_MANAGER_NAME, (Object)oldLdapAuthEntryManager);
        }
    }

    public LdapConnectionProviders createAuthConnectionProviders(GluuLdapConfiguration ldapAuthConfig) {
        Properties connectionProperties = this.prepareAuthConnectionProperties(ldapAuthConfig);
        LdapConnectionService connectionProvider = this.createConnectionProvider(connectionProperties);
        Properties bindConnectionProperties = this.prepareBindConnectionProperties(connectionProperties);
        LdapConnectionService bindConnectionProvider = this.createBindConnectionProvider(bindConnectionProperties, connectionProperties);
        return new LdapConnectionProviders(connectionProvider, bindConnectionProvider);
    }

    private Properties prepareAuthConnectionProperties(GluuLdapConfiguration ldapAuthConfig) {
        FileConfiguration configuration = this.configurationFactory.getLdapConfiguration();
        Properties properties = (Properties)configuration.getProperties().clone();
        if (ldapAuthConfig != null) {
            properties.setProperty("servers", this.buildServersString(ldapAuthConfig.getServers()));
            String bindDn = ldapAuthConfig.getBindDN();
            if (StringHelper.isNotEmpty((String)bindDn)) {
                properties.setProperty("bindDN", bindDn);
                properties.setProperty("bindPassword", ldapAuthConfig.getBindPassword());
            }
            properties.setProperty("useSSL", Boolean.toString(ldapAuthConfig.isUseSSL()));
            properties.setProperty("maxconnections", Integer.toString(ldapAuthConfig.getMaxConnections()));
        }
        return properties;
    }

    private Properties prepareBindConnectionProperties(Properties connectionProperties) {
        Properties bindProperties = (Properties)connectionProperties.clone();
        bindProperties.remove("bindDN");
        bindProperties.remove("bindPassword");
        return bindProperties;
    }

    private LdapConnectionService createConnectionProvider(Properties connectionProperties) {
        EncryptionService securityService = (EncryptionService)this.encryptionServiceInstance.get();
        LdapConnectionService connectionProvider = new LdapConnectionService(securityService.decryptProperties(connectionProperties));
        return connectionProvider;
    }

    private LdapConnectionService createBindConnectionProvider(Properties bindConnectionProperties, Properties connectionProperties) {
        LdapConnectionService bindConnectionProvider = this.createConnectionProvider(bindConnectionProperties);
        if (ResultCode.INAPPROPRIATE_AUTHENTICATION.equals((Object)bindConnectionProvider.getCreationResultCode())) {
            this.log.warn("It's not possible to create authentication LDAP connection pool using anonymous bind. Attempting to create it using binDN/bindPassword");
            bindConnectionProvider = this.createConnectionProvider(connectionProperties);
        }
        return bindConnectionProvider;
    }

    private String buildServersString(List<?> servers) {
        StringBuilder sb = new StringBuilder();
        if (servers == null) {
            return sb.toString();
        }
        boolean first = true;
        for (Object server : servers) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            if (server instanceof SimpleProperty) {
                sb.append(((SimpleProperty)server).getValue());
                continue;
            }
            sb.append(server);
        }
        return sb.toString();
    }

    private List<oxIDPAuthConf> loadLdapIdpAuthConfigs(LdapEntryManager localLdapEntryManager) {
        GluuAppliance appliance = this.loadAppliance(localLdapEntryManager, "oxIDPAuthentication");
        if (appliance == null || appliance.getOxIDPAuthentication() == null) {
            return null;
        }
        ArrayList<oxIDPAuthConf> configurations = new ArrayList<oxIDPAuthConf>();
        for (String configurationJson : appliance.getOxIDPAuthentication()) {
            try {
                oxIDPAuthConf configuration = (oxIDPAuthConf)this.jsonToObject(configurationJson, oxIDPAuthConf.class);
                if (!configuration.getType().equalsIgnoreCase("ldap") && !configuration.getType().equalsIgnoreCase("auth")) continue;
                configurations.add(configuration);
            }
            catch (Exception ex) {
                this.log.error("Failed to create object by json: '{}'", (Object)configurationJson, (Object)ex);
            }
        }
        return configurations;
    }

    private void setDefaultAuthenticationMethod(LdapEntryManager localLdapEntryManager) {
        String actualAuthMethod;
        String currentAuthMethod = null;
        if (this.authenticationMode != null) {
            currentAuthMethod = this.authenticationMode.getName();
        }
        if (!StringHelper.equals((String)currentAuthMethod, (String)(actualAuthMethod = this.getActualDefaultAuthenticationMethod(localLdapEntryManager)))) {
            this.authenticationMode = null;
            if (actualAuthMethod != null) {
                this.authenticationMode = new AuthenticationMode(actualAuthMethod);
            }
            this.authenticationModeInstance.destroy(this.authenticationModeInstance.get());
        }
    }

    private String getActualDefaultAuthenticationMethod(LdapEntryManager localLdapEntryManager) {
        GluuAppliance appliance = this.loadAppliance(localLdapEntryManager, "oxAuthenticationMode");
        if (appliance == null) {
            return null;
        }
        return appliance.getAuthenticationMode();
    }

    @Produces
    @ApplicationScoped
    public AuthenticationMode getDefaultAuthenticationMode() {
        return this.authenticationMode;
    }

    private GluuAppliance loadAppliance(LdapEntryManager localLdapEntryManager, String ... ldapReturnAttributes) {
        String baseDn = this.configurationFactory.getBaseDn().getAppliance();
        String applianceInum = this.configurationFactory.getAppConfiguration().getApplianceInum();
        if (StringHelper.isEmpty((String)baseDn) || StringHelper.isEmpty((String)applianceInum)) {
            return null;
        }
        String applianceDn = String.format("inum=%s,%s", applianceInum, baseDn);
        GluuAppliance appliance = null;
        try {
            appliance = (GluuAppliance)localLdapEntryManager.find(GluuAppliance.class, (Object)applianceDn, ldapReturnAttributes);
        }
        catch (LdapMappingException ex) {
            this.log.error("Failed to load appliance entry from Ldap", (Throwable)ex);
            return null;
        }
        return appliance;
    }

    public GluuLdapConfiguration loadLdapAuthConfig(oxIDPAuthConf configuration) {
        if (configuration == null) {
            return null;
        }
        try {
            if (configuration.getType().equalsIgnoreCase("auth")) {
                return this.mapLdapConfig(configuration.getConfig());
            }
        }
        catch (Exception ex) {
            this.log.error("Failed to create object by oxIDPAuthConf: '{}'", (Object)configuration, (Object)ex);
        }
        return null;
    }

    private List<GluuLdapConfiguration> loadLdapAuthConfigs(LdapEntryManager localLdapEntryManager) {
        ArrayList<GluuLdapConfiguration> ldapAuthConfigs = new ArrayList<GluuLdapConfiguration>();
        List<oxIDPAuthConf> ldapIdpAuthConfigs = this.loadLdapIdpAuthConfigs(localLdapEntryManager);
        if (ldapIdpAuthConfigs == null) {
            return ldapAuthConfigs;
        }
        for (oxIDPAuthConf ldapIdpAuthConfig : ldapIdpAuthConfigs) {
            GluuLdapConfiguration ldapAuthConfig = this.loadLdapAuthConfig(ldapIdpAuthConfig);
            if (ldapAuthConfig == null || !ldapAuthConfig.isEnabled()) continue;
            ldapAuthConfigs.add(ldapAuthConfig);
        }
        return ldapAuthConfigs;
    }

    private GluuLdapConfiguration mapLdapConfig(String config) throws Exception {
        return (GluuLdapConfiguration)this.jsonToObject(config, GluuLdapConfiguration.class);
    }

    private Object jsonToObject(String json, Class<?> clazz) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Object clazzObject = mapper.readValue(json, clazz);
        return clazzObject;
    }
}

