/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.register.ws.rs;

import com.codahale.metrics.Timer;
import com.google.common.base.Strings;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.xdi.ldap.model.CustomAttribute;
import org.xdi.model.GluuAttribute;
import org.xdi.model.metric.MetricType;
import org.xdi.oxauth.audit.ApplicationAuditLogger;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.model.audit.Action;
import org.xdi.oxauth.model.audit.OAuth2AuditLog;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.common.Scope;
import org.xdi.oxauth.model.common.SubjectType;
import org.xdi.oxauth.model.config.StaticConfiguration;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.crypto.AbstractCryptoProvider;
import org.xdi.oxauth.model.crypto.CryptoProviderFactory;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.register.RegisterErrorResponseType;
import org.xdi.oxauth.model.register.RegisterRequestParam;
import org.xdi.oxauth.model.register.RegisterResponseParam;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.registration.RegisterParamsValidator;
import org.xdi.oxauth.model.token.HandleTokenFactory;
import org.xdi.oxauth.model.util.JwtUtil;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.register.ws.rs.RegisterRestWebService;
import org.xdi.oxauth.service.AttributeService;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.InumService;
import org.xdi.oxauth.service.MetricService;
import org.xdi.oxauth.service.ScopeService;
import org.xdi.oxauth.service.external.ExternalDynamicClientRegistrationService;
import org.xdi.oxauth.service.token.TokenService;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.StringHelper;
import org.xdi.util.security.StringEncrypter;

@Path(value="/")
public class RegisterRestWebServiceImpl
implements RegisterRestWebService {
    @Inject
    private Logger log;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private ScopeService scopeService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private InumService inumService;
    @Inject
    private ClientService clientService;
    @Inject
    private TokenService tokenService;
    @Inject
    private MetricService metricService;
    @Inject
    private ExternalDynamicClientRegistrationService externalDynamicClientRegistrationService;
    @Inject
    private RegisterParamsValidator registerParamsValidator;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private StaticConfiguration staticConfiguration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response requestRegister(String requestParams, String authorization, HttpServletRequest httpRequest, SecurityContext securityContext) {
        Timer.Context timerContext = this.metricService.getTimer(MetricType.DYNAMIC_CLIENT_REGISTRATION_RATE).time();
        try {
            Response response = this.registerClientImpl(requestParams, httpRequest, securityContext);
            return response;
        }
        finally {
            timerContext.stop();
        }
    }

    private Response registerClientImpl(String requestParams, HttpServletRequest httpRequest, SecurityContext securityContext) {
        OAuth2AuditLog oAuth2AuditLog;
        Response.ResponseBuilder builder;
        block28: {
            builder = Response.ok();
            oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(httpRequest), Action.CLIENT_REGISTRATION);
            try {
                JSONObject requestObject = new JSONObject(requestParams);
                if (requestParams != null && requestObject.has(RegisterRequestParam.SOFTWARE_STATEMENT.toString())) {
                    Jwt softwareStatement = Jwt.parse((String)requestObject.getString(RegisterRequestParam.SOFTWARE_STATEMENT.toString()));
                    String keyId = softwareStatement.getHeader().getKeyId();
                    JSONObject jwks = Strings.isNullOrEmpty((String)softwareStatement.getClaims().getClaimAsString(RegisterRequestParam.JWKS_URI.toString())) ? new JSONObject(softwareStatement.getClaims().getClaimAsString(RegisterRequestParam.JWKS.toString())) : JwtUtil.getJSONWebKeys((String)softwareStatement.getClaims().getClaimAsString(RegisterRequestParam.JWKS_URI.toString()));
                    AbstractCryptoProvider cryptoProvider = CryptoProviderFactory.getCryptoProvider((AppConfiguration)this.appConfiguration);
                    boolean validSignature = cryptoProvider.verifySignature(softwareStatement.getSigningInput(), softwareStatement.getEncodedSignature(), keyId, jwks, null, softwareStatement.getHeader().getAlgorithm());
                    if (!validSignature) {
                        throw new InvalidJwtException("Invalid cryptographic segment in the software statement");
                    }
                    requestParams = softwareStatement.getClaims().toJsonObject().toString();
                }
                RegisterRequest r = RegisterRequest.fromJson((String)requestParams, (boolean)this.appConfiguration.getLegacyDynamicRegistrationScopeParam());
                if (requestObject.has(RegisterRequestParam.SOFTWARE_STATEMENT.toString())) {
                    r.setSoftwareStatement(requestObject.getString(RegisterRequestParam.SOFTWARE_STATEMENT.toString()));
                }
                this.log.info("Attempting to register client: applicationType = {}, clientName = {}, redirectUris = {}, isSecure = {}, sectorIdentifierUri = {}, defaultAcrValues = {}", new Object[]{r.getApplicationType(), r.getClientName(), r.getRedirectUris(), securityContext.isSecure(), r.getSectorIdentifierUri(), r.getDefaultAcrValues()});
                this.log.trace("Registration request = {}", (Object)requestParams);
                if (this.appConfiguration.getDynamicRegistrationEnabled().booleanValue()) {
                    if (r.getSubjectType() == null) {
                        SubjectType defaultSubjectType = SubjectType.fromString((String)this.appConfiguration.getDefaultSubjectType());
                        if (defaultSubjectType != null) {
                            r.setSubjectType(defaultSubjectType);
                        } else if (this.appConfiguration.getSubjectTypesSupported().contains(SubjectType.PUBLIC.toString())) {
                            r.setSubjectType(SubjectType.PUBLIC);
                        } else if (this.appConfiguration.getSubjectTypesSupported().contains(SubjectType.PAIRWISE.toString())) {
                            r.setSubjectType(SubjectType.PAIRWISE);
                        }
                    }
                    if (r.getIdTokenSignedResponseAlg() == null) {
                        r.setIdTokenSignedResponseAlg(SignatureAlgorithm.fromString((String)this.appConfiguration.getDefaultSignatureAlgorithm()));
                    }
                    if (r.getAccessTokenSigningAlg() == null) {
                        r.setAccessTokenSigningAlg(SignatureAlgorithm.fromString((String)this.appConfiguration.getDefaultSignatureAlgorithm()));
                    }
                    if (r.getClaimsRedirectUris() != null && !r.getClaimsRedirectUris().isEmpty() && !this.registerParamsValidator.validateRedirectUris(r.getApplicationType(), r.getSubjectType(), r.getClaimsRedirectUris(), r.getSectorIdentifierUri())) {
                        this.log.error("Value of one or more claims_redirect_uris is invalid, claims_redirect_uris: " + r.getClaimsRedirectUris());
                        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_CLAIMS_REDIRECT_URI)).build());
                    }
                    if (this.registerParamsValidator.validateParamsClientRegister(r.getApplicationType(), r.getSubjectType(), r.getRedirectUris(), r.getSectorIdentifierUri())) {
                        if (!this.registerParamsValidator.validateRedirectUris(r.getApplicationType(), r.getSubjectType(), r.getRedirectUris(), r.getSectorIdentifierUri())) {
                            builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
                            builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_REDIRECT_URI));
                            break block28;
                        }
                        this.registerParamsValidator.validateLogoutUri(r.getFrontChannelLogoutUris(), (List<String>)r.getRedirectUris(), this.errorResponseFactory);
                        String clientsBaseDN = this.staticConfiguration.getBaseDn().getClients();
                        String inum = this.inumService.generateClientInum();
                        String generatedClientSecret = UUID.randomUUID().toString();
                        Client client = new Client();
                        client.setDn("inum=" + inum + "," + clientsBaseDN);
                        client.setClientId(inum);
                        client.setClientSecret(this.clientService.encryptSecret(generatedClientSecret));
                        client.setRegistrationAccessToken(HandleTokenFactory.generateHandleToken());
                        client.setIdTokenTokenBindingCnf(r.getIdTokenTokenBindingCnf());
                        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                        client.setClientIdIssuedAt(calendar.getTime());
                        if (this.appConfiguration.getDynamicRegistrationExpirationTime() > 0) {
                            ((Calendar)calendar).add(13, this.appConfiguration.getDynamicRegistrationExpirationTime());
                            client.setClientSecretExpiresAt(calendar.getTime());
                        }
                        if (StringUtils.isBlank((String)r.getClientName()) && r.getRedirectUris() != null && !r.getRedirectUris().isEmpty()) {
                            try {
                                URI redUri = new URI((String)r.getRedirectUris().get(0));
                                client.setClientName(redUri.getHost());
                            }
                            catch (Exception e) {
                                this.log.error(e.getMessage(), (Throwable)e);
                                client.setClientName("Unknown");
                            }
                        }
                        this.updateClientFromRequestObject(client, r, false);
                        boolean registerClient = true;
                        if (this.externalDynamicClientRegistrationService.isEnabled()) {
                            registerClient = this.externalDynamicClientRegistrationService.executeExternalCreateClientMethods(r, client);
                        }
                        if (registerClient) {
                            Date currentTime = Calendar.getInstance().getTime();
                            client.setLastAccessTime(currentTime);
                            client.setLastLogonTime(currentTime);
                            Boolean persistClientAuthorizations = this.appConfiguration.getDynamicRegistrationPersistClientAuthorizations();
                            client.setPersistClientAuthorizations(persistClientAuthorizations != null ? persistClientAuthorizations : false);
                            this.clientService.persist(client);
                            JSONObject jsonObject = this.getJSONObject(client, this.appConfiguration.getLegacyDynamicRegistrationScopeParam());
                            builder.entity((Object)jsonObject.toString(4).replace("\\/", "/"));
                            this.log.info("Client registered: clientId = {}, applicationType = {}, clientName = {}, redirectUris = {}, sectorIdentifierUri = {}", new Object[]{client.getClientId(), client.getApplicationType(), client.getClientName(), client.getRedirectUris(), client.getSectorIdentifierUri()});
                            oAuth2AuditLog.setClientId(client.getClientId());
                            oAuth2AuditLog.setScope(this.clientScopesToString(client));
                            oAuth2AuditLog.setSuccess(true);
                        } else {
                            this.log.trace("Client parameters are invalid, returns invalid_request error.");
                            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA));
                        }
                        break block28;
                    }
                    this.log.trace("Client parameters are invalid, returns invalid_request error.");
                    builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA));
                    break block28;
                }
                this.log.info("Dynamic client registration is disabled.");
                builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.ACCESS_DENIED));
            }
            catch (StringEncrypter.EncryptionException e) {
                builder = this.internalErrorResponse();
                this.log.error(e.getMessage(), (Throwable)e);
            }
            catch (JSONException e) {
                builder = this.internalErrorResponse();
                this.log.error(e.getMessage(), (Throwable)e);
            }
            catch (WebApplicationException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (InvalidJwtException e) {
                builder = this.badRequestResponse();
                this.log.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                builder = this.internalErrorResponse();
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        builder.cacheControl(ServerUtil.cacheControl(true, false));
        builder.header("Pragma", (Object)"no-cache");
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        return builder.build();
    }

    public Response.ResponseBuilder internalErrorResponse() {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA));
    }

    public Response.ResponseBuilder badRequestResponse() {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA));
    }

    private void updateClientFromRequestObject(Client p_client, RegisterRequest requestObject, boolean update) throws JSONException {
        List scopes;
        ArrayList authorizedOrigins;
        ArrayList postLogoutRedirectUris;
        ArrayList defaultAcrValues;
        ArrayList claimsRedirectUris;
        ArrayList redirectUris = requestObject.getRedirectUris();
        if (redirectUris != null && !redirectUris.isEmpty()) {
            redirectUris = new ArrayList(new HashSet(redirectUris));
            p_client.setRedirectUris(redirectUris.toArray(new String[redirectUris.size()]));
        }
        if ((claimsRedirectUris = requestObject.getClaimsRedirectUris()) != null && !claimsRedirectUris.isEmpty()) {
            claimsRedirectUris = new ArrayList(new HashSet(claimsRedirectUris));
            p_client.setClaimRedirectUris(claimsRedirectUris.toArray(new String[claimsRedirectUris.size()]));
        }
        if (requestObject.getApplicationType() != null) {
            p_client.setApplicationType(requestObject.getApplicationType().toString());
        }
        if (StringUtils.isNotBlank((String)requestObject.getClientName())) {
            p_client.setClientName(requestObject.getClientName());
        }
        if (StringUtils.isNotBlank((String)requestObject.getSectorIdentifierUri())) {
            p_client.setSectorIdentifierUri(requestObject.getSectorIdentifierUri());
        }
        HashSet<ResponseType> responseTypeSet = new HashSet<ResponseType>();
        responseTypeSet.addAll(requestObject.getResponseTypes());
        HashSet<GrantType> grantTypeSet = new HashSet<GrantType>();
        grantTypeSet.addAll(requestObject.getGrantTypes());
        if (responseTypeSet.size() == 0 && grantTypeSet.size() == 0) {
            responseTypeSet.add(ResponseType.CODE);
        }
        if (responseTypeSet.contains(ResponseType.CODE)) {
            grantTypeSet.add(GrantType.AUTHORIZATION_CODE);
            grantTypeSet.add(GrantType.REFRESH_TOKEN);
        }
        if (responseTypeSet.contains(ResponseType.TOKEN) || responseTypeSet.contains(ResponseType.ID_TOKEN)) {
            grantTypeSet.add(GrantType.IMPLICIT);
        }
        if (grantTypeSet.contains(GrantType.AUTHORIZATION_CODE)) {
            responseTypeSet.add(ResponseType.CODE);
            grantTypeSet.add(GrantType.REFRESH_TOKEN);
        }
        if (grantTypeSet.contains(GrantType.IMPLICIT)) {
            responseTypeSet.add(ResponseType.TOKEN);
        }
        Set responseTypesSupported = this.appConfiguration.getResponseTypesSupported();
        Set grantTypesSupported = this.appConfiguration.getGrantTypesSupported();
        if (!responseTypesSupported.contains(responseTypeSet)) {
            responseTypeSet.clear();
        }
        grantTypeSet.retainAll(grantTypesSupported);
        Set dynamicGrantTypeDefault = this.appConfiguration.getDynamicGrantTypeDefault();
        grantTypeSet.retainAll(dynamicGrantTypeDefault);
        p_client.setResponseTypes(responseTypeSet.toArray(new ResponseType[responseTypeSet.size()]));
        if (!update) {
            p_client.setGrantTypes(grantTypeSet.toArray(new GrantType[grantTypeSet.size()]));
        } else if (this.appConfiguration.getEnableClientGrantTypeUpdate().booleanValue()) {
            p_client.setGrantTypes(grantTypeSet.toArray(new GrantType[grantTypeSet.size()]));
        }
        ArrayList contacts = requestObject.getContacts();
        if (contacts != null && !contacts.isEmpty()) {
            contacts = new ArrayList(new HashSet(contacts));
            p_client.setContacts(contacts.toArray(new String[contacts.size()]));
        }
        if (StringUtils.isNotBlank((String)requestObject.getLogoUri())) {
            p_client.setLogoUri(requestObject.getLogoUri());
        }
        if (StringUtils.isNotBlank((String)requestObject.getClientUri())) {
            p_client.setClientUri(requestObject.getClientUri());
        }
        if (StringUtils.isNotBlank((String)requestObject.getPolicyUri())) {
            p_client.setPolicyUri(requestObject.getPolicyUri());
        }
        if (StringUtils.isNotBlank((String)requestObject.getTosUri())) {
            p_client.setTosUri(requestObject.getTosUri());
        }
        if (StringUtils.isNotBlank((String)requestObject.getJwksUri())) {
            p_client.setJwksUri(requestObject.getJwksUri());
        }
        if (StringUtils.isNotBlank((String)requestObject.getJwks())) {
            p_client.setJwks(requestObject.getJwks());
        }
        if (requestObject.getSubjectType() != null) {
            p_client.setSubjectType(requestObject.getSubjectType().toString());
        }
        if (requestObject.getRptAsJwt() != null) {
            p_client.setRptAsJwt(requestObject.getRptAsJwt());
        }
        if (requestObject.getAccessTokenAsJwt() != null) {
            p_client.setAccessTokenAsJwt(requestObject.getAccessTokenAsJwt());
        }
        if (requestObject.getAccessTokenSigningAlg() != null) {
            p_client.setAccessTokenSigningAlg(requestObject.getAccessTokenSigningAlg().toString());
        }
        if (requestObject.getIdTokenSignedResponseAlg() != null) {
            p_client.setIdTokenSignedResponseAlg(requestObject.getIdTokenSignedResponseAlg().toString());
        }
        if (requestObject.getIdTokenEncryptedResponseAlg() != null) {
            p_client.setIdTokenEncryptedResponseAlg(requestObject.getIdTokenEncryptedResponseAlg().toString());
        }
        if (requestObject.getIdTokenEncryptedResponseEnc() != null) {
            p_client.setIdTokenEncryptedResponseEnc(requestObject.getIdTokenEncryptedResponseEnc().toString());
        }
        if (requestObject.getUserInfoSignedResponseAlg() != null) {
            p_client.setUserInfoSignedResponseAlg(requestObject.getUserInfoSignedResponseAlg().toString());
        }
        if (requestObject.getUserInfoEncryptedResponseAlg() != null) {
            p_client.setUserInfoEncryptedResponseAlg(requestObject.getUserInfoEncryptedResponseAlg().toString());
        }
        if (requestObject.getUserInfoEncryptedResponseEnc() != null) {
            p_client.setUserInfoEncryptedResponseEnc(requestObject.getUserInfoEncryptedResponseEnc().toString());
        }
        if (requestObject.getRequestObjectSigningAlg() != null) {
            p_client.setRequestObjectSigningAlg(requestObject.getRequestObjectSigningAlg().toString());
        }
        if (requestObject.getRequestObjectEncryptionAlg() != null) {
            p_client.setRequestObjectEncryptionAlg(requestObject.getRequestObjectEncryptionAlg().toString());
        }
        if (requestObject.getRequestObjectEncryptionEnc() != null) {
            p_client.setRequestObjectEncryptionEnc(requestObject.getRequestObjectEncryptionEnc().toString());
        }
        if (requestObject.getTokenEndpointAuthMethod() != null) {
            p_client.setTokenEndpointAuthMethod(requestObject.getTokenEndpointAuthMethod().toString());
        } else {
            p_client.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_BASIC.toString());
        }
        if (requestObject.getTokenEndpointAuthSigningAlg() != null) {
            p_client.setTokenEndpointAuthSigningAlg(requestObject.getTokenEndpointAuthSigningAlg().toString());
        }
        if (requestObject.getDefaultMaxAge() != null) {
            p_client.setDefaultMaxAge(requestObject.getDefaultMaxAge());
        }
        if (requestObject.getRequireAuthTime() != null) {
            p_client.setRequireAuthTime(requestObject.getRequireAuthTime());
        }
        if ((defaultAcrValues = requestObject.getDefaultAcrValues()) != null && !defaultAcrValues.isEmpty()) {
            defaultAcrValues = new ArrayList(new HashSet(defaultAcrValues));
            p_client.setDefaultAcrValues(defaultAcrValues.toArray(new String[defaultAcrValues.size()]));
        }
        if (StringUtils.isNotBlank((String)requestObject.getInitiateLoginUri())) {
            p_client.setInitiateLoginUri(requestObject.getInitiateLoginUri());
        }
        if ((postLogoutRedirectUris = requestObject.getPostLogoutRedirectUris()) != null && !postLogoutRedirectUris.isEmpty()) {
            postLogoutRedirectUris = new ArrayList(new HashSet(postLogoutRedirectUris));
            p_client.setPostLogoutRedirectUris(postLogoutRedirectUris.toArray(new String[postLogoutRedirectUris.size()]));
        }
        if (requestObject.getFrontChannelLogoutUris() != null && !requestObject.getFrontChannelLogoutUris().isEmpty()) {
            p_client.setFrontChannelLogoutUri(requestObject.getFrontChannelLogoutUris().toArray(new String[requestObject.getFrontChannelLogoutUris().size()]));
        }
        p_client.setFrontChannelLogoutSessionRequired(requestObject.getFrontChannelLogoutSessionRequired());
        ArrayList requestUris = requestObject.getRequestUris();
        if (requestUris != null && !requestUris.isEmpty()) {
            requestUris = new ArrayList(new HashSet(requestUris));
            p_client.setRequestUris(requestUris.toArray(new String[requestUris.size()]));
        }
        if ((authorizedOrigins = requestObject.getAuthorizedOrigins()) != null && !authorizedOrigins.isEmpty()) {
            authorizedOrigins = new ArrayList(new HashSet(authorizedOrigins));
            p_client.setAuthorizedOrigins(authorizedOrigins.toArray(new String[authorizedOrigins.size()]));
        }
        if ((scopes = requestObject.getScope()) != null && !scopes.isEmpty() && this.appConfiguration.getDynamicRegistrationScopesParamEnabled() != null && this.appConfiguration.getDynamicRegistrationScopesParamEnabled().booleanValue()) {
            List<String> defaultScopes = this.scopeService.getDefaultScopesDn();
            List<String> requestedScopes = this.scopeService.getScopesDn(scopes);
            HashSet<String> allowedScopes = new HashSet<String>();
            for (String requestedScope : requestedScopes) {
                if (!defaultScopes.contains(requestedScope)) continue;
                allowedScopes.add(requestedScope);
            }
            ArrayList scopesDn = new ArrayList(allowedScopes);
            p_client.setScopes(scopesDn.toArray(new String[scopesDn.size()]));
        } else {
            List<String> scopesDn = this.scopeService.getDefaultScopesDn();
            p_client.setScopes(scopesDn.toArray(new String[scopesDn.size()]));
        }
        List claims = requestObject.getClaims();
        if (claims != null && !claims.isEmpty()) {
            List<String> claimsDn = this.attributeService.getAttributesDn(claims);
            p_client.setClaims(claimsDn.toArray(new String[claimsDn.size()]));
        }
        if (requestObject.getJsonObject() != null) {
            this.putCustomStuffIntoObject(p_client, requestObject.getJsonObject());
        }
        if (requestObject.getAccessTokenLifetime() != null) {
            p_client.setAccessTokenLifetime(requestObject.getAccessTokenLifetime());
        }
        if (StringUtils.isNotBlank((String)requestObject.getSoftwareId())) {
            p_client.setSoftwareId(requestObject.getSoftwareId());
        }
        if (StringUtils.isNotBlank((String)requestObject.getSoftwareVersion())) {
            p_client.setSoftwareVersion(requestObject.getSoftwareVersion());
        }
        if (StringUtils.isNotBlank((String)requestObject.getSoftwareStatement())) {
            p_client.setSoftwareStatement(requestObject.getSoftwareStatement());
        }
    }

    @Override
    public Response requestClientUpdate(String requestParams, String clientId, @HeaderParam(value="Authorization") String authorization, @Context HttpServletRequest httpRequest, @Context SecurityContext securityContext) {
        OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(httpRequest), Action.CLIENT_UPDATE);
        oAuth2AuditLog.setClientId(clientId);
        try {
            RegisterRequest request;
            this.log.debug("Attempting to UPDATE client, client_id: {}, requestParams = {}, isSecure = {}", new Object[]{clientId, requestParams, securityContext.isSecure()});
            String accessToken = this.tokenService.getTokenFromAuthorizationParameter(authorization);
            if (StringUtils.isNotBlank((String)accessToken) && StringUtils.isNotBlank((String)clientId) && StringUtils.isNotBlank((String)requestParams) && (request = RegisterRequest.fromJson((String)requestParams, (boolean)this.appConfiguration.getLegacyDynamicRegistrationScopeParam())) != null) {
                boolean redirectUrisValidated = true;
                if (request.getRedirectUris() != null && !request.getRedirectUris().isEmpty()) {
                    redirectUrisValidated = this.registerParamsValidator.validateRedirectUris(request.getApplicationType(), request.getSubjectType(), request.getRedirectUris(), request.getSectorIdentifierUri());
                }
                if (redirectUrisValidated) {
                    if (request.getSubjectType() != null && !this.appConfiguration.getSubjectTypesSupported().contains(request.getSubjectType().toString())) {
                        this.log.debug("Client UPDATE : parameter subject_type is invalid. Returns BAD_REQUEST response.");
                        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA)).build();
                    }
                    Client client = this.clientService.getClient(clientId, accessToken);
                    if (client != null) {
                        this.updateClientFromRequestObject(client, request, true);
                        boolean updateClient = true;
                        if (this.externalDynamicClientRegistrationService.isEnabled()) {
                            updateClient = this.externalDynamicClientRegistrationService.executeExternalUpdateClientMethods(request, client);
                        }
                        if (updateClient) {
                            this.clientService.merge(client);
                            oAuth2AuditLog.setScope(this.clientScopesToString(client));
                            oAuth2AuditLog.setSuccess(true);
                            this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
                            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.clientAsEntity(client)).build();
                        }
                        this.log.trace("The Access Token is not valid for the Client ID, returns invalid_token error.");
                        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_TOKEN)).build();
                    }
                    this.log.trace("The Access Token is not valid for the Client ID, returns invalid_token error.");
                    this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_TOKEN)).build();
                }
            }
            this.log.debug("Client UPDATE : parameters are invalid. Returns BAD_REQUEST response.");
            this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA)).build();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
            return this.internalErrorResponse().build();
        }
    }

    @Override
    public Response requestClientRead(String clientId, String authorization, HttpServletRequest httpRequest, SecurityContext securityContext) {
        String accessToken = this.tokenService.getTokenFromAuthorizationParameter(authorization);
        this.log.debug("Attempting to read client: clientId = {}, registrationAccessToken = {} isSecure = {}", new Object[]{clientId, accessToken, securityContext.isSecure()});
        Response.ResponseBuilder builder = Response.ok();
        OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(httpRequest), Action.CLIENT_READ);
        oAuth2AuditLog.setClientId(clientId);
        try {
            if (this.appConfiguration.getDynamicRegistrationEnabled().booleanValue()) {
                if (this.registerParamsValidator.validateParamsClientRead(clientId, accessToken)) {
                    Client client = this.clientService.getClient(clientId, accessToken);
                    if (client != null) {
                        oAuth2AuditLog.setScope(this.clientScopesToString(client));
                        oAuth2AuditLog.setSuccess(true);
                        builder.entity((Object)this.clientAsEntity(client));
                    } else {
                        this.log.trace("The Access Token is not valid for the Client ID, returns invalid_token error.");
                        builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
                        builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_TOKEN));
                    }
                } else {
                    this.log.trace("Client parameters are invalid.");
                    builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
                    builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA));
                }
            } else {
                builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
                builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.ACCESS_DENIED));
            }
        }
        catch (JSONException e) {
            builder = Response.status((int)500);
            builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA));
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (StringEncrypter.EncryptionException e) {
            builder = Response.status((int)500);
            builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA));
            this.log.error(e.getMessage(), (Throwable)e);
        }
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoTransform(false);
        cacheControl.setNoStore(true);
        builder.cacheControl(cacheControl);
        builder.header("Pragma", (Object)"no-cache");
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        return builder.build();
    }

    private String clientAsEntity(Client p_client) throws JSONException, StringEncrypter.EncryptionException {
        JSONObject jsonObject = this.getJSONObject(p_client, this.appConfiguration.getLegacyDynamicRegistrationScopeParam());
        return jsonObject.toString(4).replace("\\/", "/");
    }

    private JSONObject getJSONObject(Client client, boolean authorizationRequestCustomAllowedParameters) throws JSONException, StringEncrypter.EncryptionException {
        JSONObject responseJsonObject = new JSONObject();
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterResponseParam.CLIENT_ID.toString(), (Object)client.getClientId());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterResponseParam.CLIENT_SECRET.toString(), (Object)this.clientService.decryptSecret(client.getClientSecret()));
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString(), (Object)client.getRegistrationAccessToken());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterResponseParam.REGISTRATION_CLIENT_URI.toString(), (Object)(this.appConfiguration.getRegistrationEndpoint() + "?" + RegisterResponseParam.CLIENT_ID.toString() + "=" + client.getClientId()));
        responseJsonObject.put(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString(), client.getClientIdIssuedAt().getTime() / 1000L);
        responseJsonObject.put(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString(), client.getClientSecretExpiresAt() != null && client.getClientSecretExpiresAt().getTime() > 0L ? client.getClientSecretExpiresAt().getTime() / 1000L : 0L);
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.REDIRECT_URIS.toString(), (String[])client.getRedirectUris());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.CLAIMS_REDIRECT_URIS.toString(), (String[])client.getClaimRedirectUris());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.RESPONSE_TYPES.toString(), (String[])ResponseType.toStringArray((ResponseType[])client.getResponseTypes()));
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.GRANT_TYPES.toString(), (String[])GrantType.toStringArray((GrantType[])client.getGrantTypes()));
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.APPLICATION_TYPE.toString(), (Object)client.getApplicationType());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.CONTACTS.toString(), (String[])client.getContacts());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.CLIENT_NAME.toString(), (Object)client.getClientName());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.LOGO_URI.toString(), (Object)client.getLogoUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.CLIENT_URI.toString(), (Object)client.getClientUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.POLICY_URI.toString(), (Object)client.getPolicyUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.TOS_URI.toString(), (Object)client.getTosUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.JWKS_URI.toString(), (Object)client.getJwksUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.SECTOR_IDENTIFIER_URI.toString(), (Object)client.getSectorIdentifierUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.SUBJECT_TYPE.toString(), (Object)client.getSubjectType());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString(), (Object)client.getIdTokenSignedResponseAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ALG.toString(), (Object)client.getIdTokenEncryptedResponseAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ENC.toString(), (Object)client.getIdTokenEncryptedResponseEnc());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.USERINFO_SIGNED_RESPONSE_ALG.toString(), (Object)client.getUserInfoSignedResponseAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ALG.toString(), (Object)client.getUserInfoEncryptedResponseAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ENC.toString(), (Object)client.getUserInfoEncryptedResponseEnc());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString(), (Object)client.getRequestObjectSigningAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ALG.toString(), (Object)client.getRequestObjectEncryptionAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.REQUEST_OBJECT_ENCRYPTION_ENC.toString(), (Object)client.getRequestObjectEncryptionEnc());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString(), (Object)client.getTokenEndpointAuthMethod());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.TOKEN_ENDPOINT_AUTH_SIGNING_ALG.toString(), (Object)client.getTokenEndpointAuthSigningAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.DEFAULT_MAX_AGE.toString(), (Object)client.getDefaultMaxAge());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.REQUIRE_AUTH_TIME.toString(), (Object)client.getRequireAuthTime());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.DEFAULT_ACR_VALUES.toString(), (String[])client.getDefaultAcrValues());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.INITIATE_LOGIN_URI.toString(), (Object)client.getInitiateLoginUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.POST_LOGOUT_REDIRECT_URIS.toString(), (String[])client.getPostLogoutRedirectUris());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.REQUEST_URIS.toString(), (String[])client.getRequestUris());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.AUTHORIZED_ORIGINS.toString(), (String[])client.getAuthorizedOrigins());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.RPT_AS_JWT.toString(), (Object)client.isRptAsJwt());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.ACCESS_TOKEN_AS_JWT.toString(), (Object)client.isAccessTokenAsJwt());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.ACCESS_TOKEN_SIGNING_ALG.toString(), (Object)client.getAccessTokenSigningAlg());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.ACCESS_TOKEN_LIFETIME.toString(), (Object)client.getAccessTokenLifetime());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.SOFTWARE_ID.toString(), (Object)client.getSoftwareId());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.SOFTWARE_VERSION.toString(), (Object)client.getSoftwareVersion());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.SOFTWARE_STATEMENT.toString(), (Object)client.getSoftwareStatement());
        if (!Util.isNullOrEmpty((String)client.getJwks())) {
            Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.JWKS.toString(), (Object)new JSONObject(client.getJwks()));
        }
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.FRONT_CHANNEL_LOGOUT_URI.toString(), (String[])client.getFrontChannelLogoutUri());
        Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.FRONT_CHANNEL_LOGOUT_SESSION_REQUIRED.toString(), (Object)client.getFrontChannelLogoutSessionRequired());
        String[] scopeNames = null;
        String[] scopeDns = client.getScopes();
        if (scopeDns != null) {
            scopeNames = new String[scopeDns.length];
            for (int i = 0; i < scopeDns.length; ++i) {
                Scope scope = this.scopeService.getScopeByDn(scopeDns[i]);
                scopeNames[i] = scope.getDisplayName();
            }
        }
        if (authorizationRequestCustomAllowedParameters) {
            Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.SCOPES.toString(), (String[])scopeNames);
        } else {
            Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.SCOPE.toString(), (Object)org.xdi.oxauth.model.util.StringUtils.implode((String[])scopeNames, (String)" "));
        }
        String[] claimNames = null;
        String[] claimDns = client.getClaims();
        if (claimDns != null) {
            claimNames = new String[claimDns.length];
            for (int i = 0; i < claimDns.length; ++i) {
                GluuAttribute gluuAttribute = this.attributeService.getAttributeByDn(claimDns[i]);
                claimNames[i] = gluuAttribute.getOxAuthClaimName();
            }
        }
        if (claimNames != null && claimNames.length > 0) {
            Util.addToJSONObjectIfNotNull((JSONObject)responseJsonObject, (String)RegisterRequestParam.CLAIMS.toString(), (Object)org.xdi.oxauth.model.util.StringUtils.implode((String[])claimNames, (String)" "));
        }
        return responseJsonObject;
    }

    private void putCustomStuffIntoObject(Client p_client, JSONObject p_requestObject) throws JSONException {
        List attrList;
        String customOC = this.appConfiguration.getDynamicRegistrationCustomObjectClass();
        if (StringUtils.isNotBlank((String)customOC)) {
            p_client.setCustomObjectClasses(new String[]{customOC});
        }
        if ((attrList = this.appConfiguration.getDynamicRegistrationCustomAttributes()) != null && !attrList.isEmpty()) {
            for (String attr : attrList) {
                JSONArray parameterValuesJsonArray;
                List<String> parameterValues;
                if (!p_requestObject.has(attr) || (parameterValues = (parameterValuesJsonArray = p_requestObject.optJSONArray(attr)) != null ? org.xdi.oxauth.model.util.StringUtils.toList((JSONArray)parameterValuesJsonArray) : Arrays.asList(p_requestObject.getString(attr))) == null || parameterValues.isEmpty()) continue;
                try {
                    boolean processed = this.processApplicationAttributes(p_client, attr, parameterValues);
                    if (processed) continue;
                    p_client.getCustomAttributes().add(new CustomAttribute(attr, parameterValues));
                }
                catch (Exception e) {
                    this.log.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private boolean processApplicationAttributes(Client p_client, String attr, List<String> parameterValues) {
        if (StringHelper.equalsIgnoreCase((String)"oxAuthTrustedClient", (String)attr)) {
            boolean trustedClient = StringHelper.toBoolean((String)parameterValues.get(0), (boolean)false);
            p_client.setTrustedClient(trustedClient);
            return true;
        }
        if (StringHelper.equalsIgnoreCase((String)"oxIncludeClaimsInIdToken", (String)attr)) {
            boolean includeClaimsInIdToken = StringHelper.toBoolean((String)parameterValues.get(0), (boolean)false);
            p_client.setIncludeClaimsInIdToken(includeClaimsInIdToken);
            return true;
        }
        return false;
    }

    private String clientScopesToString(Client client) {
        String[] scopeDns = client.getScopes();
        if (scopeDns != null) {
            Object[] scopeNames = new String[scopeDns.length];
            for (int i = 0; i < scopeDns.length; ++i) {
                Scope scope = this.scopeService.getScopeByDn(scopeDns[i]);
                scopeNames[i] = scope.getDisplayName();
            }
            return StringUtils.join((Object[])scopeNames, (String)" ");
        }
        return null;
    }
}

