/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.token;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.model.GluuAttribute;
import org.xdi.model.custom.script.conf.CustomScriptConfiguration;
import org.xdi.model.custom.script.type.auth.PersonAuthenticationType;
import org.xdi.oxauth.model.authorize.Claim;
import org.xdi.oxauth.model.common.AccessToken;
import org.xdi.oxauth.model.common.AuthorizationCode;
import org.xdi.oxauth.model.common.IAuthorizationGrant;
import org.xdi.oxauth.model.common.Scope;
import org.xdi.oxauth.model.common.ScopeType;
import org.xdi.oxauth.model.common.SubjectType;
import org.xdi.oxauth.model.common.UnmodifiableAuthorizationGrant;
import org.xdi.oxauth.model.config.WebKeysConfiguration;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.crypto.AbstractCryptoProvider;
import org.xdi.oxauth.model.crypto.CryptoProviderFactory;
import org.xdi.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.xdi.oxauth.model.exception.InvalidJweException;
import org.xdi.oxauth.model.jwe.Jwe;
import org.xdi.oxauth.model.jwe.JweEncrypterImpl;
import org.xdi.oxauth.model.jwk.Algorithm;
import org.xdi.oxauth.model.jwk.JSONWebKeySet;
import org.xdi.oxauth.model.jwk.Use;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.jwt.JwtSubClaimObject;
import org.xdi.oxauth.model.jwt.JwtType;
import org.xdi.oxauth.model.ldap.PairwiseIdentifier;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.token.JsonWebResponse;
import org.xdi.oxauth.model.token.JwtSigner;
import org.xdi.oxauth.model.util.JwtUtil;
import org.xdi.oxauth.service.AttributeService;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.PairwiseIdentifierService;
import org.xdi.oxauth.service.ScopeService;
import org.xdi.oxauth.service.external.ExternalAuthenticationService;
import org.xdi.oxauth.service.external.ExternalDynamicScopeService;
import org.xdi.oxauth.service.external.context.DynamicScopeExternalContext;
import org.xdi.util.security.StringEncrypter;

@Stateless
@Named
public class IdTokenFactory {
    @Inject
    private ExternalDynamicScopeService externalDynamicScopeService;
    @Inject
    private ExternalAuthenticationService externalAuthenticationService;
    @Inject
    private ClientService clientService;
    @Inject
    private ScopeService scopeService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private PairwiseIdentifierService pairwiseIdentifierService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;

    public Jwt generateSignedIdToken(IAuthorizationGrant authorizationGrant, String nonce, AuthorizationCode authorizationCode, AccessToken accessToken, Set<String> scopes, boolean includeIdTokenClaims, Function<JsonWebResponse, Void> preProcessing) throws Exception {
        String value;
        JwtSigner jwtSigner = JwtSigner.newJwtSigner(this.appConfiguration, this.webKeysConfiguration, authorizationGrant.getClient());
        Jwt jwt = jwtSigner.newJwt();
        int lifeTime = this.appConfiguration.getIdTokenLifetime();
        Calendar calendar = Calendar.getInstance();
        Date issuedAt = calendar.getTime();
        calendar.add(13, lifeTime);
        Date expiration = calendar.getTime();
        jwt.getClaims().setExpirationTime(expiration);
        jwt.getClaims().setIssuedAt(issuedAt);
        if (preProcessing != null) {
            preProcessing.apply((Object)jwt);
        }
        if (authorizationGrant.getAcrValues() != null) {
            jwt.getClaims().setClaim("acr", authorizationGrant.getAcrValues());
            this.setAmrClaim((JsonWebResponse)jwt, authorizationGrant.getAcrValues());
        }
        if (StringUtils.isNotBlank((String)nonce)) {
            jwt.getClaims().setClaim("nonce", nonce);
        }
        if (authorizationGrant.getAuthenticationTime() != null) {
            jwt.getClaims().setClaim("auth_time", authorizationGrant.getAuthenticationTime());
        }
        if (authorizationCode != null) {
            String codeHash = authorizationCode.getHash(jwtSigner.getSignatureAlgorithm());
            jwt.getClaims().setClaim("c_hash", codeHash);
        }
        if (accessToken != null) {
            String accessTokenHash = accessToken.getHash(jwtSigner.getSignatureAlgorithm());
            jwt.getClaims().setClaim("at_hash", accessTokenHash);
        }
        jwt.getClaims().setClaim("oxOpenIDConnectVersion", this.appConfiguration.getOxOpenIdConnectVersion());
        ArrayList dynamicScopes = Lists.newArrayList();
        if (includeIdTokenClaims && authorizationGrant.getClient().isIncludeClaimsInIdToken()) {
            for (String scopeName : scopes) {
                Scope scope = this.scopeService.getScopeByDisplayName(scopeName);
                if (scope != null && ScopeType.DYNAMIC == scope.getScopeType()) {
                    dynamicScopes.add(scope);
                    continue;
                }
                if (scope == null || scope.getOxAuthClaims() == null) continue;
                if (scope.getIsOxAuthGroupClaims()) {
                    JwtSubClaimObject groupClaim = new JwtSubClaimObject();
                    groupClaim.setName(scope.getDisplayName());
                    for (String claimDn : scope.getOxAuthClaims()) {
                        Object attributeValue;
                        GluuAttribute gluuAttribute = this.attributeService.getAttributeByDn(claimDn);
                        String claimName = gluuAttribute.getOxAuthClaimName();
                        String ldapName = gluuAttribute.getName();
                        if (!StringUtils.isNotBlank((String)claimName) || !StringUtils.isNotBlank((String)ldapName) || (attributeValue = ldapName.equals("uid") ? authorizationGrant.getUser().getUserId() : authorizationGrant.getUser().getAttribute(gluuAttribute.getName(), true)) == null) continue;
                        if (attributeValue instanceof JSONArray) {
                            JSONArray jsonArray = (JSONArray)attributeValue;
                            ArrayList<String> values = new ArrayList<String>();
                            for (int i = 0; i < jsonArray.length(); ++i) {
                                String value2 = jsonArray.optString(i);
                                if (value2 == null) continue;
                                values.add(value2);
                            }
                            jwt.getClaims().setClaim(claimName, values);
                            continue;
                        }
                        value = attributeValue.toString();
                        jwt.getClaims().setClaim(claimName, value);
                    }
                    jwt.getClaims().setClaim(scope.getDisplayName(), groupClaim);
                    continue;
                }
                for (String claimDn : scope.getOxAuthClaims()) {
                    Object attributeValue;
                    GluuAttribute gluuAttribute = this.attributeService.getAttributeByDn(claimDn);
                    String claimName = gluuAttribute.getOxAuthClaimName();
                    String ldapName = gluuAttribute.getName();
                    if (!StringUtils.isNotBlank((String)claimName) || !StringUtils.isNotBlank((String)ldapName) || (attributeValue = ldapName.equals("uid") ? authorizationGrant.getUser().getUserId() : authorizationGrant.getUser().getAttribute(gluuAttribute.getName(), true)) == null) continue;
                    if (attributeValue instanceof JSONArray) {
                        JSONArray jsonArray = (JSONArray)attributeValue;
                        ArrayList<String> values = new ArrayList<String>();
                        for (int i = 0; i < jsonArray.length(); ++i) {
                            String value3 = jsonArray.optString(i);
                            if (value3 == null) continue;
                            values.add(value3);
                        }
                        jwt.getClaims().setClaim(claimName, values);
                        continue;
                    }
                    String value4 = attributeValue.toString();
                    jwt.getClaims().setClaim(claimName, value4);
                }
            }
        }
        if (authorizationGrant.getJwtAuthorizationRequest() != null && authorizationGrant.getJwtAuthorizationRequest().getIdTokenMember() != null) {
            for (Claim claim : authorizationGrant.getJwtAuthorizationRequest().getIdTokenMember().getClaims()) {
                Client client;
                boolean optional = true;
                GluuAttribute gluuAttribute = this.attributeService.getByClaimName(claim.getName());
                if (gluuAttribute == null || !this.validateRequesteClaim(gluuAttribute, (client = authorizationGrant.getClient()).getClaims(), scopes)) continue;
                String ldapClaimName = gluuAttribute.getName();
                Object attribute = authorizationGrant.getUser().getAttribute(ldapClaimName, optional);
                if (attribute == null) continue;
                if (attribute instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)attribute;
                    ArrayList<String> values = new ArrayList<String>();
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        value = jsonArray.optString(i);
                        if (value == null) continue;
                        values.add(value);
                    }
                    jwt.getClaims().setClaim(claim.getName(), values);
                    continue;
                }
                String value5 = (String)attribute;
                jwt.getClaims().setClaim(claim.getName(), value5);
            }
        }
        if (authorizationGrant.getClient().getSubjectType() != null && SubjectType.fromString((String)authorizationGrant.getClient().getSubjectType()).equals((Object)SubjectType.PAIRWISE)) {
            String clientId;
            String sectorIdentifierUri = null;
            sectorIdentifierUri = StringUtils.isNotBlank((String)authorizationGrant.getClient().getSectorIdentifierUri()) ? authorizationGrant.getClient().getSectorIdentifierUri() : authorizationGrant.getClient().getRedirectUris()[0];
            String userInum = authorizationGrant.getUser().getAttribute("inum");
            PairwiseIdentifier pairwiseIdentifier = this.pairwiseIdentifierService.findPairWiseIdentifier(userInum, sectorIdentifierUri, clientId = authorizationGrant.getClientId());
            if (pairwiseIdentifier == null) {
                pairwiseIdentifier = new PairwiseIdentifier(sectorIdentifierUri, clientId);
                pairwiseIdentifier.setId(UUID.randomUUID().toString());
                pairwiseIdentifier.setDn(this.pairwiseIdentifierService.getDnForPairwiseIdentifier(pairwiseIdentifier.getId(), userInum));
                this.pairwiseIdentifierService.addPairwiseIdentifier(userInum, pairwiseIdentifier);
            }
            jwt.getClaims().setSubjectIdentifier(pairwiseIdentifier.getId());
        } else {
            String openidSubAttribute = this.appConfiguration.getOpenidSubAttribute();
            if (openidSubAttribute.equals("uid")) {
                jwt.getClaims().setSubjectIdentifier(authorizationGrant.getUser().getUserId());
            } else {
                jwt.getClaims().setSubjectIdentifier(authorizationGrant.getUser().getAttribute(openidSubAttribute));
            }
        }
        if (dynamicScopes.size() > 0 && this.externalDynamicScopeService.isEnabled()) {
            UnmodifiableAuthorizationGrant unmodifiableAuthorizationGrant = new UnmodifiableAuthorizationGrant(authorizationGrant);
            DynamicScopeExternalContext dynamicScopeContext = new DynamicScopeExternalContext(dynamicScopes, (JsonWebResponse)jwt, unmodifiableAuthorizationGrant);
            this.externalDynamicScopeService.executeExternalUpdateMethods(dynamicScopeContext);
        }
        return jwtSigner.sign();
    }

    private void setAmrClaim(JsonWebResponse jwt, String acrValues) {
        ArrayList amrList = Lists.newArrayList();
        CustomScriptConfiguration script = this.externalAuthenticationService.getCustomScriptConfigurationByName(acrValues);
        if (script != null) {
            Map authenticationMethodClaimsOrNull;
            amrList.add(Integer.toString(script.getLevel()));
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)script.getExternalType();
            int apiVersion = externalAuthenticator.getApiVersion();
            if (apiVersion > 3 && (authenticationMethodClaimsOrNull = externalAuthenticator.getAuthenticationMethodClaims()) != null) {
                for (String key : authenticationMethodClaimsOrNull.keySet()) {
                    amrList.add(key + ":" + (String)authenticationMethodClaimsOrNull.get(key));
                }
            }
        }
        jwt.getClaims().setClaim("amr", (List)amrList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Jwe generateEncryptedIdToken(IAuthorizationGrant authorizationGrant, String nonce, AuthorizationCode authorizationCode, AccessToken accessToken, Set<String> scopes, boolean includeIdTokenClaims, Function<JsonWebResponse, Void> preProcessing) throws Exception {
        Jwe jwe = new Jwe();
        KeyEncryptionAlgorithm keyEncryptionAlgorithm = KeyEncryptionAlgorithm.fromName((String)authorizationGrant.getClient().getIdTokenEncryptedResponseAlg());
        BlockEncryptionAlgorithm blockEncryptionAlgorithm = BlockEncryptionAlgorithm.fromName((String)authorizationGrant.getClient().getIdTokenEncryptedResponseEnc());
        jwe.getHeader().setType(JwtType.JWT);
        jwe.getHeader().setAlgorithm(keyEncryptionAlgorithm);
        jwe.getHeader().setEncryptionMethod(blockEncryptionAlgorithm);
        jwe.getClaims().setIssuer(this.appConfiguration.getIssuer());
        jwe.getClaims().setAudience(authorizationGrant.getClient().getClientId());
        int lifeTime = this.appConfiguration.getIdTokenLifetime();
        Calendar calendar = Calendar.getInstance();
        Date issuedAt = calendar.getTime();
        calendar.add(13, lifeTime);
        Date expiration = calendar.getTime();
        jwe.getClaims().setExpirationTime(expiration);
        jwe.getClaims().setIssuedAt(issuedAt);
        if (preProcessing != null) {
            preProcessing.apply((Object)jwe);
        }
        if (authorizationGrant.getAcrValues() != null) {
            jwe.getClaims().setClaim("acr", authorizationGrant.getAcrValues());
            this.setAmrClaim((JsonWebResponse)jwe, authorizationGrant.getAcrValues());
        }
        if (StringUtils.isNotBlank((String)nonce)) {
            jwe.getClaims().setClaim("nonce", nonce);
        }
        if (authorizationGrant.getAuthenticationTime() != null) {
            jwe.getClaims().setClaim("auth_time", authorizationGrant.getAuthenticationTime());
        }
        if (authorizationCode != null) {
            String codeHash = authorizationCode.getHash(null);
            jwe.getClaims().setClaim("c_hash", codeHash);
        }
        if (accessToken != null) {
            String accessTokenHash = accessToken.getHash(null);
            jwe.getClaims().setClaim("at_hash", accessTokenHash);
        }
        jwe.getClaims().setClaim("oxOpenIDConnectVersion", this.appConfiguration.getOxOpenIdConnectVersion());
        ArrayList dynamicScopes = Lists.newArrayList();
        if (includeIdTokenClaims && authorizationGrant.getClient().isIncludeClaimsInIdToken()) {
            for (String scopeName : scopes) {
                Scope scope = this.scopeService.getScopeByDisplayName(scopeName);
                if (ScopeType.DYNAMIC == scope.getScopeType()) {
                    dynamicScopes.add(scope);
                    continue;
                }
                if (scope == null || scope.getOxAuthClaims() == null) continue;
                for (String claimDn : scope.getOxAuthClaims()) {
                    Object attributeValue;
                    GluuAttribute gluuAttribute = this.attributeService.getAttributeByDn(claimDn);
                    String claimName = gluuAttribute.getOxAuthClaimName();
                    String ldapName = gluuAttribute.getName();
                    if (!StringUtils.isNotBlank((String)claimName) || !StringUtils.isNotBlank((String)ldapName) || (attributeValue = ldapName.equals("uid") ? authorizationGrant.getUser().getUserId() : authorizationGrant.getUser().getAttribute(gluuAttribute.getName(), true)) == null) continue;
                    if (attributeValue instanceof JSONArray) {
                        JSONArray jsonArray = (JSONArray)attributeValue;
                        ArrayList<String> values = new ArrayList<String>();
                        for (int i = 0; i < jsonArray.length(); ++i) {
                            String value = jsonArray.optString(i);
                            if (value == null) continue;
                            values.add(value);
                        }
                        jwe.getClaims().setClaim(claimName, values);
                        continue;
                    }
                    String value = attributeValue.toString();
                    jwe.getClaims().setClaim(claimName, value);
                }
            }
        }
        if (authorizationGrant.getJwtAuthorizationRequest() != null && authorizationGrant.getJwtAuthorizationRequest().getIdTokenMember() != null) {
            for (Claim claim : authorizationGrant.getJwtAuthorizationRequest().getIdTokenMember().getClaims()) {
                Client client;
                boolean optional = true;
                GluuAttribute gluuAttribute = this.attributeService.getByClaimName(claim.getName());
                if (gluuAttribute == null || !this.validateRequesteClaim(gluuAttribute, (client = authorizationGrant.getClient()).getClaims(), scopes)) continue;
                String ldapClaimName = gluuAttribute.getName();
                Object attribute = authorizationGrant.getUser().getAttribute(ldapClaimName, optional);
                if (attribute == null) continue;
                if (attribute instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)attribute;
                    ArrayList<String> values = new ArrayList<String>();
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        String value = jsonArray.optString(i);
                        if (value == null) continue;
                        values.add(value);
                    }
                    jwe.getClaims().setClaim(claim.getName(), values);
                    continue;
                }
                String value = attribute.toString();
                jwe.getClaims().setClaim(claim.getName(), value);
            }
        }
        if (authorizationGrant.getClient().getSubjectType() != null && SubjectType.fromString((String)authorizationGrant.getClient().getSubjectType()).equals((Object)SubjectType.PAIRWISE)) {
            String clientId;
            String sectorIdentifierUri = StringUtils.isNotBlank((String)authorizationGrant.getClient().getSectorIdentifierUri()) ? authorizationGrant.getClient().getSectorIdentifierUri() : authorizationGrant.getClient().getRedirectUris()[0];
            String userInum = authorizationGrant.getUser().getAttribute("inum");
            PairwiseIdentifier pairwiseIdentifier = this.pairwiseIdentifierService.findPairWiseIdentifier(userInum, sectorIdentifierUri, clientId = authorizationGrant.getClientId());
            if (pairwiseIdentifier == null) {
                pairwiseIdentifier = new PairwiseIdentifier(sectorIdentifierUri, clientId);
                pairwiseIdentifier.setId(UUID.randomUUID().toString());
                pairwiseIdentifier.setDn(this.pairwiseIdentifierService.getDnForPairwiseIdentifier(pairwiseIdentifier.getId(), userInum));
                this.pairwiseIdentifierService.addPairwiseIdentifier(userInum, pairwiseIdentifier);
            }
            jwe.getClaims().setSubjectIdentifier(pairwiseIdentifier.getId());
        } else {
            String openidSubAttribute = this.appConfiguration.getOpenidSubAttribute();
            if (openidSubAttribute.equals("uid")) {
                jwe.getClaims().setSubjectIdentifier(authorizationGrant.getUser().getUserId());
            } else {
                jwe.getClaims().setSubjectIdentifier(authorizationGrant.getUser().getAttribute(openidSubAttribute));
            }
        }
        if (dynamicScopes.size() > 0 && this.externalDynamicScopeService.isEnabled()) {
            UnmodifiableAuthorizationGrant unmodifiableAuthorizationGrant = new UnmodifiableAuthorizationGrant(authorizationGrant);
            DynamicScopeExternalContext dynamicScopeContext = new DynamicScopeExternalContext(dynamicScopes, (JsonWebResponse)jwe, unmodifiableAuthorizationGrant);
            this.externalDynamicScopeService.executeExternalUpdateMethods(dynamicScopeContext);
        }
        if (keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA_OAEP || keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA1_5) {
            JSONObject jsonWebKeys = JwtUtil.getJSONWebKeys((String)authorizationGrant.getClient().getJwksUri());
            AbstractCryptoProvider cryptoProvider = CryptoProviderFactory.getCryptoProvider((AppConfiguration)this.appConfiguration);
            String keyId = cryptoProvider.getKeyId(JSONWebKeySet.fromJSONObject((JSONObject)jsonWebKeys), Algorithm.fromString((String)keyEncryptionAlgorithm.getName()), Use.ENCRYPTION);
            PublicKey publicKey = cryptoProvider.getPublicKey(keyId, jsonWebKeys);
            jwe.getHeader().setKeyId(keyId);
            if (publicKey == null) throw new InvalidJweException("The public key is not valid");
            JweEncrypterImpl jweEncrypter = new JweEncrypterImpl(keyEncryptionAlgorithm, blockEncryptionAlgorithm, publicKey);
            return jweEncrypter.encrypt(jwe);
        }
        if (keyEncryptionAlgorithm != KeyEncryptionAlgorithm.A128KW) {
            if (keyEncryptionAlgorithm != KeyEncryptionAlgorithm.A256KW) return jwe;
        }
        try {
            byte[] sharedSymmetricKey = this.clientService.decryptSecret(authorizationGrant.getClient().getClientSecret()).getBytes("UTF-8");
            JweEncrypterImpl jweEncrypter = new JweEncrypterImpl(keyEncryptionAlgorithm, blockEncryptionAlgorithm, sharedSymmetricKey);
            return jweEncrypter.encrypt(jwe);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidJweException((Throwable)e);
        }
        catch (StringEncrypter.EncryptionException e) {
            throw new InvalidJweException((Throwable)e);
        }
        catch (Exception e) {
            throw new InvalidJweException((Throwable)e);
        }
    }

    public JsonWebResponse createJwr(IAuthorizationGrant grant, String nonce, AuthorizationCode authorizationCode, AccessToken accessToken, Set<String> scopes, boolean includeIdTokenClaims, Function<JsonWebResponse, Void> preProcessing) throws Exception {
        Client grantClient = grant.getClient();
        if (grantClient != null && grantClient.getIdTokenEncryptedResponseAlg() != null && grantClient.getIdTokenEncryptedResponseEnc() != null) {
            return this.generateEncryptedIdToken(grant, nonce, authorizationCode, accessToken, scopes, includeIdTokenClaims, preProcessing);
        }
        return this.generateSignedIdToken(grant, nonce, authorizationCode, accessToken, scopes, includeIdTokenClaims, preProcessing);
    }

    public boolean validateRequesteClaim(GluuAttribute gluuAttribute, String[] clientAllowedClaims, Collection<String> scopes) {
        if (gluuAttribute != null) {
            if (clientAllowedClaims != null) {
                for (int i = 0; i < clientAllowedClaims.length; ++i) {
                    if (!gluuAttribute.getDn().equals(clientAllowedClaims[i])) continue;
                    return true;
                }
            }
            for (String scopeName : scopes) {
                Scope scope = this.scopeService.getScopeByDisplayName(scopeName);
                if (scope == null || scope.getOxAuthClaims() == null) continue;
                for (String claimDn : scope.getOxAuthClaims()) {
                    if (!gluuAttribute.getDisplayName().equals(this.attributeService.getAttributeByDn(claimDn).getDisplayName())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

