/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.registration;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.slf4j.Logger;
import org.xdi.oxauth.model.common.SubjectType;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterErrorResponseType;
import org.xdi.oxauth.model.util.URLPatternList;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.util.ServerUtil;

@Stateless
@Named
public class RegisterParamsValidator {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String LOCALHOST = "localhost";
    private static final String LOOPBACK = "127.0.0.1";

    public boolean validateParamsClientRegister(ApplicationType applicationType, SubjectType subjectType, List<String> redirectUris, String sectorIdentifierUrl) {
        boolean valid;
        boolean bl = valid = applicationType != null && redirectUris != null && !redirectUris.isEmpty();
        if (subjectType == null || !this.appConfiguration.getSubjectTypesSupported().contains(subjectType.toString())) {
            this.log.debug("Parameter subject_type is not valid.");
            valid = false;
        }
        return valid;
    }

    public boolean validateParamsClientRead(String clientId, String accessToken) {
        return StringUtils.isNotBlank((String)clientId) && StringUtils.isNotBlank((String)accessToken);
    }

    public boolean validateRedirectUris(ApplicationType applicationType, SubjectType subjectType, List<String> redirectUris, String sectorIdentifierUrl) {
        boolean valid = true;
        HashSet<String> redirectUriHosts = new HashSet<String>();
        try {
            if (redirectUris != null && !redirectUris.isEmpty()) {
                for (String redirectUri : redirectUris) {
                    if (redirectUri == null || redirectUri.contains("#")) {
                        valid = false;
                        continue;
                    }
                    URI uri = new URI(redirectUri);
                    redirectUriHosts.add(uri.getHost());
                    switch (applicationType) {
                        case WEB: {
                            if (!HTTP.equalsIgnoreCase(uri.getScheme()) || LOCALHOST.equalsIgnoreCase(uri.getHost()) || LOOPBACK.equalsIgnoreCase(uri.getHost())) break;
                            this.log.error("Invalid protocol for redirect_uri: " + redirectUri + " (only https protocol is allowed for application_type=web or localhost/127.0.0.1 for http)");
                            valid = false;
                            break;
                        }
                    }
                }
            } else {
                valid = false;
            }
        }
        catch (URISyntaxException e) {
            valid = false;
        }
        if (subjectType != null && subjectType.equals((Object)SubjectType.PAIRWISE) && StringUtils.isBlank((String)sectorIdentifierUrl) && redirectUriHosts.size() > 1) {
            valid = false;
        }
        if (valid && StringUtils.isNotBlank((String)sectorIdentifierUrl)) {
            try {
                URI uri = new URI(sectorIdentifierUrl);
                if (!HTTPS.equalsIgnoreCase(uri.getScheme())) {
                    valid = false;
                }
                ClientRequest clientRequest = new ClientRequest(sectorIdentifierUrl);
                clientRequest.setHttpMethod("GET");
                ClientResponse clientResponse = clientRequest.get(String.class);
                int status = clientResponse.getStatus();
                if (status == 200) {
                    String entity = (String)clientResponse.getEntity(String.class);
                    JSONArray sectorIdentifierJsonArray = new JSONArray(entity);
                    valid = Util.asList((JSONArray)sectorIdentifierJsonArray).containsAll(redirectUris);
                }
            }
            catch (Exception e) {
                this.log.trace(e.getMessage(), (Throwable)e);
                valid = false;
            }
        }
        if (valid) {
            valid = this.checkWhiteListRedirectUris(redirectUris) && this.checkBlackListRedirectUris(redirectUris);
        }
        return valid;
    }

    private boolean checkWhiteListRedirectUris(List<String> redirectUris) {
        boolean valid = true;
        List whiteList = this.appConfiguration.getClientWhiteList();
        URLPatternList urlPatternList = new URLPatternList(whiteList);
        for (String redirectUri : redirectUris) {
            valid &= urlPatternList.isUrlListed(redirectUri);
        }
        return valid;
    }

    private boolean checkBlackListRedirectUris(List<String> redirectUris) {
        boolean valid = true;
        List blackList = this.appConfiguration.getClientBlackList();
        URLPatternList urlPatternList = new URLPatternList(blackList);
        for (String redirectUri : redirectUris) {
            valid &= !urlPatternList.isUrlListed(redirectUri);
        }
        return valid;
    }

    public void validateLogoutUri(List<String> logoutUris, List<String> redirectUris, ErrorResponseFactory errorResponseFactory) {
        if (logoutUris == null || logoutUris.isEmpty()) {
            return;
        }
        for (String logoutUri : logoutUris) {
            this.validateLogoutUri(logoutUri, redirectUris, errorResponseFactory);
        }
    }

    public void validateLogoutUri(String logoutUri, List<String> redirectUris, ErrorResponseFactory errorResponseFactory) {
        if (Util.isNullOrEmpty((String)logoutUri)) {
            return;
        }
        if (redirectUris == null || redirectUris.isEmpty()) {
            this.log.error("Preconditions of logout uri validation are failed.");
            this.throwInvalidLogoutUri(errorResponseFactory);
            return;
        }
        try {
            Set<String> redirectUriHosts = this.collectUriHosts(redirectUris);
            URI uri = new URI(logoutUri);
            if (!redirectUriHosts.contains(uri.getHost())) {
                this.log.error("logout uri host is not within redirect_uris, logout_uri: {}, redirect_uris: {}", (Object)logoutUri, redirectUris);
                this.throwInvalidLogoutUri(errorResponseFactory);
                return;
            }
            if (!HTTPS.equalsIgnoreCase(uri.getScheme())) {
                this.log.error("logout uri schema is not https, logout_uri: {}", (Object)logoutUri);
                this.throwInvalidLogoutUri(errorResponseFactory);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.throwInvalidLogoutUri(errorResponseFactory);
        }
    }

    private void throwInvalidLogoutUri(ErrorResponseFactory errorResponseFactory) throws WebApplicationException {
        throw new WebApplicationException(Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).entity((Object)errorResponseFactory.getErrorAsJson((IErrorType)RegisterErrorResponseType.INVALID_LOGOUT_URI)).cacheControl(ServerUtil.cacheControl(true, false)).header("Pragma", (Object)"no-cache").build());
    }

    private Set<String> collectUriHosts(List<String> uriList) throws URISyntaxException {
        HashSet<String> hosts = new HashSet<String>();
        for (String redirectUri : uriList) {
            URI uri = new URI(redirectUri);
            hosts.add(uri.getHost());
        }
        return hosts;
    }
}

