/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.registration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapAttributesList;
import org.gluu.site.ldap.persistence.annotation.LdapCustomObjectClass;
import org.gluu.site.ldap.persistence.annotation.LdapDN;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;
import org.xdi.ldap.model.CustomAttribute;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.util.LdapUtils;

@LdapEntry
@LdapObjectClass(values={"top", "oxAuthClient"})
public class Client
implements Serializable {
    @LdapDN
    private String dn;
    @LdapAttribute(name="inum")
    private String clientId;
    @LdapAttribute(name="oxAuthClientSecret")
    private String encodedClientSecret;
    @LdapAttribute(name="oxAuthLogoutURI")
    private String[] frontChannelLogoutUri;
    @LdapAttribute(name="oxAuthLogoutSessionRequired")
    private Boolean frontChannelLogoutSessionRequired;
    @LdapAttribute(name="oxAuthRegistrationAccessToken")
    private String registrationAccessToken;
    @LdapAttribute(name="oxAuthClientIdIssuedAt")
    private Date clientIdIssuedAt;
    @LdapAttribute(name="oxAuthClientSecretExpiresAt")
    private Date clientSecretExpiresAt;
    @LdapAttribute(name="oxAuthRedirectURI")
    private String[] redirectUris;
    @LdapAttribute(name="oxClaimRedirectURI")
    private String[] claimRedirectUris;
    @LdapAttribute(name="oxAuthResponseType")
    private ResponseType[] responseTypes;
    @LdapAttribute(name="oxAuthGrantType")
    private GrantType[] grantTypes;
    @LdapAttribute(name="oxAuthAppType")
    private String applicationType;
    @LdapAttribute(name="oxAuthContact")
    private String[] contacts;
    @LdapAttribute(name="displayName")
    private String clientName;
    @LdapAttribute(name="oxIdTokenTokenBindingCnf")
    private String idTokenTokenBindingCnf;
    @LdapAttribute(name="oxAuthLogoURI")
    private String logoUri;
    @LdapAttribute(name="oxAuthClientURI")
    private String clientUri;
    @LdapAttribute(name="oxAuthPolicyURI")
    private String policyUri;
    @LdapAttribute(name="oxAuthTosURI")
    private String tosUri;
    @LdapAttribute(name="oxAuthJwksURI")
    private String jwksUri;
    @LdapAttribute(name="oxAuthJwks")
    private String jwks;
    @LdapAttribute(name="oxAuthSectorIdentifierURI")
    private String sectorIdentifierUri;
    @LdapAttribute(name="oxAuthSubjectType")
    private String subjectType;
    @LdapAttribute(name="oxAuthIdTokenSignedResponseAlg")
    private String idTokenSignedResponseAlg;
    @LdapAttribute(name="oxAuthIdTokenEncryptedResponseAlg")
    private String idTokenEncryptedResponseAlg;
    @LdapAttribute(name="oxAuthIdTokenEncryptedResponseEnc")
    private String idTokenEncryptedResponseEnc;
    @LdapAttribute(name="oxAuthSignedResponseAlg")
    private String userInfoSignedResponseAlg;
    @LdapAttribute(name="oxAuthUserInfoEncryptedResponseAlg")
    private String userInfoEncryptedResponseAlg;
    @LdapAttribute(name="oxAuthUserInfoEncryptedResponseEnc")
    private String userInfoEncryptedResponseEnc;
    @LdapAttribute(name="oxAuthRequestObjectSigningAlg")
    private String requestObjectSigningAlg;
    @LdapAttribute(name="oxAuthRequestObjectEncryptionAlg")
    private String requestObjectEncryptionAlg;
    @LdapAttribute(name="oxAuthRequestObjectEncryptionEnc")
    private String requestObjectEncryptionEnc;
    @LdapAttribute(name="oxAuthTokenEndpointAuthMethod")
    private String tokenEndpointAuthMethod;
    @LdapAttribute(name="oxAuthTokenEndpointAuthSigningAlg")
    private String tokenEndpointAuthSigningAlg;
    @LdapAttribute(name="oxAuthDefaultMaxAge")
    private Integer defaultMaxAge;
    @LdapAttribute(name="oxAuthRequireAuthTime")
    private boolean requireAuthTime;
    @LdapAttribute(name="oxAuthDefaultAcrValues")
    private String[] defaultAcrValues;
    @LdapAttribute(name="oxAuthInitiateLoginURI")
    private String initiateLoginUri;
    @LdapAttribute(name="oxAuthPostLogoutRedirectURI")
    private String[] postLogoutRedirectUris;
    @LdapAttribute(name="oxAuthRequestURI")
    private String[] requestUris;
    @LdapAttribute(name="oxAuthScope")
    private String[] scopes;
    @LdapAttribute(name="oxAuthClaim")
    private String[] claims;
    @LdapAttribute(name="oxAuthTrustedClient")
    private boolean trustedClient;
    @LdapAttribute(name="oxAuthClientUserGroup")
    private String[] userGroups;
    @LdapAttribute(name="oxLastAccessTime")
    private Date lastAccessTime;
    @LdapAttribute(name="oxLastLogonTime")
    private Date lastLogonTime;
    @LdapAttribute(name="oxPersistClientAuthorizations")
    private boolean persistClientAuthorizations;
    @LdapAttribute(name="oxIncludeClaimsInIdToken")
    private boolean includeClaimsInIdToken;
    @LdapAttribute(name="oxRefreshTokenLifetime")
    private Integer refreshTokenLifetime;
    @LdapAttribute(name="oxAccessTokenLifetime")
    private Integer accessTokenLifetime;
    @LdapAttributesList(name="name", value="values", sortByName=true)
    private List<CustomAttribute> customAttributes = new ArrayList<CustomAttribute>();
    @LdapCustomObjectClass
    private String[] customObjectClasses;
    @LdapAttribute(name="oxRptAsJwt")
    private boolean rptAsJwt = false;
    @LdapAttribute(name="oxAccessTokenAsJwt")
    private boolean accessTokenAsJwt = false;
    @LdapAttribute(name="oxAccessTokenSigningAlg")
    private String accessTokenSigningAlg;
    @LdapAttribute(name="oxDisabled")
    private boolean disabled;
    @LdapAttribute(name="oxAuthAuthorizedOrigins")
    private String[] authorizedOrigins;
    @LdapAttribute(name="oxSoftwareId")
    private String softwareId;
    @LdapAttribute(name="oxSoftwareVersion")
    private String softwareVersion;
    @LdapAttribute(name="oxSoftwareStatement")
    private String softwareStatement;

    public boolean isRptAsJwt() {
        return this.rptAsJwt;
    }

    public void setRptAsJwt(boolean rptAsJwt) {
        this.rptAsJwt = rptAsJwt;
    }

    public boolean isAccessTokenAsJwt() {
        return this.accessTokenAsJwt;
    }

    public void setAccessTokenAsJwt(boolean accessTokenAsJwt) {
        this.accessTokenAsJwt = accessTokenAsJwt;
    }

    public String getAccessTokenSigningAlg() {
        return this.accessTokenSigningAlg;
    }

    public void setAccessTokenSigningAlg(String accessTokenSigningAlg) {
        this.accessTokenSigningAlg = accessTokenSigningAlg;
    }

    public AuthenticationMethod getAuthenticationMethod() {
        return AuthenticationMethod.fromString((String)this.tokenEndpointAuthMethod);
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public Boolean getFrontChannelLogoutSessionRequired() {
        return this.frontChannelLogoutSessionRequired;
    }

    public void setFrontChannelLogoutSessionRequired(Boolean frontChannelLogoutSessionRequired) {
        this.frontChannelLogoutSessionRequired = frontChannelLogoutSessionRequired;
    }

    public String[] getFrontChannelLogoutUri() {
        return this.frontChannelLogoutUri;
    }

    public void setFrontChannelLogoutUri(String[] frontChannelLogoutUri) {
        this.frontChannelLogoutUri = frontChannelLogoutUri;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getEncodedClientSecret() {
        return this.encodedClientSecret;
    }

    public void setEncodedClientSecret(String encodedClientSecret) {
        this.encodedClientSecret = encodedClientSecret;
    }

    public String getClientSecret() {
        return this.encodedClientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.encodedClientSecret = clientSecret;
    }

    public String getRegistrationAccessToken() {
        return this.registrationAccessToken;
    }

    public void setRegistrationAccessToken(String registrationAccessToken) {
        this.registrationAccessToken = registrationAccessToken;
    }

    public Date getClientIdIssuedAt() {
        return this.clientIdIssuedAt;
    }

    public void setClientIdIssuedAt(Date clientIdIssuedAt) {
        this.clientIdIssuedAt = clientIdIssuedAt;
    }

    public Date getClientSecretExpiresAt() {
        return this.clientSecretExpiresAt != null ? new Date(this.clientSecretExpiresAt.getTime()) : null;
    }

    public void setClientSecretExpiresAt(Date clientSecretExpiresAt) {
        this.clientSecretExpiresAt = clientSecretExpiresAt != null ? new Date(clientSecretExpiresAt.getTime()) : null;
    }

    public String[] getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(String[] redirectUris) {
        this.redirectUris = redirectUris;
    }

    public String[] getClaimRedirectUris() {
        return this.claimRedirectUris;
    }

    public void setClaimRedirectUris(String[] claimRedirectUris) {
        this.claimRedirectUris = claimRedirectUris;
    }

    public ResponseType[] getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(ResponseType[] responseTypes) {
        this.responseTypes = responseTypes;
    }

    public GrantType[] getGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(GrantType[] grantTypes) {
        this.grantTypes = grantTypes;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    public String[] getContacts() {
        return this.contacts;
    }

    public void setContacts(String[] contacts) {
        this.contacts = contacts;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getIdTokenTokenBindingCnf() {
        return this.idTokenTokenBindingCnf;
    }

    public void setIdTokenTokenBindingCnf(String idTokenTokenBindingCnf) {
        this.idTokenTokenBindingCnf = idTokenTokenBindingCnf;
    }

    public boolean isTokenBindingSupported() {
        return StringUtils.isNotBlank((String)this.idTokenTokenBindingCnf);
    }

    public String getLogoUri() {
        return this.logoUri;
    }

    public void setLogoUri(String logoUri) {
        this.logoUri = logoUri;
    }

    public String getClientUri() {
        return this.clientUri;
    }

    public void setClientUri(String clientUri) {
        this.clientUri = clientUri;
    }

    public String getPolicyUri() {
        return this.policyUri;
    }

    public void setPolicyUri(String policyUri) {
        this.policyUri = policyUri;
    }

    public String getTosUri() {
        return this.tosUri;
    }

    public void setTosUri(String tosUri) {
        this.tosUri = tosUri;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public String getJwks() {
        return this.jwks;
    }

    public void setJwks(String jwks) {
        this.jwks = jwks;
    }

    public String getSectorIdentifierUri() {
        return this.sectorIdentifierUri;
    }

    public void setSectorIdentifierUri(String sectorIdentifierUri) {
        this.sectorIdentifierUri = sectorIdentifierUri;
    }

    public String getSubjectType() {
        return this.subjectType;
    }

    public void setSubjectType(String subjectType) {
        this.subjectType = subjectType;
    }

    public String getIdTokenSignedResponseAlg() {
        return this.idTokenSignedResponseAlg;
    }

    public void setIdTokenSignedResponseAlg(String idTokenSignedResponseAlg) {
        this.idTokenSignedResponseAlg = idTokenSignedResponseAlg;
    }

    public String getIdTokenEncryptedResponseAlg() {
        return this.idTokenEncryptedResponseAlg;
    }

    public void setIdTokenEncryptedResponseAlg(String idTokenEncryptedResponseAlg) {
        this.idTokenEncryptedResponseAlg = idTokenEncryptedResponseAlg;
    }

    public String getIdTokenEncryptedResponseEnc() {
        return this.idTokenEncryptedResponseEnc;
    }

    public void setIdTokenEncryptedResponseEnc(String idTokenEncryptedResponseEnc) {
        this.idTokenEncryptedResponseEnc = idTokenEncryptedResponseEnc;
    }

    public String getUserInfoSignedResponseAlg() {
        return this.userInfoSignedResponseAlg;
    }

    public void setUserInfoSignedResponseAlg(String userInfoSignedResponseAlg) {
        this.userInfoSignedResponseAlg = userInfoSignedResponseAlg;
    }

    public String getUserInfoEncryptedResponseAlg() {
        return this.userInfoEncryptedResponseAlg;
    }

    public void setUserInfoEncryptedResponseAlg(String userInfoEncryptedResponseAlg) {
        this.userInfoEncryptedResponseAlg = userInfoEncryptedResponseAlg;
    }

    public String getUserInfoEncryptedResponseEnc() {
        return this.userInfoEncryptedResponseEnc;
    }

    public void setUserInfoEncryptedResponseEnc(String userInfoEncryptedResponseEnc) {
        this.userInfoEncryptedResponseEnc = userInfoEncryptedResponseEnc;
    }

    public String getRequestObjectSigningAlg() {
        return this.requestObjectSigningAlg;
    }

    public void setRequestObjectSigningAlg(String requestObjectSigningAlg) {
        this.requestObjectSigningAlg = requestObjectSigningAlg;
    }

    public String getRequestObjectEncryptionAlg() {
        return this.requestObjectEncryptionAlg;
    }

    public void setRequestObjectEncryptionAlg(String requestObjectEncryptionAlg) {
        this.requestObjectEncryptionAlg = requestObjectEncryptionAlg;
    }

    public String getRequestObjectEncryptionEnc() {
        return this.requestObjectEncryptionEnc;
    }

    public void setRequestObjectEncryptionEnc(String requestObjectEncryptionEnc) {
        this.requestObjectEncryptionEnc = requestObjectEncryptionEnc;
    }

    public String getTokenEndpointAuthMethod() {
        return this.tokenEndpointAuthMethod;
    }

    public void setTokenEndpointAuthMethod(String tokenEndpointAuthMethod) {
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
    }

    public String getTokenEndpointAuthSigningAlg() {
        return this.tokenEndpointAuthSigningAlg;
    }

    public void setTokenEndpointAuthSigningAlg(String tokenEndpointAuthSigningAlg) {
        this.tokenEndpointAuthSigningAlg = tokenEndpointAuthSigningAlg;
    }

    public Integer getDefaultMaxAge() {
        return this.defaultMaxAge;
    }

    public void setDefaultMaxAge(Integer defaultMaxAge) {
        this.defaultMaxAge = defaultMaxAge;
    }

    public boolean getRequireAuthTime() {
        return this.requireAuthTime;
    }

    public void setRequireAuthTime(boolean requireAuthTime) {
        this.requireAuthTime = requireAuthTime;
    }

    public String[] getDefaultAcrValues() {
        return this.defaultAcrValues;
    }

    public void setDefaultAcrValues(String[] defaultAcrValues) {
        this.defaultAcrValues = defaultAcrValues;
    }

    public String getInitiateLoginUri() {
        return this.initiateLoginUri;
    }

    public void setInitiateLoginUri(String initiateLoginUri) {
        this.initiateLoginUri = initiateLoginUri;
    }

    public String[] getPostLogoutRedirectUris() {
        return this.postLogoutRedirectUris;
    }

    public void setPostLogoutRedirectUris(String[] postLogoutRedirectUris) {
        this.postLogoutRedirectUris = postLogoutRedirectUris;
    }

    public String[] getRequestUris() {
        return this.requestUris;
    }

    public void setRequestUris(String[] requestUris) {
        this.requestUris = requestUris;
    }

    public String[] getScopes() {
        return this.scopes;
    }

    public void setScopes(String[] scopes) {
        this.scopes = scopes;
    }

    public String[] getClaims() {
        return this.claims;
    }

    public void setClaims(String[] claims) {
        this.claims = claims;
    }

    public boolean getTrustedClient() {
        return this.trustedClient;
    }

    public void setTrustedClient(boolean trustedClient) {
        this.trustedClient = trustedClient;
    }

    public String[] getUserGroups() {
        return this.userGroups;
    }

    public void setUserGroups(String[] p_userGroups) {
        if (LdapUtils.isValidDNs(p_userGroups)) {
            this.userGroups = p_userGroups;
        }
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public Date getLastLogonTime() {
        return this.lastLogonTime;
    }

    public void setLastLogonTime(Date lastLogonTime) {
        this.lastLogonTime = lastLogonTime;
    }

    public boolean getPersistClientAuthorizations() {
        return this.persistClientAuthorizations;
    }

    public void setPersistClientAuthorizations(boolean persistClientAuthorizations) {
        this.persistClientAuthorizations = persistClientAuthorizations;
    }

    public boolean isIncludeClaimsInIdToken() {
        return this.includeClaimsInIdToken;
    }

    public void setIncludeClaimsInIdToken(boolean includeClaimsInIdToken) {
        this.includeClaimsInIdToken = includeClaimsInIdToken;
    }

    public Integer getRefreshTokenLifetime() {
        return this.refreshTokenLifetime;
    }

    public void setRefreshTokenLifetime(Integer refreshTokenLifetime) {
        this.refreshTokenLifetime = refreshTokenLifetime;
    }

    public Integer getAccessTokenLifetime() {
        return this.accessTokenLifetime;
    }

    public void setAccessTokenLifetime(Integer accessTokenLifetime) {
        this.accessTokenLifetime = accessTokenLifetime;
    }

    public List<CustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(List<CustomAttribute> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public String[] getCustomObjectClasses() {
        return this.customObjectClasses;
    }

    public void setCustomObjectClasses(String[] p_customObjectClasses) {
        this.customObjectClasses = p_customObjectClasses;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String[] getAuthorizedOrigins() {
        return this.authorizedOrigins;
    }

    public void setAuthorizedOrigins(String[] authorizedOrigins) {
        this.authorizedOrigins = authorizedOrigins;
    }

    public String getSoftwareId() {
        return this.softwareId;
    }

    public void setSoftwareId(String softwareId) {
        this.softwareId = softwareId;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public String getSoftwareStatement() {
        return this.softwareStatement;
    }

    public void setSoftwareStatement(String softwareStatement) {
        this.softwareStatement = softwareStatement;
    }

    public static Client instance() {
        return new Client();
    }

    public boolean hasUserGroups() {
        return !ArrayUtils.isEmpty((Object[])this.userGroups);
    }
}

