/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.ldap;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapDN;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.ldap.TokenType;

@LdapEntry
@LdapObjectClass(values={"top", "oxAuthToken"})
public class TokenLdap
implements Serializable {
    @LdapDN
    private String dn;
    @LdapAttribute(name="uniqueIdentifier")
    private String id;
    @LdapAttribute(name="oxAuthGrantId")
    private String grantId;
    @LdapAttribute(name="oxAuthUserId")
    private String userId;
    @LdapAttribute(name="oxAuthClientId")
    private String clientId;
    @LdapAttribute(name="oxAuthCreation")
    private Date creationDate;
    @LdapAttribute(name="oxAuthExpiration")
    private Date expirationDate;
    @LdapAttribute(name="oxAuthAuthenticationTime")
    private Date authenticationTime;
    @LdapAttribute(name="oxAuthScope")
    private String scope;
    @LdapAttribute(name="oxAuthTokenCode")
    private String tokenCode;
    @LdapAttribute(name="oxAuthTokenType")
    private String tokenType;
    @LdapAttribute(name="oxAuthGrantType")
    private String grantType;
    @LdapAttribute(name="oxAuthJwtRequest")
    private String jwtRequest;
    @LdapAttribute(name="oxAuthAuthorizationCode")
    private String authorizationCode;
    @LdapAttribute(name="oxAuthNonce")
    private String nonce;
    @LdapAttribute(name="oxCodeChallenge")
    private String codeChallenge;
    @LdapAttribute(name="oxCodeChallengeMethod")
    private String codeChallengeMethod;
    @LdapAttribute(name="oxAuthClaims")
    private String claims;
    @LdapAttribute(name="oxIdTokenTokenBindingCnf")
    private String tokenBindingHash;
    @LdapAttribute(name="oxAuthenticationMode")
    private String authMode;
    @LdapAttribute(name="oxAuthSessionDn")
    private String sessionDn;
    private boolean isFromCache;

    public String getId() {
        return this.id;
    }

    public void setId(String p_id) {
        this.id = p_id;
    }

    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    public void setAuthorizationCode(String p_authorizationCode) {
        this.authorizationCode = p_authorizationCode;
    }

    public String getTokenBindingHash() {
        return this.tokenBindingHash;
    }

    public void setTokenBindingHash(String tokenBindingHash) {
        this.tokenBindingHash = tokenBindingHash;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getGrantId() {
        return this.grantId;
    }

    public void setGrantId(String p_grantId) {
        this.grantId = p_grantId;
    }

    public Date getAuthenticationTime() {
        return this.authenticationTime;
    }

    public void setAuthenticationTime(Date p_authenticationTime) {
        this.authenticationTime = p_authenticationTime;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date p_creationDate) {
        this.creationDate = p_creationDate;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String p_dn) {
        this.dn = p_dn;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date p_expirationDate) {
        this.expirationDate = p_expirationDate;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public void setGrantType(String p_grantType) {
        this.grantType = p_grantType;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String p_scope) {
        this.scope = p_scope;
    }

    public String getTokenCode() {
        return this.tokenCode;
    }

    public void setTokenCode(String p_tokenCode) {
        this.tokenCode = p_tokenCode;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String p_tokenType) {
        this.tokenType = p_tokenType;
    }

    public TokenType getTokenTypeEnum() {
        return TokenType.fromValue(this.tokenType);
    }

    public void setTokenTypeEnum(TokenType p_tokenType) {
        if (p_tokenType != null) {
            this.tokenType = p_tokenType.getValue();
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String p_userId) {
        this.userId = p_userId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getJwtRequest() {
        return this.jwtRequest;
    }

    public void setJwtRequest(String p_jwtRequest) {
        this.jwtRequest = p_jwtRequest;
    }

    public String getAuthMode() {
        return this.authMode;
    }

    public void setAuthMode(String authMode) {
        this.authMode = authMode;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public void setCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public String getClaims() {
        return this.claims;
    }

    public void setClaims(String claims) {
        this.claims = claims;
    }

    public String getSessionDn() {
        return this.sessionDn;
    }

    public void setSessionDn(String sessionDn) {
        this.sessionDn = sessionDn;
    }

    public boolean isFromCache() {
        return this.isFromCache;
    }

    public void setIsFromCache(boolean isFromCache) {
        this.isFromCache = isFromCache;
    }

    public boolean isImplicitFlow() {
        return StringUtils.isBlank((String)this.grantType) || this.grantType.equals(GrantType.IMPLICIT.getValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenLdap tokenLdap = (TokenLdap)o;
        if (this.tokenCode != null ? !this.tokenCode.equals(tokenLdap.tokenCode) : tokenLdap.tokenCode != null) {
            return false;
        }
        return !(this.tokenType != null ? !this.tokenType.equals(tokenLdap.tokenType) : tokenLdap.tokenType != null);
    }

    public int hashCode() {
        int result = this.tokenCode != null ? this.tokenCode.hashCode() : 0;
        result = 31 * result + (this.tokenType != null ? this.tokenType.hashCode() : 0);
        return result;
    }
}

