/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.fido.u2f;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.xdi.oxauth.crypto.cert.CertificateParser;
import org.xdi.oxauth.model.util.Base64Util;

public class DeviceRegistrationConfiguration {
    @JsonProperty
    public final String publicKey;
    @JsonProperty
    public final String attestationCert;

    public DeviceRegistrationConfiguration(@JsonProperty(value="publicKey") String publicKey, @JsonProperty(value="attestationCert") String attestationCert) {
        this.publicKey = publicKey;
        this.attestationCert = attestationCert;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getAttestationCert() {
        return this.attestationCert;
    }

    @JsonIgnore
    public X509Certificate getAttestationCertificate() throws CertificateException, NoSuchFieldException {
        if (this.attestationCert == null) {
            throw new NoSuchFieldException();
        }
        return CertificateParser.parseDer(Base64Util.base64urldecode((String)this.attestationCert));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DeviceRegistrationConfiguration [publicKey=").append(this.publicKey).append(", attestationCert=").append(this.attestationCert).append("]");
        return builder.toString();
    }
}

