/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.error;

import java.io.IOException;
import java.util.List;
import javax.enterprise.inject.Vetoed;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xdi.oxauth.model.authorize.AuthorizeErrorResponseType;
import org.xdi.oxauth.model.clientinfo.ClientInfoErrorResponseType;
import org.xdi.oxauth.model.configuration.Configuration;
import org.xdi.oxauth.model.error.DefaultErrorResponse;
import org.xdi.oxauth.model.error.ErrorMessage;
import org.xdi.oxauth.model.error.ErrorMessages;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.error.JsonErrorResponse;
import org.xdi.oxauth.model.fido.u2f.U2fErrorResponseType;
import org.xdi.oxauth.model.register.RegisterErrorResponseType;
import org.xdi.oxauth.model.session.EndSessionErrorResponseType;
import org.xdi.oxauth.model.token.TokenErrorResponseType;
import org.xdi.oxauth.model.uma.UmaErrorResponse;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;
import org.xdi.oxauth.model.userinfo.UserInfoErrorResponseType;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.StringHelper;

@Vetoed
public class ErrorResponseFactory
implements Configuration {
    private static Logger log = LoggerFactory.getLogger(ErrorResponseFactory.class);
    private ErrorMessages messages;

    public ErrorResponseFactory() {
    }

    public ErrorResponseFactory(ErrorMessages messages) {
        this.messages = messages;
    }

    public ErrorMessages getMessages() {
        return this.messages;
    }

    public void setMessages(ErrorMessages p_messages) {
        this.messages = p_messages;
    }

    private ErrorMessage getError(List<ErrorMessage> p_list, IErrorType type) {
        log.debug("Looking for the error with id: {}", (Object)type);
        if (p_list != null) {
            for (ErrorMessage error : p_list) {
                if (!error.getId().equals(type.getParameter())) continue;
                log.debug("Found error, id: {}", (Object)type);
                return error;
            }
        }
        log.debug("Error not found, id: {}", (Object)type);
        return null;
    }

    public String getErrorAsJson(IErrorType p_type) {
        return this.getErrorResponse(p_type).toJSonString();
    }

    public String errorAsJson(IErrorType p_type, String reason) {
        DefaultErrorResponse error = this.getErrorResponse(p_type);
        error.setReason(reason);
        return error.toJSonString();
    }

    public void throwUnauthorizedException(IErrorType type) throws WebApplicationException {
        this.throwWebApplicationException(Response.Status.UNAUTHORIZED, type);
    }

    public void throwBadRequestException(IErrorType type) throws WebApplicationException {
        this.throwWebApplicationException(Response.Status.BAD_REQUEST, type);
    }

    public void throwWebApplicationException(Response.Status status, IErrorType type) throws WebApplicationException {
        Response response = Response.status((Response.Status)status).entity((Object)this.getErrorAsJson(type)).build();
        throw new WebApplicationException(response);
    }

    public void throwUmaNotFoundException() throws WebApplicationException {
        this.throwUmaWebApplicationException(Response.Status.NOT_FOUND, (IErrorType)UmaErrorResponseType.NOT_FOUND);
    }

    public void throwUmaInternalErrorException() throws WebApplicationException {
        this.throwUmaWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR);
    }

    public <T> T throwUmaWebApplicationException(Response.Status status, IErrorType type) throws WebApplicationException {
        Response response = Response.status((Response.Status)status).entity((Object)this.getUmaJsonErrorResponse(type)).build();
        throw new WebApplicationException(response);
    }

    public String getErrorAsJson(IErrorType p_type, String p_state) {
        return this.getErrorResponse(p_type, p_state).toJSonString();
    }

    public String getErrorAsQueryString(IErrorType p_type, String p_state) {
        return this.getErrorAsQueryString(p_type, p_state, "");
    }

    public String getErrorAsQueryString(IErrorType p_type, String p_state, String reason) {
        return this.getErrorResponse(p_type, p_state, reason).toQueryString();
    }

    public DefaultErrorResponse getErrorResponse(IErrorType type, String p_state) {
        return this.getErrorResponse(type, p_state, "");
    }

    public DefaultErrorResponse getErrorResponse(IErrorType type, String p_state, String reason) {
        DefaultErrorResponse response = this.getErrorResponse(type);
        response.setState(p_state);
        response.setReason(reason);
        return response;
    }

    public DefaultErrorResponse getErrorResponse(IErrorType type) {
        DefaultErrorResponse response = new DefaultErrorResponse();
        response.setType(type);
        if (type != null && this.messages != null) {
            List<ErrorMessage> list = null;
            if (type instanceof AuthorizeErrorResponseType) {
                list = this.messages.getAuthorize();
            } else if (type instanceof ClientInfoErrorResponseType) {
                list = this.messages.getClientInfo();
            } else if (type instanceof EndSessionErrorResponseType) {
                list = this.messages.getEndSession();
            } else if (type instanceof RegisterErrorResponseType) {
                list = this.messages.getRegister();
            } else if (type instanceof TokenErrorResponseType) {
                list = this.messages.getToken();
            } else if (type instanceof UmaErrorResponseType) {
                list = this.messages.getUma();
            } else if (type instanceof UserInfoErrorResponseType) {
                list = this.messages.getUserInfo();
            } else if (type instanceof U2fErrorResponseType) {
                list = this.messages.getFido();
            }
            if (list != null) {
                ErrorMessage m = this.getError(list, type);
                response.setErrorDescription(m.getDescription());
                response.setErrorUri(m.getUri());
            }
        }
        return response;
    }

    public UmaErrorResponse getUmaErrorResponse(IErrorType type) {
        UmaErrorResponse response = new UmaErrorResponse();
        ErrorMessage errorMessage = this.getError(this.messages.getUma(), type);
        response.setError(errorMessage.getId());
        response.setErrorDescription(errorMessage.getDescription());
        response.setErrorUri(errorMessage.getUri());
        return response;
    }

    public String getUmaJsonErrorResponse(IErrorType type) {
        UmaErrorResponse response = this.getUmaErrorResponse(type);
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("error", (Object)response.getError());
            if (StringHelper.isNotEmpty((String)response.getStatus())) {
                jsonObj.put("status", (Object)response.getStatus());
            }
            if (StringHelper.isNotEmpty((String)response.getErrorDescription())) {
                jsonObj.put("error_description", (Object)response.getErrorDescription());
            }
            if (StringHelper.isNotEmpty((String)response.getErrorUri())) {
                jsonObj.put("error_uri", (Object)response.getErrorUri());
            }
        }
        catch (JSONException ex) {
            log.error("Failed to generate error response", (Throwable)ex);
            return null;
        }
        return jsonObj.toString();
    }

    public String getJsonErrorResponse(IErrorType type) {
        DefaultErrorResponse response = this.getErrorResponse(type);
        JsonErrorResponse jsonErrorResponse = new JsonErrorResponse(response);
        try {
            return ServerUtil.asJson(jsonErrorResponse);
        }
        catch (IOException ex) {
            log.error("Failed to generate error response", (Throwable)ex);
            return null;
        }
    }
}

