/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.config;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jettison.json.JSONObject;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.gluu.site.ldap.persistence.exception.LdapMappingException;
import org.slf4j.Logger;
import org.xdi.exception.ConfigurationException;
import org.xdi.oxauth.model.config.BaseDnConfiguration;
import org.xdi.oxauth.model.config.Conf;
import org.xdi.oxauth.model.config.StaticConfiguration;
import org.xdi.oxauth.model.config.WebKeysConfiguration;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.configuration.Configuration;
import org.xdi.oxauth.model.crypto.AbstractCryptoProvider;
import org.xdi.oxauth.model.error.ErrorMessages;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.service.cdi.async.Asynchronous;
import org.xdi.service.cdi.event.ConfigurationEvent;
import org.xdi.service.cdi.event.ConfigurationUpdate;
import org.xdi.service.cdi.event.LdapConfigurationReload;
import org.xdi.service.cdi.event.Scheduled;
import org.xdi.service.timer.event.TimerEvent;
import org.xdi.service.timer.schedule.TimerSchedule;
import org.xdi.util.StringHelper;
import org.xdi.util.properties.FileConfiguration;

@ApplicationScoped
@Named
public class ConfigurationFactory {
    @Inject
    private Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    private Event<AppConfiguration> configurationUpdateEvent;
    @Inject
    private Event<String> event;
    @Inject
    private Instance<LdapEntryManager> ldapEntryManagerInstance;
    @Inject
    private Instance<Configuration> configurationInstance;
    public static final String LDAP_CONFIGUARION_RELOAD_EVENT_TYPE = "ldapConfigurationReloadEvent";
    private static final int DEFAULT_INTERVAL = 30;
    private static final String BASE_DIR = System.getProperty("gluu.base") != null ? System.getProperty("gluu.base") : (System.getProperty("catalina.base") != null && System.getProperty("catalina.base.ignore") == null ? System.getProperty("catalina.base") : (System.getProperty("catalina.home") != null ? System.getProperty("catalina.home") : (System.getProperty("jboss.home.dir") != null ? System.getProperty("jboss.home.dir") : null)));
    private static final String DIR = BASE_DIR + File.separator + "conf" + File.separator;
    private static final String LDAP_FILE_PATH = DIR + "oxauth-ldap.properties";
    public static final String LDAP_DEFAULT_FILE_PATH = DIR + "ox-ldap.properties";
    private final String CONFIG_FILE_NAME = "oxauth-config.json";
    private final String ERRORS_FILE_NAME = "oxauth-errors.json";
    private final String STATIC_CONF_FILE_NAME = "oxauth-static-conf.json";
    private final String WEB_KEYS_FILE_NAME = "oxauth-web-keys.json";
    private final String SALT_FILE_NAME = "salt";
    private String confDir;
    private String configFilePath;
    private String errorsFilePath;
    private String staticConfFilePath;
    private String webKeysFilePath;
    private String saltFilePath;
    private boolean loaded = false;
    private FileConfiguration ldapConfiguration;
    private AppConfiguration conf;
    private StaticConfiguration staticConf;
    private WebKeysConfiguration jwks;
    private ErrorResponseFactory errorResponseFactory;
    private String cryptoConfigurationSalt;
    private String contextPath;
    private String facesMapping;
    private AtomicBoolean isActive;
    private String prevLdapFileName;
    private long ldapFileLastModifiedTime = -1L;
    private long loadedRevision = -1L;
    private boolean loadedFromLdap = true;

    @PostConstruct
    public void init() {
        this.isActive = new AtomicBoolean(true);
        try {
            String ldapFileName = this.determineLdapConfigurationFileName();
            this.prevLdapFileName = this.loadLdapConfiguration(ldapFileName);
            this.confDir = this.confDir();
            this.configFilePath = this.confDir + "oxauth-config.json";
            this.errorsFilePath = this.confDir + "oxauth-errors.json";
            this.staticConfFilePath = this.confDir + "oxauth-static-conf.json";
            String certsDir = this.getLdapConfiguration().getString("certsDir");
            if (StringHelper.isEmpty((String)certsDir)) {
                certsDir = this.confDir;
            }
            this.webKeysFilePath = certsDir + File.separator + "oxauth-web-keys.json";
            this.saltFilePath = this.confDir + "salt";
            this.loadCryptoConfigurationSalt();
        }
        finally {
            this.isActive.set(false);
        }
    }

    public void onServletContextActivation(@Observes ServletContext context) {
        this.contextPath = context.getContextPath();
        this.facesMapping = "";
        String[] mappings = context.getServletRegistration("Faces Servlet").getMappings().toArray(new String[0]);
        if (mappings.length == 0) {
            return;
        }
        this.facesMapping = mappings[0].replaceAll("\\*", "");
    }

    public void create() {
        if (!this.createFromLdap(true)) {
            this.log.error("Failed to load configuration from LDAP. Please fix it!!!.");
            throw new ConfigurationException("Failed to load configuration from LDAP.");
        }
        this.log.info("Configuration loaded successfully.");
    }

    public void initTimer() {
        this.log.debug("Initializing Configuration Timer");
        int delay = 30;
        int interval = 30;
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(30, 30), (Object)new ConfigurationEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
    }

    @Asynchronous
    public void reloadConfigurationTimerEvent(@Observes @Scheduled ConfigurationEvent configurationEvent) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.reloadConfiguration();
        }
        catch (Throwable ex) {
            this.log.error("Exception happened while reloading application configuration", ex);
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void reloadConfiguration() {
        String ldapFileName = this.determineLdapConfigurationFileName();
        File ldapFile = new File(ldapFileName);
        if (ldapFile.exists()) {
            long lastModified = ldapFile.lastModified();
            if (!StringHelper.equalsIgnoreCase((String)this.prevLdapFileName, (String)ldapFileName) || lastModified > this.ldapFileLastModifiedTime) {
                this.prevLdapFileName = this.loadLdapConfiguration(ldapFileName);
                this.event.select(new Annotation[]{LdapConfigurationReload.Literal.INSTANCE}).fire((Object)LDAP_CONFIGUARION_RELOAD_EVENT_TYPE);
            }
        }
        if (!this.loadedFromLdap) {
            return;
        }
        Conf conf = this.loadConfigurationFromLdap("oxRevision");
        if (conf == null) {
            return;
        }
        if (conf.getRevision() <= this.loadedRevision) {
            return;
        }
        this.createFromLdap(false);
    }

    private String confDir() {
        String confDir = this.getLdapConfiguration().getString("confDir", null);
        if (StringUtils.isNotBlank((String)confDir)) {
            return confDir;
        }
        return DIR;
    }

    public FileConfiguration getLdapConfiguration() {
        return this.ldapConfiguration;
    }

    @Produces
    @ApplicationScoped
    public AppConfiguration getAppConfiguration() {
        return this.conf;
    }

    @Produces
    @ApplicationScoped
    public StaticConfiguration getStaticConfiguration() {
        return this.staticConf;
    }

    @Produces
    @ApplicationScoped
    public WebKeysConfiguration getWebKeysConfiguration() {
        return this.jwks;
    }

    @Produces
    @ApplicationScoped
    public ErrorResponseFactory getErrorResponseFactory() {
        return this.errorResponseFactory;
    }

    public BaseDnConfiguration getBaseDn() {
        return this.getStaticConfiguration().getBaseDn();
    }

    public String getCryptoConfigurationSalt() {
        return this.cryptoConfigurationSalt;
    }

    private boolean createFromFile() {
        boolean result = this.reloadConfFromFile() && this.reloadErrorsFromFile() && this.reloadStaticConfFromFile() && this.reloadWebkeyFromFile();
        return result;
    }

    private boolean reloadWebkeyFromFile() {
        WebKeysConfiguration webKeysFromFile = this.loadWebKeysFromFile();
        if (webKeysFromFile != null) {
            this.log.info("Reloaded web keys from file: " + this.webKeysFilePath);
            this.jwks = webKeysFromFile;
            return true;
        }
        this.log.error("Failed to load web keys configuration from file: " + this.webKeysFilePath);
        return false;
    }

    private boolean reloadStaticConfFromFile() {
        StaticConfiguration staticConfFromFile = this.loadStaticConfFromFile();
        if (staticConfFromFile != null) {
            this.log.info("Reloaded static conf from file: " + this.staticConfFilePath);
            this.staticConf = staticConfFromFile;
            return true;
        }
        this.log.error("Failed to load static configuration from file: " + this.staticConfFilePath);
        return false;
    }

    private boolean reloadErrorsFromFile() {
        ErrorMessages errorsFromFile = this.loadErrorsFromFile();
        if (errorsFromFile != null) {
            this.log.info("Reloaded errors from file: " + this.errorsFilePath);
            this.errorResponseFactory = new ErrorResponseFactory(errorsFromFile);
            return true;
        }
        this.log.error("Failed to load errors from file: " + this.errorsFilePath);
        return false;
    }

    private boolean reloadConfFromFile() {
        AppConfiguration configFromFile = this.loadConfFromFile();
        if (configFromFile != null) {
            this.log.info("Reloaded configuration from file: " + this.configFilePath);
            this.conf = configFromFile;
            return true;
        }
        this.log.error("Failed to load configuration from file: " + this.configFilePath);
        return false;
    }

    private boolean createFromLdap(boolean recoverFromFiles) {
        this.log.info("Loading configuration from LDAP...");
        try {
            Conf c = this.loadConfigurationFromLdap(new String[0]);
            if (c != null) {
                this.init(c);
                if (this.loaded) {
                    this.destroy(AppConfiguration.class);
                    this.destroy(StaticConfiguration.class);
                    this.destroy(WebKeysConfiguration.class);
                    this.destroy(ErrorResponseFactory.class);
                }
                this.loaded = true;
                this.configurationUpdateEvent.select(new Annotation[]{ConfigurationUpdate.Literal.INSTANCE}).fire((Object)this.conf);
                return true;
            }
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
        if (recoverFromFiles) {
            this.log.info("Unable to find configuration in LDAP, try to load configuration from file system... ");
            if (this.createFromFile()) {
                this.loadedFromLdap = false;
                return true;
            }
        }
        return false;
    }

    public void destroy(Class<? extends Configuration> clazz) {
        Instance confInstance = this.configurationInstance.select(clazz, new Annotation[0]);
        this.configurationInstance.destroy(confInstance.get());
    }

    private Conf loadConfigurationFromLdap(String ... returnAttributes) {
        LdapEntryManager ldapManager = (LdapEntryManager)this.ldapEntryManagerInstance.get();
        String dn = this.getLdapConfiguration().getString("oxauth_ConfigurationEntryDN");
        try {
            Conf conf = (Conf)ldapManager.find(Conf.class, (Object)dn, returnAttributes);
            return conf;
        }
        catch (LdapMappingException ex) {
            this.log.error(ex.getMessage());
            return null;
        }
    }

    private void init(Conf p_conf) {
        this.initConfigurationFromJson(p_conf.getDynamic());
        this.initStaticConfigurationFromJson(p_conf.getStatics());
        this.initWebKeysFromJson(p_conf.getWebKeys());
        this.initErrorsFromJson(p_conf.getErrors());
        this.loadedRevision = p_conf.getRevision();
    }

    private void initWebKeysFromJson(String p_webKeys) {
        try {
            this.initJwksFromString(p_webKeys);
        }
        catch (Exception ex) {
            this.log.error("Failed to load JWKS. Attempting to generate new JWKS...", (Throwable)ex);
            String newWebKeys = null;
            try {
                JSONObject jsonObject = AbstractCryptoProvider.generateJwks((int)this.getAppConfiguration().getKeyRegenerationInterval(), (int)this.getAppConfiguration().getIdTokenLifetime(), (AppConfiguration)this.getAppConfiguration());
                newWebKeys = jsonObject.toString();
                this.initJwksFromString(newWebKeys);
                Conf conf = this.loadConfigurationFromLdap(new String[0]);
                conf.setWebKeys(newWebKeys);
                long nextRevision = conf.getRevision() + 1L;
                conf.setRevision(nextRevision);
                LdapEntryManager ldapManager = (LdapEntryManager)this.ldapEntryManagerInstance.get();
                ldapManager.merge((Object)conf);
                this.log.info("New JWKS generated successfully");
            }
            catch (Exception ex2) {
                this.log.error("Failed to re-generate JWKS keys", (Throwable)ex2);
            }
        }
    }

    public void initJwksFromString(String p_webKeys) throws IOException, JsonParseException, JsonMappingException {
        WebKeysConfiguration k = (WebKeysConfiguration)((Object)ServerUtil.createJsonMapper().readValue(p_webKeys, WebKeysConfiguration.class));
        if (k != null) {
            this.jwks = k;
        }
    }

    private void initStaticConfigurationFromJson(String p_statics) {
        try {
            StaticConfiguration c = (StaticConfiguration)ServerUtil.createJsonMapper().readValue(p_statics, StaticConfiguration.class);
            if (c != null) {
                this.staticConf = c;
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void initConfigurationFromJson(String p_configurationJson) {
        try {
            AppConfiguration c = (AppConfiguration)ServerUtil.createJsonMapper().readValue(p_configurationJson, AppConfiguration.class);
            if (c != null) {
                this.conf = c;
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void initErrorsFromJson(String p_errosAsJson) {
        try {
            ErrorMessages errorMessages = (ErrorMessages)ServerUtil.createJsonMapper().readValue(p_errosAsJson, ErrorMessages.class);
            if (errorMessages != null) {
                this.errorResponseFactory = new ErrorResponseFactory(errorMessages);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    private String loadLdapConfiguration(String ldapFileName) {
        try {
            this.ldapConfiguration = new FileConfiguration(ldapFileName);
            this.replaceWithSystemValues();
            File ldapFile = new File(ldapFileName);
            if (ldapFile.exists()) {
                this.ldapFileLastModifiedTime = ldapFile.lastModified();
            }
            return ldapFileName;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.ldapConfiguration = null;
            return null;
        }
    }

    private void replaceWithSystemValues() {
        Set<Map.Entry<Object, Object>> ldapProperties = this.ldapConfiguration.getProperties().entrySet();
        for (Map.Entry<Object, Object> ldapPropertyEntry : ldapProperties) {
            String ldapPropertyKey = (String)ldapPropertyEntry.getKey();
            if (System.getenv(ldapPropertyKey) == null) continue;
            ldapPropertyEntry.setValue(System.getenv(ldapPropertyKey));
        }
    }

    private String determineLdapConfigurationFileName() {
        File ldapFile = new File(LDAP_FILE_PATH);
        if (ldapFile.exists()) {
            return LDAP_FILE_PATH;
        }
        return LDAP_DEFAULT_FILE_PATH;
    }

    private AppConfiguration loadConfFromFile() {
        try {
            return (AppConfiguration)ServerUtil.createJsonMapper().readValue(new File(this.configFilePath), AppConfiguration.class);
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private ErrorMessages loadErrorsFromFile() {
        try {
            return (ErrorMessages)ServerUtil.createJsonMapper().readValue(new File(this.errorsFilePath), ErrorMessages.class);
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private StaticConfiguration loadStaticConfFromFile() {
        try {
            return (StaticConfiguration)ServerUtil.createJsonMapper().readValue(new File(this.staticConfFilePath), StaticConfiguration.class);
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private WebKeysConfiguration loadWebKeysFromFile() {
        try {
            return (WebKeysConfiguration)((Object)ServerUtil.createJsonMapper().readValue(new File(this.webKeysFilePath), WebKeysConfiguration.class));
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void loadCryptoConfigurationSalt() {
        try {
            FileConfiguration cryptoConfiguration = this.createFileConfiguration(this.saltFilePath, true);
            this.cryptoConfigurationSalt = cryptoConfiguration.getString("encodeSalt");
        }
        catch (Exception ex) {
            this.log.error("Failed to load configuration from {}", (Object)this.saltFilePath, (Object)ex);
            throw new ConfigurationException("Failed to load configuration from " + this.saltFilePath, (Throwable)ex);
        }
    }

    private FileConfiguration createFileConfiguration(String fileName, boolean isMandatory) {
        try {
            FileConfiguration fileConfiguration = new FileConfiguration(fileName);
            return fileConfiguration;
        }
        catch (Exception ex) {
            if (isMandatory) {
                this.log.error("Failed to load configuration from {}", (Object)fileName, (Object)ex);
                throw new ConfigurationException("Failed to load configuration from " + fileName, (Throwable)ex);
            }
            return null;
        }
    }

    public String getFacesMapping() {
        return this.facesMapping;
    }

    public String getContextPath() {
        return this.contextPath;
    }
}

