/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.common;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.persistence.Transient;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapDN;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapJsonObject;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;
import org.xdi.oxauth.model.common.SessionIdAccessMap;
import org.xdi.oxauth.model.common.SessionIdState;

@Named(value="sessionUser")
@LdapEntry
@LdapObjectClass(values={"top", "oxAuthSessionId"})
public class SessionId
implements Serializable {
    private static final long serialVersionUID = -237476411915686378L;
    @LdapDN
    private String dn;
    @LdapAttribute(name="oxAuthSessionId")
    private String id;
    @LdapAttribute(name="oxLastAccessTime")
    private Date lastUsedAt;
    @LdapAttribute(name="oxAuthUserDN")
    private String userDn;
    @LdapAttribute(name="oxAuthAuthenticationTime")
    private Date authenticationTime;
    @LdapAttribute(name="oxState")
    private SessionIdState state;
    @LdapAttribute(name="oxAuthSessionState")
    private String sessionState;
    @LdapAttribute(name="oxAuthPermissionGranted")
    private Boolean permissionGranted;
    @LdapAttribute(name="oxAsJwt")
    private Boolean isJwt = false;
    @LdapAttribute(name="oxJwt")
    private String jwt;
    @LdapJsonObject
    @LdapAttribute(name="oxAuthPermissionGrantedMap")
    private SessionIdAccessMap permissionGrantedMap;
    @LdapJsonObject
    @LdapAttribute(name="oxInvolvedClients")
    private SessionIdAccessMap involvedClients;
    @LdapJsonObject
    @LdapAttribute(name="oxAuthSessionAttribute")
    private Map<String, String> sessionAttributes;
    @Transient
    private transient boolean persisted;

    public String getDn() {
        return this.dn;
    }

    public void setDn(String p_dn) {
        this.dn = p_dn;
    }

    public String getJwt() {
        return this.jwt;
    }

    public void setJwt(String jwt) {
        this.jwt = jwt;
    }

    public Boolean getIsJwt() {
        return this.isJwt;
    }

    public void setIsJwt(Boolean isJwt) {
        this.isJwt = isJwt;
    }

    public SessionIdAccessMap getInvolvedClients() {
        if (this.involvedClients == null) {
            this.involvedClients = new SessionIdAccessMap();
        }
        return this.involvedClients;
    }

    public void setInvolvedClients(SessionIdAccessMap involvedClients) {
        this.involvedClients = involvedClients;
    }

    public SessionIdState getState() {
        return this.state;
    }

    public void setState(SessionIdState state) {
        this.state = state;
    }

    public String getSessionState() {
        return this.sessionState;
    }

    public void setSessionState(String sessionState) {
        this.sessionState = sessionState;
    }

    public String getOPBrowserState() {
        return this.sessionAttributes.get("opbs");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String p_id) {
        this.id = p_id;
    }

    public Date getLastUsedAt() {
        return this.lastUsedAt;
    }

    public void setLastUsedAt(Date p_lastUsedAt) {
        this.lastUsedAt = p_lastUsedAt;
    }

    public String getUserDn() {
        return this.userDn;
    }

    public void setUserDn(String p_userDn) {
        this.userDn = p_userDn != null ? p_userDn : "";
    }

    public Date getAuthenticationTime() {
        return this.authenticationTime;
    }

    public void setAuthenticationTime(Date authenticationTime) {
        this.authenticationTime = authenticationTime;
    }

    public Boolean getPermissionGranted() {
        return this.permissionGranted;
    }

    public void setPermissionGranted(Boolean permissionGranted) {
        this.permissionGranted = permissionGranted;
    }

    public SessionIdAccessMap getPermissionGrantedMap() {
        return this.permissionGrantedMap;
    }

    public void setPermissionGrantedMap(SessionIdAccessMap permissionGrantedMap) {
        this.permissionGrantedMap = permissionGrantedMap;
    }

    public Boolean isPermissionGrantedForClient(String clientId) {
        return this.permissionGrantedMap != null && this.permissionGrantedMap.get(clientId) != false;
    }

    public void addPermission(String clientId, Boolean granted) {
        if (this.permissionGrantedMap == null) {
            this.permissionGrantedMap = new SessionIdAccessMap();
        }
        this.permissionGrantedMap.put(clientId, granted);
    }

    @Nonnull
    public Map<String, String> getSessionAttributes() {
        if (this.sessionAttributes == null) {
            this.sessionAttributes = Maps.newHashMap();
        }
        return this.sessionAttributes;
    }

    public void setSessionAttributes(Map<String, String> sessionAttributes) {
        this.sessionAttributes = sessionAttributes;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionId id1 = (SessionId)o;
        return !(this.id == null ? id1.id != null : !this.id.equals(id1.id));
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SessionState {");
        sb.append("dn='").append(this.dn).append('\'');
        sb.append(", id='").append(this.id).append('\'');
        sb.append(", lastUsedAt=").append(this.lastUsedAt);
        sb.append(", userDn='").append(this.userDn).append('\'');
        sb.append(", authenticationTime=").append(this.authenticationTime);
        sb.append(", state=").append((Object)this.state);
        sb.append(", sessionState='").append(this.sessionState).append('\'');
        sb.append(", permissionGranted=").append(this.permissionGranted);
        sb.append(", isJwt=").append(this.isJwt);
        sb.append(", jwt=").append(this.jwt);
        sb.append(", permissionGrantedMap=").append(this.permissionGrantedMap);
        sb.append(", involvedClients=").append(this.involvedClients);
        sb.append(", sessionAttributes=").append(this.sessionAttributes);
        sb.append(", persisted=").append(this.persisted);
        sb.append("}");
        return sb.toString();
    }
}

