/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.common;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.Set;
import javax.enterprise.inject.Instance;
import org.apache.commons.lang.StringUtils;
import org.xdi.oxauth.model.common.AbstractAuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationCode;
import org.xdi.oxauth.model.common.AuthorizationCodeGrant;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.registration.Client;

public class CacheGrant
implements Serializable {
    private String authorizationCodeString;
    private Date authorizationCodeCreationDate;
    private Date authorizationCodeExpirationDate;
    private User user;
    private Client client;
    private Date authenticationTime;
    private Set<String> scopes;
    private String grantId;
    private String tokenBindingHash;
    private String nonce;
    private String codeChallenge;
    private String codeChallengeMethod;
    private String claims;
    private String acrValues;
    private String sessionDn;
    private int expiresIn = 1;

    public CacheGrant() {
    }

    public CacheGrant(AuthorizationGrant grant, AppConfiguration appConfiguration) {
        if (grant.getAuthorizationCode() != null) {
            this.authorizationCodeString = grant.getAuthorizationCode().getCode();
            this.authorizationCodeCreationDate = grant.getAuthorizationCode().getCreationDate();
            this.authorizationCodeExpirationDate = grant.getAuthorizationCode().getExpirationDate();
        }
        this.initExpiresIn(grant, appConfiguration);
        this.user = grant.getUser();
        this.client = grant.getClient();
        this.authenticationTime = grant.getAuthenticationTime();
        this.scopes = grant.getScopes();
        this.tokenBindingHash = grant.getTokenBindingHash();
        this.grantId = grant.getGrantId();
        this.nonce = grant.getNonce();
        this.acrValues = grant.getAcrValues();
        this.codeChallenge = grant.getCodeChallenge();
        this.codeChallengeMethod = grant.getCodeChallengeMethod();
        this.claims = grant.getClaims();
        this.sessionDn = grant.getSessionDn();
    }

    private void initExpiresIn(AuthorizationGrant grant, AppConfiguration appConfiguration) {
        if (grant.getAuthorizationCode() != null) {
            this.expiresIn = grant.getAuthorizationCode().getExpiresIn();
        } else {
            this.expiresIn = appConfiguration.getAccessTokenLifetime();
            if (this.client != null && this.client.getAccessTokenLifetime() != null && this.client.getAccessTokenLifetime() > 0) {
                this.expiresIn = this.client.getAccessTokenLifetime();
            }
        }
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public Date getAuthorizationCodeCreationDate() {
        return this.authorizationCodeCreationDate;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }

    public String getGrantId() {
        return this.grantId;
    }

    public void setGrantId(String grantId) {
        this.grantId = grantId;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public Date getAuthenticationTime() {
        return this.authenticationTime;
    }

    public void setAuthenticationTime(Date authenticationTime) {
        this.authenticationTime = authenticationTime;
    }

    public String getAuthorizationCodeString() {
        return this.authorizationCodeString;
    }

    public void setAuthorizationCodeString(String authorizationCodeString) {
        this.authorizationCodeString = authorizationCodeString;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public void setCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public String getClaims() {
        return this.claims;
    }

    public void setClaims(String claims) {
        this.claims = claims;
    }

    public String getAcrValues() {
        return this.acrValues;
    }

    public void setAcrValues(String acrValues) {
        this.acrValues = acrValues;
    }

    public String getSessionDn() {
        return this.sessionDn;
    }

    public void setSessionDn(String sessionDn) {
        this.sessionDn = sessionDn;
    }

    public AuthorizationCodeGrant asCodeGrant(Instance<AbstractAuthorizationGrant> grantInstance) {
        AuthorizationCodeGrant grant = (AuthorizationCodeGrant)grantInstance.select(AuthorizationCodeGrant.class, new Annotation[0]).get();
        grant.init(this.user, this.client, this.authenticationTime);
        grant.setAuthorizationCode(new AuthorizationCode(this.authorizationCodeString, this.authorizationCodeCreationDate, this.authorizationCodeExpirationDate));
        grant.setScopes(this.scopes);
        grant.setGrantId(this.grantId);
        grant.setSessionDn(this.sessionDn);
        grant.setCodeChallenge(this.codeChallenge);
        grant.setCodeChallengeMethod(this.codeChallengeMethod);
        grant.setAcrValues(this.acrValues);
        grant.setNonce(this.nonce);
        grant.setClaims(this.claims);
        return grant;
    }

    public String cacheKey() {
        return CacheGrant.cacheKey(this.client.getClientId(), this.authorizationCodeString, this.grantId);
    }

    public static String cacheKey(String clientId, String code, String grantId) {
        if (StringUtils.isBlank((String)code)) {
            return grantId;
        }
        return clientId + "_" + code;
    }

    public String toString() {
        return "MemcachedGrant{authorizationCode=" + this.authorizationCodeString + ", user=" + this.user + ", client=" + this.client + ", authenticationTime=" + this.authenticationTime + '}';
    }
}

