/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.common;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.xdi.oxauth.model.authorize.JwtAuthorizationRequest;
import org.xdi.oxauth.model.common.AbstractAuthorizationGrant;
import org.xdi.oxauth.model.common.AccessToken;
import org.xdi.oxauth.model.common.AuthorizationCode;
import org.xdi.oxauth.model.common.AuthorizationCodeGrant;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantType;
import org.xdi.oxauth.model.common.CacheGrant;
import org.xdi.oxauth.model.common.ClientCredentialsGrant;
import org.xdi.oxauth.model.common.IAuthorizationGrantList;
import org.xdi.oxauth.model.common.IdToken;
import org.xdi.oxauth.model.common.ImplicitGrant;
import org.xdi.oxauth.model.common.RefreshToken;
import org.xdi.oxauth.model.common.ResourceOwnerPasswordCredentialsGrant;
import org.xdi.oxauth.model.common.SimpleAuthorizationGrant;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.configuration.AppConfiguration;
import org.xdi.oxauth.model.ldap.TokenLdap;
import org.xdi.oxauth.model.ldap.TokenType;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.GrantService;
import org.xdi.oxauth.service.UserService;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.oxauth.util.TokenHashUtil;
import org.xdi.service.CacheService;

@Dependent
public class AuthorizationGrantList
implements IAuthorizationGrantList {
    @Inject
    private Logger log;
    @Inject
    private Instance<AbstractAuthorizationGrant> grantInstance;
    @Inject
    private GrantService grantService;
    @Inject
    private UserService userService;
    @Inject
    private ClientService clientService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private CacheService cacheService;

    @Override
    public void removeAuthorizationGrants(List<AuthorizationGrant> authorizationGrants) {
        if (authorizationGrants != null && !authorizationGrants.isEmpty()) {
            for (AuthorizationGrant r : authorizationGrants) {
                this.grantService.remove(r);
            }
        }
    }

    @Override
    public AuthorizationGrant createAuthorizationGrant(User user, Client client, Date authenticationTime) {
        AuthorizationGrant grant = (AuthorizationGrant)this.grantInstance.select(SimpleAuthorizationGrant.class, new Annotation[0]).get();
        grant.init(user, null, client, authenticationTime);
        return grant;
    }

    @Override
    public AuthorizationCodeGrant createAuthorizationCodeGrant(User user, Client client, Date authenticationTime) {
        AuthorizationCodeGrant grant = (AuthorizationCodeGrant)this.grantInstance.select(AuthorizationCodeGrant.class, new Annotation[0]).get();
        grant.init(user, client, authenticationTime);
        CacheGrant memcachedGrant = new CacheGrant(grant, this.appConfiguration);
        this.cacheService.put(Integer.toString(grant.getAuthorizationCode().getExpiresIn()), memcachedGrant.cacheKey(), (Object)memcachedGrant);
        this.log.trace("Put authorization grant in cache, code: " + grant.getAuthorizationCode().getCode() + ", clientId: " + grant.getClientId());
        return grant;
    }

    @Override
    public ImplicitGrant createImplicitGrant(User user, Client client, Date authenticationTime) {
        ImplicitGrant grant = (ImplicitGrant)this.grantInstance.select(ImplicitGrant.class, new Annotation[0]).get();
        grant.init(user, client, authenticationTime);
        return grant;
    }

    @Override
    public ClientCredentialsGrant createClientCredentialsGrant(User user, Client client) {
        ClientCredentialsGrant grant = (ClientCredentialsGrant)this.grantInstance.select(ClientCredentialsGrant.class, new Annotation[0]).get();
        grant.init(user, client);
        return grant;
    }

    @Override
    public ResourceOwnerPasswordCredentialsGrant createResourceOwnerPasswordCredentialsGrant(User user, Client client) {
        ResourceOwnerPasswordCredentialsGrant grant = (ResourceOwnerPasswordCredentialsGrant)this.grantInstance.select(ResourceOwnerPasswordCredentialsGrant.class, new Annotation[0]).get();
        grant.init(user, client);
        return grant;
    }

    @Override
    public AuthorizationCodeGrant getAuthorizationCodeGrant(String clientId, String authorizationCode) {
        Object cachedGrant = this.cacheService.get(null, CacheGrant.cacheKey(clientId, authorizationCode, null));
        if (cachedGrant == null) {
            cachedGrant = this.cacheService.get(null, CacheGrant.cacheKey(clientId, authorizationCode, null));
            this.log.trace("Failed to fetch authorization grant from cache, code: " + authorizationCode + ", clientId: " + clientId);
        }
        return cachedGrant instanceof CacheGrant ? ((CacheGrant)cachedGrant).asCodeGrant(this.grantInstance) : null;
    }

    @Override
    public AuthorizationGrant getAuthorizationGrantByRefreshToken(String clientId, String refreshTokenCode) {
        if (!ServerUtil.isTrue(this.appConfiguration.getPersistRefreshTokenInLdap())) {
            return this.assertTokenType((TokenLdap)this.cacheService.get(null, TokenHashUtil.getHashedToken(refreshTokenCode)), TokenType.REFRESH_TOKEN);
        }
        return this.assertTokenType(this.grantService.getGrantsByCodeAndClient(refreshTokenCode, clientId), TokenType.REFRESH_TOKEN);
    }

    public AuthorizationGrant assertTokenType(TokenLdap tokenLdap, TokenType tokenType) {
        if (tokenLdap != null && tokenLdap.getTokenTypeEnum() == tokenType) {
            return this.asGrant(tokenLdap);
        }
        return null;
    }

    @Override
    public List<AuthorizationGrant> getAuthorizationGrant(String clientId) {
        ArrayList<AuthorizationGrant> result = new ArrayList<AuthorizationGrant>();
        try {
            ArrayList<TokenLdap> entries = new ArrayList<TokenLdap>();
            entries.addAll(this.grantService.getGrantsOfClient(clientId));
            entries.addAll(this.grantService.getCacheClientTokensEntries(clientId));
            for (TokenLdap t : entries) {
                AuthorizationGrant grant = this.asGrant(t);
                if (grant == null) continue;
                result.add(grant);
            }
        }
        catch (Exception e) {
            this.log.trace(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    public AuthorizationGrant getAuthorizationGrantByAccessToken(String accessToken) {
        return this.getAuthorizationGrantByAccessToken(accessToken, false);
    }

    public AuthorizationGrant getAuthorizationGrantByAccessToken(String accessToken, boolean onlyFromCache) {
        TokenLdap tokenLdap = this.grantService.getGrantsByCode(accessToken, onlyFromCache);
        if (tokenLdap != null && (tokenLdap.getTokenTypeEnum() == TokenType.ACCESS_TOKEN || tokenLdap.getTokenTypeEnum() == TokenType.LONG_LIVED_ACCESS_TOKEN)) {
            return this.asGrant(tokenLdap);
        }
        return null;
    }

    @Override
    public AuthorizationGrant getAuthorizationGrantByIdToken(String idToken) {
        TokenLdap tokenLdap = this.grantService.getGrantsByCode(idToken);
        if (tokenLdap != null && tokenLdap.getTokenTypeEnum() == TokenType.ID_TOKEN) {
            return this.asGrant(tokenLdap);
        }
        return null;
    }

    public AuthorizationGrant load(String clientId, String p_code) {
        return this.asGrant(this.grantService.getGrantsByCodeAndClient(p_code, clientId));
    }

    public String extractClientIdFromTokenDn(String p_dn) {
        try {
            Object[] rdNs;
            if (StringUtils.isNotBlank((String)p_dn) && ArrayUtils.isNotEmpty((Object[])(rdNs = DN.getRDNs((String)p_dn)))) {
                for (Object r : rdNs) {
                    Object[] values;
                    Object[] names = r.getAttributeNames();
                    if (!ArrayUtils.isNotEmpty((Object[])names) || !Arrays.asList(names).contains("inum") || !ArrayUtils.isNotEmpty((Object[])(values = r.getAttributeValues()))) continue;
                    return values[0];
                }
            }
        }
        catch (LDAPException e) {
            this.log.trace(e.getMessage(), (Throwable)e);
        }
        return "";
    }

    public AuthorizationGrant asGrant(TokenLdap tokenLdap) {
        AuthorizationGrantType grantType;
        if (tokenLdap != null && (grantType = AuthorizationGrantType.fromString(tokenLdap.getGrantType())) != null) {
            AuthorizationGrant result;
            User user = this.userService.getUser(tokenLdap.getUserId(), new String[0]);
            Client client = this.clientService.getClient(this.extractClientIdFromTokenDn(tokenLdap.getDn()));
            Date authenticationTime = tokenLdap.getAuthenticationTime();
            String nonce = tokenLdap.getNonce();
            switch (grantType) {
                case AUTHORIZATION_CODE: {
                    AuthorizationCodeGrant authorizationCodeGrant = (AuthorizationCodeGrant)this.grantInstance.select(AuthorizationCodeGrant.class, new Annotation[0]).get();
                    authorizationCodeGrant.init(user, client, authenticationTime);
                    result = authorizationCodeGrant;
                    break;
                }
                case CLIENT_CREDENTIALS: {
                    ClientCredentialsGrant clientCredentialsGrant = (ClientCredentialsGrant)this.grantInstance.select(ClientCredentialsGrant.class, new Annotation[0]).get();
                    clientCredentialsGrant.init(user, client);
                    result = clientCredentialsGrant;
                    break;
                }
                case IMPLICIT: {
                    ImplicitGrant implicitGrant = (ImplicitGrant)this.grantInstance.select(ImplicitGrant.class, new Annotation[0]).get();
                    implicitGrant.init(user, client, authenticationTime);
                    result = implicitGrant;
                    break;
                }
                case RESOURCE_OWNER_PASSWORD_CREDENTIALS: {
                    ResourceOwnerPasswordCredentialsGrant resourceOwnerPasswordCredentialsGrant = (ResourceOwnerPasswordCredentialsGrant)this.grantInstance.select(ResourceOwnerPasswordCredentialsGrant.class, new Annotation[0]).get();
                    resourceOwnerPasswordCredentialsGrant.init(user, client);
                    result = resourceOwnerPasswordCredentialsGrant;
                    break;
                }
                default: {
                    return null;
                }
            }
            String grantId = tokenLdap.getGrantId();
            String jwtRequest = tokenLdap.getJwtRequest();
            String authMode = tokenLdap.getAuthMode();
            String sessionDn = tokenLdap.getSessionDn();
            String claims = tokenLdap.getClaims();
            result.setTokenBindingHash(tokenLdap.getTokenBindingHash());
            result.setNonce(nonce);
            result.setTokenLdap(tokenLdap);
            if (StringUtils.isNotBlank((String)grantId)) {
                result.setGrantId(grantId);
            }
            result.setScopes(Util.splittedStringAsList((String)tokenLdap.getScope(), (String)" "));
            result.setCodeChallenge(tokenLdap.getCodeChallenge());
            result.setCodeChallengeMethod(tokenLdap.getCodeChallengeMethod());
            if (StringUtils.isNotBlank((String)jwtRequest)) {
                try {
                    result.setJwtAuthorizationRequest(new JwtAuthorizationRequest(this.appConfiguration, jwtRequest, client));
                }
                catch (Exception e) {
                    this.log.trace(e.getMessage(), (Throwable)e);
                }
            }
            result.setAcrValues(authMode);
            result.setSessionDn(sessionDn);
            result.setClaims(claims);
            if (tokenLdap.getTokenTypeEnum() != null) {
                switch (tokenLdap.getTokenTypeEnum()) {
                    case AUTHORIZATION_CODE: {
                        if (!(result instanceof AuthorizationCodeGrant)) break;
                        AuthorizationCode code = new AuthorizationCode(tokenLdap.getTokenCode(), tokenLdap.getCreationDate(), tokenLdap.getExpirationDate());
                        AuthorizationCodeGrant g = (AuthorizationCodeGrant)result;
                        g.setAuthorizationCode(code);
                        break;
                    }
                    case REFRESH_TOKEN: {
                        RefreshToken refreshToken = new RefreshToken(tokenLdap.getTokenCode(), tokenLdap.getCreationDate(), tokenLdap.getExpirationDate());
                        result.setRefreshTokens(Arrays.asList(refreshToken));
                        break;
                    }
                    case ACCESS_TOKEN: {
                        AccessToken accessToken = new AccessToken(tokenLdap.getTokenCode(), tokenLdap.getCreationDate(), tokenLdap.getExpirationDate());
                        result.setAccessTokens(Arrays.asList(accessToken));
                        break;
                    }
                    case ID_TOKEN: {
                        IdToken idToken = new IdToken(tokenLdap.getTokenCode(), tokenLdap.getCreationDate(), tokenLdap.getExpirationDate());
                        result.setIdToken(idToken);
                        break;
                    }
                    case LONG_LIVED_ACCESS_TOKEN: {
                        AccessToken longLivedAccessToken = new AccessToken(tokenLdap.getTokenCode(), tokenLdap.getCreationDate(), tokenLdap.getExpirationDate());
                        result.setLongLivedAccessToken(longLivedAccessToken);
                    }
                }
            }
            return result;
        }
        return null;
    }
}

